require 'test_helper'

class AccessAchievementJsonTest < ActionDispatch::IntegrationTest
  setup do
    @user = FactoryGirl.create :user
    @auth_token = @user.authentication_token
    @task = FactoryGirl.create :task
  end

  test 'get achievements' do
    get "/achievements.json", :auth_token => @auth_token
    assert_response :success
    as = JSON.parse @response.body
    assert_equal as.map { |a| a['id'] }.sort, @user.achievements.map(&:id).sort
  end

  test 'add an achievement' do
    post "/achievements.json", :auth_token => @auth_token, :achievement => { :task_id => @task.id, :result => '100' }
    assert_response :created
    j = JSON.parse @response.body
    assert_equal j['user_id'], @user.id
  end

  test 'update an achievement' do
    post '/achievements.json', :auth_token => @auth_token, :achievement => { :task_id => @task.id, :result => '1, 4, 7' }
    assert_response :created
    achievement = JSON.parse @response.body

    put "/achievements/#{achievement['id']}.json", :auth_token => @auth_token, :achievement => { :result => '2,0,10' }
    assert_response :success

    get "/achievements/#{achievement['id']}.json", :auth_token => @auth_token
    alt = JSON.parse @response.body
    assert_equal '2,4,10', alt['result']
  end

  test 'failed to update an achievement' do
    post '/achievements.json', :auth_token => @auth_token, :achievement => { :task_id => @task.id, :result => '1, 4, 7' }
    assert_response :created
    achievement = JSON.parse @response.body

    put "/achievements/#{achievement['id']}.json", :auth_token => @auth_token, :achievement => { :result => '2,0' }
    assert_response 422
    j = JSON.parse @response.body
    assert j.has_key?('result')

    get "/achievements/#{achievement['id']}.json", :auth_token => @auth_token
    alt = JSON.parse @response.body
    assert_equal achievement['result'], alt['result']
  end

  test 'create new achievement via /tasks/:task_id/achievement' do
    assert_difference('Achievement.count') do
      put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '1, 4, 7' }
    end
    assert_response :success
    achievement = JSON.parse @response.body
    assert_equal achievement['task_id'], @task.id
  end
end
