class Teacher < ActiveRecord::Base
  # Include default devise modules. Others available are:
  # :token_authenticatable, :confirmable,
  # :lockable, :timeoutable and :omniauthable
  devise :database_authenticatable, :registerable,
         :recoverable, :rememberable, :trackable, :validatable

  # Setup accessible (or protected) attributes for your model
  attr_accessible :email, :password, :password_confirmation, :remember_me

  has_many :lectures
  attr_accessible :name

  include JsonWithoutTimestamps

  def achievements
    lectures.flat_map do |l|
      l.tasks.flat_map do |t|
        t.all_achievements
      end
    end
  end
end
