class Achievement < ActiveRecord::Base
  belongs_to :user
  belongs_to :task
  attr_accessible :result
  attr_accessible :task_id

  validates_uniqueness_of :task_id, :scope => :user_id
  validate :validate_results

  def results
    split_result result
  end

  def split_result(r)
    r && r.split(',').map(&:to_i)
  end
  private :split_result

  def validate_results
    if result.nil?
      errors.add :result, 'is nil'
      return
    end

    xs = result.split(/\s*,\s*/).map do |x|
      if x != x.to_i.to_s
        errors.add :result, "has a non-integer element #{x}"
      end
      x = x.to_i

      if !x.between? 0, 100
        errors.add :result, "has an out-of-range element #{x}"
      end
      x
    end

    if xs.empty?
      errors.add :result, 'is empty'
    end

    begin
      was = split_result result_was
      self['result'] = Achievement.merge(was, xs).join(',')
    rescue MergeError
      errors.add :result, 'encountered invalid merge'
    end
  end

  class MergeError < StandardError; end

  def self.merge(xs, ys)
    if xs.nil?
      ys
    elsif ys.nil?
      xs
    elsif xs.size != ys.size
      raise MergeError
    else
      xs.zip(ys).map &:max
    end
  end
end
