class TasksController < ApplicationController
  # GET /tasks/1
  # GET /tasks/1.json
  def show
    @task = Task.find(params[:id])

    respond_to do |format|
      format.html
      format.json { render json: @task }
    end
  end

  # GET /lectures/:lecture_id/tasks/new
  def new
    respond_to do |format|
      @task = Task.new
      @task.lecture = Lecture.find params[:lecture_id]

      if user_signed_in?
        format.html { redirect_to @task.lecture, :alert => I18n.t('teacher.not') }
      else
        authenticate_teacher!
        @apk = Apk.new
        if @task.lecture.teacher.id == current_teacher.id
          format.html # new.html.haml
        else
          format.html { redirect_to @task.lecture, :alert => I18n.t('task.create.unauthorized') }
        end
      end
    end
  end

  # POST /lectures/:lecture_id/tasks
  def create
    respond_to do |format|
      @task = Task.new params[:task]
      @task.lecture = Lecture.find params[:lecture_id]

      if user_signed_in?
        format.html { redirect_to @task.lecture, :alert => I18n.t('teacher.not') }
      else
        authenticate_teacher!
        @apk = Apk.new params[:apk]
        uploaded_file = params[:apkfile] && params[:apkfile][:file]
        @apk.task = @task
        @apk.revision = 1

        format.html do
          if @task.lecture.teacher.id == current_teacher.id
            # TODO: check if the uploaded apk is correct
            @task.valid?
            @apk.valid?
            if uploaded_file.nil?
              @apk.errors.add :apk, I18n.t('task.create.noapk')
            end
            if !@task.errors.any? and !@apk.errors.any?
              @task.save!
              @apk.save!
              @apk.store_file uploaded_file.tempfile
              redirect_to @task.lecture, :notice => I18n.t('task.create.success')
            else
              render :action => 'new'
            end
          else
            redirect_to @task.lecture, :alert => I18n.t('task.create.unauthorized')
          end
        end
      end
    end
  end

  # GET /tasks/:id/edit
  def edit
    @task = Task.find params[:id]
    @apk = @task.apk
  end

  # PUT /tasks/:id
  def update
    @task = Task.find params[:id]
    @apk = @task.apk
    uploaded_file = params[:apkfile] && params[:apkfile][:file]

    respond_to do |format|
      if user_signed_in?
        format.html { redirect_to @task, :alert => I18n.t('teacher.not') }
      else
        authenticate_teacher!
        if @task.lecture.teacher.id == current_teacher.id
          @task.attributes = params[:task]
          @apk.attributes = params[:apk]
          @task.valid?
          @apk.valid?
          if !@task.errors.any? and !@apk.errors.any?
            @task.save!
            @apk.save!
            if not uploaded_file.nil?
              @apk.store_file uploaded_file.tempfile
              @apk.incr_revision
              @apk.save!
            end
            format.html { redirect_to @task, :notice => I18n.t('task.update.success') }
          else
            format.html { render :action => :edit }
          end
        else
          format.html { redirect_to @task, :alert => I18n.t('task.update.unauthorized') }
        end
      end
    end
  end
end
