package jp.ac.titech.sharp4k.cuten.test;

import jp.ac.titech.sharp4k.cuten.DownloadActivity;
import jp.ac.titech.sharp4k.cuten.HttpAPIClient;
import jp.ac.titech.sharp4k.cuten.HttpResponseListener;
import jp.ac.titech.sharp4k.cuten.Lecture;
import jp.ac.titech.sharp4k.cuten.SQLHelper;
import jp.ac.titech.sharp4k.cuten.Teacher;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.database.sqlite.SQLiteDatabase;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;

import com.google.inject.AbstractModule;

public class NormalDownloadActivityTest extends
		ActivityTestCaseWithRobo<DownloadActivity> {
	public static class NormalModule extends AbstractModule {
		@Override
		protected void configure() {
			bind(HttpAPIClient.class).to(NormalHttpAPIClient.class);
		}
	}

	public static class NormalHttpAPIClient extends NullHttpAPIClient {
		public static final String DUMMY_LECTURES = "["
				+ "{\"id\":1001,\"name\":\"lec1\",\"teacher\":{\"id\":1001,\"name\":\"tea1\"}},"
				+ "{\"id\":1002,\"name\":\"lec2\",\"teacher\":{\"id\":1001,\"name\":\"tea1\"}}"
				+ "]";
		public static int getLecturesCalled = 0;

		@Override
		public void getLectures(HttpResponseListener listener) {
			listener.preExec();
			listener.onSuccess(DUMMY_LECTURES);
			listener.postExec();
			++getLecturesCalled;
		}
	}

	private DownloadActivity activity;
	private ListView lectureList;
	private ImageButton updateButton, okButton;
	private Button addModeButton, deleteModeButton;

	public NormalDownloadActivityTest() {
		super(DownloadActivity.class, new NormalModule());
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		Teacher t = new Teacher(1000, "tea0");
		Lecture l = new Lecture(1000, "lec0", t);
		Context ctx = getInstrumentation().getTargetContext();
		SQLiteDatabase db = new SQLHelper(ctx).getWritableDatabase();
		t.save(db);
		l.save(db);
		l.saveToSelected(db);
		db.close();

		activity = getActivity();
		waitUI();
		lectureList = (ListView) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.lectureList);
		updateButton = (ImageButton) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.update);
		okButton = (ImageButton) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.ok);
		addModeButton = (Button) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.add);
		deleteModeButton = (Button) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.delete);
	}

	public void testInitialViews() throws Exception {
		assertNotNull(lectureList);
		assertNotNull(okButton);

		// 登録モードでは2つの講義が表示されている
		assertEquals(2, lectureList.getChildCount());

		// 削除モードには1つの講義が表示されている
		assertNotNull(deleteModeButton);
		click(deleteModeButton);
		assertEquals(1, lectureList.getChildCount());

		assertNotNull(addModeButton);
		click(addModeButton);
		assertEquals(2, lectureList.getChildCount());
	}

	public void testClickUpdateButton() throws Exception {
		assertNotNull(lectureList);
		assertNotNull(updateButton);

		ListAdapter adapter = lectureList.getAdapter();
		int prevCount = adapter.getCount();
		int prevCalled = NormalHttpAPIClient.getLecturesCalled;

		click(updateButton);

		adapter = lectureList.getAdapter();
		assertEquals(prevCount, adapter.getCount());
		assertEquals(prevCalled + 1, NormalHttpAPIClient.getLecturesCalled);
	}

	public void testAddingLecture() throws Exception {
		assertNotNull(lectureList);
		assertNotNull(okButton);
		assertNotNull(addModeButton);
		assertNotNull(deleteModeButton);

		int prevAddCount = lectureList.getChildCount();
		click(deleteModeButton);
		int prevDelCount = lectureList.getChildCount();
		click(addModeButton);

		// 最初の講義をクリックして追加すると講義は1つ減る
		assertTrue(prevAddCount > 0);
		activity.runOnUiThread(new Runnable() {
			@Override
			public void run() {
				lectureList.setItemChecked(0, true);
				okButton.performClick();
			}
		});
		waitUI();
		assertEquals(prevAddCount - 1, lectureList.getChildCount());

		// 削除モードでは1つ増える
		click(deleteModeButton);
		assertEquals(prevDelCount + 1, lectureList.getChildCount());
	}

	public void testDeletingLecture() throws Exception {
		int prevAddCount = lectureList.getChildCount();
		click(deleteModeButton);
		int prevDelCount = lectureList.getChildCount();

		assertTrue(prevDelCount > 0);
		activity.runOnUiThread(new Runnable() {
			@Override
			public void run() {
				lectureList.setItemChecked(0, true);
				okButton.performClick();
			}
		});
		waitUI();
		assertEquals(prevDelCount - 1, lectureList.getChildCount());

		click(addModeButton);
		assertEquals(prevAddCount + 1, lectureList.getChildCount());
	}

	// SEE #29549
	public void testKeepCurrentModeAroundUpdate() throws Exception {
		assertNotNull(lectureList);
		assertNotNull(updateButton);
		assertNotNull(okButton);
		assertNotNull(deleteModeButton);

		click(deleteModeButton);
		int prev = okButton.getDrawable().hashCode();
		click(updateButton);
		assertEquals(prev, okButton.getDrawable().hashCode());
	}

	// SEE #29551
	public void testNoUpdateAroundOrientationChange() throws Exception {
		int prev = NormalHttpAPIClient.getLecturesCalled;
		activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
		waitUI();
		activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		waitUI();
		assertEquals(prev, NormalHttpAPIClient.getLecturesCalled);
	}

	// SEE #29550
	public void testOkButtonShouldNotBeResized() throws Exception {
		int prevHeight = okButton.getHeight();
		int prevWidth = okButton.getWidth();

		View v = lectureList.getChildAt(0);
		assertNotNull(v);
		activity.runOnUiThread(new Runnable() {
			@Override
			public void run() {
				lectureList.setItemChecked(0, true);
				okButton.performClick();
			}
		});
		waitUI();

		assertEquals(prevHeight, okButton.getHeight());
		assertEquals(prevWidth, okButton.getWidth());
	}
}
