package jp.ac.titech.sharp4k.cuten;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;

public class PandaAdapter<C extends PandaChild, G extends PandaGroup<C>>
		extends BaseExpandableListAdapter {

	public static final int GROUP_TYPE_COLLAPSED = 0;
	public static final int GROUP_TYPE_EXPANDED = 1;

	private List<G> groups;
	private List<Boolean> isGroupExpanded;
	private LayoutInflater inflater;

	public PandaAdapter(Context context, List<G> groups) {
		this.groups = groups;
		inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		isGroupExpanded = new ArrayList<Boolean>();
		for (int i = 0; i < groups.size(); i++) {
			isGroupExpanded.add(false);
		}
	}

	@Override
	public C getChild(int groupPosition, int childPosition) {
		return groups.get(groupPosition).getChildren().get(childPosition);
	}

	@Override
	public long getChildId(int groupPosition, int childPosition) {
		return childPosition;
	}

	private View newView(int layoutId, ViewGroup parent) {
		return inflater.inflate(layoutId, parent, false);
	}

	@Override
	public View getChildView(int groupPosition, int childPosition,
			boolean isLastChild, View convertView, ViewGroup parent) {
		View v = convertView;
		if (v == null) {
			v = newView(android.R.layout.simple_expandable_list_item_2, parent);
		}
		C c = groups.get(groupPosition).getChildren().get(childPosition);
		TextView tv1 = (TextView) v.findViewById(android.R.id.text1);
		TextView tv2 = (TextView) v.findViewById(android.R.id.text2);
		tv1.setText(c.getTitle());
		tv2.setText(c.getSummary());
		return v;
	}

	@Override
	public int getChildrenCount(int groupPosition) {
		return groups.get(groupPosition).getChildren().size();
	}

	@Override
	public G getGroup(int groupPosition) {
		return groups.get(groupPosition);
	}

	@Override
	public int getGroupCount() {
		return groups.size();
	}

	@Override
	public long getGroupId(int groupPosition) {
		return groupPosition;
	}

	@Override
	public View getGroupView(int groupPosition, boolean isExpanded,
			View convertView, ViewGroup parent) {
		View v = convertView;
		if (v == null) {
			v = newView(android.R.layout.simple_expandable_list_item_1, parent);
		}
		TextView tv = (TextView) v.findViewById(android.R.id.text1);
		tv.setText(groups.get(groupPosition).getLabel());
		return v;
	}

	@Override
	public boolean hasStableIds() {
		return true;
	}

	@Override
	public boolean isChildSelectable(int groupPosition, int childPosition) {
		return true;
	}

	@Override
	public int getChildTypeCount() {
		return 1;
	}

	@Override
	public int getChildType(int groupPosition, int childPosition) {
		return 0;
	}

	@Override
	public int getGroupTypeCount() {
		return 2;
	}

	@Override
	public int getGroupType(int groupPosition) {
		return isGroupExpanded.get(groupPosition) ? GROUP_TYPE_EXPANDED
				: GROUP_TYPE_COLLAPSED;
	}

	@Override
	public void onGroupCollapsed(int groupPosition) {
		isGroupExpanded.set(groupPosition, false);
	}

	@Override
	public void onGroupExpanded(int groupPosition) {
		isGroupExpanded.set(groupPosition, true);
	}

	public void addGroup(G group) {
		addGroup(groups.size(), group);
	}

	public void addGroup(int groupPosition, G group) {
		groups.add(groupPosition, group);
		isGroupExpanded.add(groupPosition, false);
		notifyDataSetChanged();
	}

	public G removeGroup(int groupPosition) {
		G group = groups.remove(groupPosition);
		isGroupExpanded.remove(groupPosition);
		notifyDataSetChanged();
		return group;
	}

	public void clear() {
		groups.clear();
		isGroupExpanded.clear();
		notifyDataSetChanged();
	}

	public void swapGroup(int groupPosition1, int groupPosition2) {
		G tmp = groups.get(groupPosition1);
		boolean b = isGroupExpanded.get(groupPosition1);
		groups.set(groupPosition1, groups.get(groupPosition2));
		isGroupExpanded
				.set(groupPosition1, isGroupExpanded.get(groupPosition2));
		groups.set(groupPosition2, tmp);
		isGroupExpanded.set(groupPosition2, b);
		notifyDataSetChanged();
	}

	public G mergeGroup(int groupPosition1, int groupPosition2) {
		G mergeTo = groups.get(groupPosition2);
		if (groupPosition1 != groupPosition2) {
			mergeTo.getChildren().addAll(
					groups.get(groupPosition1).getChildren());
			groups.remove(groupPosition1);
			isGroupExpanded.remove(groupPosition1);
			notifyDataSetChanged();
		}
		return mergeTo;
	}

	public void moveChild(int toGroup, int fromGroup, int fromChild) {
		C tmp = groups.get(fromGroup).getChildren().get(fromChild);
		groups.get(fromGroup).getChildren().remove(fromChild);
		groups.get(toGroup).getChildren().add(tmp);
		notifyDataSetChanged();
	}

	public List<G> getGroups() {
		return groups;
	}
}
