package jp.co.epson.watch.plaWasabi.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import jp.co.epson.watch.plaWasabi.dto.formConfig.Query;

import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XsdTest {
  private static final String QUERY_PATH = "/form-config/database/queries/query";

  @Test
  public void testXsd() throws NoSuchAlgorithmException, SAXException, IOException,
      XPathExpressionException, ParserConfigurationException {
    InputStream xml = Thread.currentThread().getContextClassLoader().getResourceAsStream(
        "config/kikaku-main.xml");

    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    factory.setValidating(false);
    DocumentBuilder builder = factory.newDocumentBuilder();

    Document document = builder.parse(xml);
    XPathFactory factory2 = XPathFactory.newInstance();
    XPath xpath = factory2.newXPath();

    Map<String, Query> map = this.getQueryMap(xpath, document);
    Query q = map.get("list");
    System.out.println(q.getQuery());
  }

  private Map<String, Query> getQueryMap(XPath xpath, Document document)
      throws XPathExpressionException {

    int count = Integer.parseInt(xpath.evaluate("count(" + QUERY_PATH + ")", document));
    HashMap<String, Query> res = new HashMap<String, Query>();
    for (int i = 0; i < count; i++) {
      String id = xpath.evaluate(QUERY_PATH + "[" + (i + 1) + "]/@id", document);
      String query = xpath.evaluate(QUERY_PATH + "[" + (i + 1) + "]/sql", document);
      Query q = new Query();
      q.setId(id);
      q.setQuery(query);
      res.put(id, q);
    }
    return res;
  }
}
