package jp.co.epson.watch.plaWasabi.test.service;

import java.util.List;
import java.util.Map;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.unit.S2Assert;

public class UnitTest extends S2TestCase {

  private JdbcManager jdbcManager;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    include("app.dicon");
  }

  public void testCount4Tx() {
    this.readXlsReplaceDb("init.xls");
    S2Assert.assertEquals(39, getData("kikaku").size());
    S2Assert.assertEquals(39, getData("kikaku2").size());
    S2Assert.assertEquals(39, getData("kikakus").size());
    S2Assert.assertEquals(66, getData("skikakub").size());
    S2Assert.assertEquals(64, getData("skikaku").size());
    S2Assert.assertEquals(64, getData("skikaku2").size());
    S2Assert.assertEquals(64, getData("skikakuc").size());
    S2Assert.assertEquals(64, getData("skikakus").size());
  }

  @SuppressWarnings("unchecked")
  private List<Map> getData(String table) {
    return this.jdbcManager.selectBySql(Map.class, "select * from " + table).getResultList();
  }

}