
/**
base_stx.js

function getAllElements();
function getFormElements(form);
function getElementByName(name);
function getElementByNameFromForm(form, name);
function getElementByNameFromDocument(name);
function getElementsByName(name);
function getElementsByNameFromForm(form, name);
function getElementsByNameFromDocument(name);
function getElementByName2(name);
function getElementsByName2(name);
function getDynamicTableElements();
function getNextFocusElement(element_focus, forward);
function getName(element);
function getValueByName(name);
function setValue(element, value);
function setValue2Hidden(name, name4hidden, value);
function round(value, nDecimal);
function isNumber(str_number);
function getNumber(str_number);
function getNumberByName(name);
function getInnerHTML(str);
function unlockForm(event, url);
function getValueType(str_value);
function getValue_daytime(str_value);
function checkDate2(year, month, day);
function checkTime2(hour, minute, second);

StraFormDesigner Ver1.5
Copyright(C) 2004-2008 FIT Corporation All Rights Reserved.

Last Update 2008/09/08
*/

/*@cc_on _d=document;eval('var document=_d')@*/

var browserType = 0;
// IEAOpera
if( document.all ){
  // IE
  if( !window.opera )
    browserType = 0;
  // Opera
  else
    browserType = 2;
// NetScapeAFireFox
} else if( document.getElementById ) {
  browserType = 1;
}

/** Elementz擾 */
function getAllElements(){
  var all = null;
  switch(browserType){
    // 
    case 0:
    case 2:
      all = document.all;
      break;

    // 
    case 1:
      all = document.getElementsByTagName("*");
      break;
  }

  return all;
}

/** tH[Elementz擾 */
function getFormElements(form){
  return form.elements;
}

/** tH[Element擾 */
function getElementByName(name){
  return getElementByNameFromForm(document.form, name);
}

/** tH[Element擾 */
function getElementByNameFromForm(form, name){
  var all = getFormElements(form);

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    if(all[ii].name == name)
      return all[ii];
  }

  return null;
}

/** hLgElement擾 */
function getElementByNameFromDocument(name){
  var all = getAllElements();

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    if(all[ii].attributes != null){
      var attr_name = all[ii].attributes.getNamedItem("name");
      if(attr_name != null && attr_name.nodeValue == name)
        return all[ii];
    }
  }

  return null;
}

/** tH[Elementz擾 */
function getElementsByName(name){
  return getElementsByNameFromForm(document.form, name);
}

/** tH[Elementz擾 */
function getElementsByNameFromForm(form, name){
  var index = 0;
  var elements = new Array();
  var all = getFormElements(form);

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    if(all[ii].name == name)
      elements[ index++ ] = all[ii];
  }

  if(index != 0)
    return elements;

  return null;
}

/** hLgElementz擾 */
function getElementsByNameFromDocument(name){
  var index = 0;
  var elements = new Array();
  var all = getAllElements();

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    if(all[ii].attributes != null){
      var attr_name = all[ii].attributes.getNamedItem("name");
      if(attr_name != null && attr_name.nodeValue == name)
        elements[ index++ ] = all[ii];
    }
  }

  if(index != 0)
    return elements;

  return null;
}

/** tH[Element擾 */
function getElementByName2(name){
  return document.getElementsByName(name)[0];
}

/** tH[Elementz擾 */
function getElementsByName2(name){
  var elements = document.getElementsByName(name);
  if(elements.length != 0)
    return elements;
  else
    return null;
}

/** ǉe[uElement擾 */
function getDynamicTableElements(){
  var all = getFormElements( document.form );

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    var element = all[ii];
    if(element.name == "TABLE_ID"){
      var elements = new Array();
      var strs_name = element.value.split(", ");

      var length_strs_name = strs_name.length;
      for(var jj = 0; jj < length_strs_name; jj++)
        elements[jj] = getElementByName2( strs_name[jj] );

      return elements;
    }
  }

  return null;
}

/** ɃtH[JXړElement擾 */
function getNextFocusElement(element_focus, forward){
  var tabIndex_focus = element_focus.tabIndex;
  var tabIndex_min = Number.MAX_VALUE;
  var tabIndex_max = Number.MIN_VALUE;
  var tabIndex_foward = Number.MAX_VALUE;
  var tabIndex_back = Number.MIN_VALUE;
  var element_min;
  var element_max;
  var element_foward;
  var element_back;
  var all = getAllElements();

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    var element = all[ii];

    var tagName = element.tagName;
    if((tagName == "INPUT" || tagName == "TEXTAREA" || tagName == "SELECT" || tagName == "SPAN" || tagName == "DIV" || tagName == "TD" || tagName == "TABLE") && element.className != "")
      ;
    else
      continue;

    var tabIndex = element.tabIndex;
    if(tabIndex != 0 && !element.disabled){
      if(element.attributes.getNamedItem("name").nodeValue != element_focus.attributes.getNamedItem("name").nodeValue){
        // ~
        if(forward){
          if(tabIndex < tabIndex_min){
            tabIndex_min = tabIndex;
            element_min = element;
          }

          if(tabIndex > tabIndex_focus && tabIndex < tabIndex_foward){
            tabIndex_foward = tabIndex;
            element_foward = element;
          }
        // 
        } else {
          if(tabIndex > tabIndex_max){
            tabIndex_max = tabIndex;
            element_max = element;
          }

          if(tabIndex < tabIndex_focus && tabIndex > tabIndex_back){
            tabIndex_back = tabIndex;
            element_back = element;
          }
        }
      }
    }
  }

  var element_nextFocus;

  // ~
  if(forward){
    element_nextFocus = element_foward;
    if(tabIndex_foward == Number.MAX_VALUE)
      element_nextFocus = element_min;
  // 
  } else {
    element_nextFocus = element_back;
    if(tabIndex_back == Number.MIN_VALUE)
      element_nextFocus = element_max;
  }

  return element_nextFocus;
}

/** O擾 */
function getName(element){
  // x̏ꍇ
  if(element.tagName == "SPAN")
    name = element.attributes.getNamedItem("name").nodeValue;
  else
    name = element.name;

  return name;
}

/** l擾 */
function getValueByName(name){
  var value = "";

  // 
  var elements = getElementsByName2(name);
  if(elements != null){
    var nElement = elements.length;
    for(var ii = 0; ii < nElement; ii++){
      var element = elements[ii];

      // x̏ꍇ
      if(element.tagName == "SPAN"){
        value = getInnerHTML( element.innerHTML );
      // R{{bNXAXg̏ꍇ
      } else if(element.tagName == "SELECT") {
        var length_options = element.options.length;
        for(var jj = 0; jj < length_options; jj++){
          if( element.options[jj].selected )
            value += element.options[jj].value;
        }
      } else {
        // `FbN{bNXꍇ
        if(element.type == "checkbox"){
          if( element.checked )
            value = element.value;
        // WI{^̏ꍇ
        } else if(element.type == "radio") {
          if( element.checked )
            value = element.value;
        // eLXgtB[hApX[htB[hAeLXgGȀꍇ
        } else {
          value = element.value;
        }
      }
    }
  }

  return value;
}

/** lݒ */
function setValue(element, value){
  if(element.tagName == "SPAN")
    element.innerHTML = value;
  else if(element.tagName != "TABLE")
    element.value = value;
}

/** BtB[hɒlݒ */
function setValue2Hidden(name, name4hidden, value){
  var element_hidden = getElementByName2(name + name4hidden);
  if(element_hidden == null){
    element_hidden = document.createElement("input");
    element_hidden.name = name + name4hidden;
    element_hidden.id = element_hidden.name;
    element_hidden.type = "hidden";
    element_hidden.value = value;

    document.form.appendChild(element_hidden);
  } else {
    element_hidden.value = value;
  }
}

/** ľܓ */
function round(value, nDecimal){
  var pow = Math.pow(10, nDecimal - 1);

  return Math.round(value * pow) / pow;
}

/** l */
function isNumber(str_number){
  // J}폜
  str_number = str_number.replace(/\,+/ig, "");

  // ʉݕ\
  var nCurrency = str_number.split("\\").length + str_number.split("$").length;
  if(nCurrency > 3)
    return false;

  // ʉݕ\ʒu
  var index = str_number.indexOf("\\");
  if(index == 1){
    var ch = str_number.charAt(0);
    if(ch != "+" && ch != "-")
      return false;
  } else if(index > 2) {
    return false;
  }

  index = str_number.indexOf("$");
  if(index == 1){
    var ch = str_number.charAt(0);
    if(ch != "+" && ch != "-")
      return false;
  } else if(index > 2) {
    return false;
  }

  // ʉݕ\폜
  str_number = str_number.replace(/\\+|\$+/ig, "");

  if( isNaN( Number(str_number) ) )
    return false;
  else
    return true;
}

/**  */
function getNumber(str_number){
  // J}Aʉݕ\폜
  str_number = str_number.replace(/\\+|\$+|\,+/ig, "");

  var number;
  if( isNaN(str_number) ){
    try{
      number = eval(str_number);
    } catch(e) {
      return 0;
    }
  } else {
    number = Number(str_number);
  }

  if(number >= 10000000000000000)
    return 0;
  else
    return number;
}

/** l𐔒lɕϊ */
function getNumberByName(name){
  var value = getValueByName(name);

  // Bf[^̒l擾
  var element_hidden4inputValue = getElementByName2(name + "_hidden4inputValue");
  if(element_hidden4inputValue != null){
    if( !isNumber(value) )
      value = element_hidden4inputValue.value;
  }

  if( isNumber(value) )
    return getNumber(value);
  else
    return 0;
}

/**  */
function getInnerHTML(str){
  // g&nbsph𔼊pXy[Xɕϊ
  str = str.replace("&nbsp;", " ");

  return str;
}

/** tH[̃bN */
function unlockForm(event, url){
  document.form.NEXT_PAGE.value = url;

  if(event.type == "unload"){
    if(unlockFormFlag)
      post("./cancelform");
    else
      unlockFormFlag = true;
  } else {
    post("./cancelform");
  }
}

/** ͒l^Cv𔻒i0: 1:l 2:tAj */
function getValueType(str_value){
  var valueType = -1;

  nSep_day = 0;
  nSep_time = 0;

  // 
  if(str_value.length == 0){
    valueType = 0;
  // 
  } else if( isNumber(str_value) ){
    valueType = 1;
  } else {
    // 
    if(str_value.charAt(0) == "+" || str_value.charAt(0) == "-"){
      try{
        var str_value2 = eval(str_value);
        if(str_value != str_value2)
          valueType = 1;
      } catch(e) {
      }
    }

    // 
    if(str_value.split("/").length > 3 || str_value.split("-").length > 3 || str_value.split(":").length > 3 || str_value.split(" ").length > 2)
      valueType = 0;

    if(valueType == -1){
      var index_value = 0;
      var sepType = 0;

      var length_str_value = str_value.length;
      for(var ii = 0; ii < length_str_value; ii++){
        var ch = str_value.charAt(ii);
        // tA̋؂蕶̏ꍇ
        if(ch == "/" || ch == "-" || ch == ":" || ch == "N" || ch == "" || ch == "" || ch == "" || ch == "" || ch == "b"){
          var str = str_value.substring(index_value, ii);
          // lł͂Ȃꍇ
          if(isNaN(str) || str.length == 0){
            valueType = 0;
            break;
          // l̏ꍇ
          } else {
            // ̏ꍇ
            if(Number(str) >= 0){
              valueType = 2;

              if(ch == "/" || ch == "-"){
                if(sepType != 0 && sepType != 1){
                  valueType = 0;
                  break;
                }

                sepType = 1;
                nSep_day++;
              } else if(ch == "N" || ch == "" || ch == "") {
                if(sepType != 0 && sepType != 2){
                  valueType = 0;
                  break;
                }

                sepType = 2;
                nSep_day++;
              } else if(ch == ":") {
                if(sepType != 0 && sepType != 3){
                  valueType = 0;
                  break;
                }

                sepType = 3;
                nSep_time++;
              } else if(ch == "" || ch == "" || ch == "b") {
                if(sepType != 0 && sepType != 4){
                  valueType = 0;
                  break;
                }

                sepType = 4;
                nSep_time++;
              }
            // ̏ꍇ
            } else {
              valueType = 0;
              break;
            }
          }
        // " "
        } else if(ch == " ") {
          if(sepType == 2)
            nSep_day--;
          else if(sepType == 4)
            nSep_time--;

          sepType = 0;
        // ̑̏ꍇ
        } else {
          // Ō̏̕ꍇ
          if(ii == length_str_value - 1) {
            var str = str_value.substring(index_value, ii + 1);
            // lł͂Ȃꍇ
            if(isNaN(str) || str.length == 0){
              valueType = 0;
              break;
            // l̏ꍇ
            } else {
              // ̏ꍇ
              if(Number(str) >= 0){
                valueType = 2;
              // ̏ꍇ
              } else {
                valueType = 0;
                break;
              }
            }
          // 
          } else {
            // lł͂Ȃꍇ
            if(isNaN( Number(ch) ) || ch.length == 0){
              valueType = 0;
              break;
            } else {
              continue;
            }
          }
        }

        index_value = ii + 1;
      }

      if(sepType == 2)
        nSep_day--;
      else if(sepType == 4)
        nSep_time--;

      if(nSep_day > 2 || nSep_time > 2)
        valueType = 0;
    }
  }
//alert(nSep_day + " : " + nSep_time);

  // 
  if(valueType == 2){
    // 
    getValue_daytime(str_value);

    if (nSep_day > 0 && nSep_time > 0) {
      if(checkDate2(year, month, day) != "" || checkTime2(hour, minute, second) != "")
        valueType = 0;
    }
    else if (nSep_day > 0) {
      if (checkDate2(year, month, day) != "")
        valueType = 0;
    }
    else if (nSep_time > 0) {
      if (checkTime2(hour, minute, second) != "")
        valueType = 0;
    }
    
    //
  }

  return valueType;
}

var year;
var year_org;
var month;
var day;
var hour;
var hour_org;
var minute;
var second;
var nSep_day;
var nSep_time;

/** NA擾 */
function getValue_daytime(str_value){
  // g.hg-hg/hɕϊ
  str_value = str_value.replace(/\.+|-+/ig, "/");
  // g:hg hgNhghghghghgbhg/hɕϊ
  var str_value2 = str_value.replace(/\:+|\s+|N+|+|+|+|+|b+/ig, "/");
  // 
  str_value2 = str_value2.replace(/\/+/ig, "/");
  // 
  if(str_value2.lastIndexOf("/") == str_value2.length - 1)
    str_value2 = str_value2.substring(0, str_value2.length - 1);

  // 
  var tokens_value = str_value2.split("/");
  var length_tokens_value = tokens_value.length;
  var index_tokens = 0;

  // N擾
  if(nSep_day == 1){
    var value = Number( tokens_value[0] );
    if(value > 12){
      year = value;
      month = Number( tokens_value[1] );
      if(month > 12){
        tokens_format = new Array();
        tokens_format[0] = "@";

        return;
      }
    } else {
      month = value;
      if(month > 12){
        tokens_format = new Array();
        tokens_format[0] = "@";

        return;
      }

      day = Number( tokens_value[1] );
      if(day > 31){
        tokens_format = new Array();
        tokens_format[0] = "@";

        return;
      }
    }

    index_tokens = 2;
  } else if(nSep_day == 2) {
    year = Number( tokens_value[0] );
    if(year <= 29){
      year += 2000;
    } else if(year <= 99) {
      year += 1900;
    } else if(year >= 10000) {
      tokens_format = new Array();
      tokens_format[0] = "@";

      return;
    }

    month = Number( tokens_value[1] );
    if(month > 12){
      tokens_format = new Array();
      tokens_format[0] = "@";

      return;
    }

    day = Number( tokens_value[2] );
    if(day > 31){
      tokens_format = new Array();
      tokens_format[0] = "@";

      return;
    }

    index_tokens = 3;
  }

  // 擾
  if(nSep_time == 1){
    hour = Number( tokens_value[index_tokens] );
    if(hour >= 10000){
      tokens_format = new Array();
      tokens_format[0] = "@";

      return;
    } else {
      if(hour == 24)
        hour = 12;
      else
        hour %= 24;
    }

    hour_org = hour;
    minute = Number( tokens_value[index_tokens + 1] );
  } else if(nSep_time == 2) {
    hour = Number( tokens_value[index_tokens] );
    if(hour >= 10000){
      tokens_format = new Array();
      tokens_format[0] = "@";

      return;
    } else {
      if(hour == 24)
        hour = 12;
      else
        hour %= 24;
    }

    hour_org = hour;
    minute = Number( tokens_value[index_tokens + 1] );
    second = Number( tokens_value[index_tokens + 2] );
  }
}

/**  */
function checkDate2(year, month, day){
  var str_error = "";

  // N
  if(year != null && (year < 1000 || year >= 10000))
    str_error = "Nsłi" + year + "j\r\n";

  // 
  if(month < 1 || month > 12)
    str_error += "słi" + month + "j\r\n";

  // 
  if((day != null && isNaN(day)) || day <= 0 || day > 30 + ((month == 4 || month == 6 || month ==9 || month == 11)? 0:1) || 
    (month == 2 && day > 28 + (((year % 4 == 0 && year % 100 != 0) || year % 400 == 0)? 1:0)))
    str_error += "ɂsłi" + day + "j\r\n";

  return str_error;
}

/** LȎ */
function checkTime2(hour, minute, second){
  var str_error = "";

  // Ԃ
  if(hour != null && (hour < 0 || hour > 24))
    str_error = "Ԃsłi" + hour + "j\r\n";

  // 
  if(minute < 0 || minute > 60)
    str_error = "słi" + minute + "j\r\n";

  // b
  if(second != null && (second < 0 || second > 60))
    str_error = "bsłi" + second + "j\r\n";

  return str_error;
}

/**
property_stx.js

function focusByEnterKey(event);
function showComment(visibility, element, event);
function checkEssentialItems(arrays);
function checkEssentialItems2(arrays);
function checkStringLength(element, maxLength, minLength);
function checkValueType(checkType, element);
function checkValueType2(checkType, element, maxValue, minValue, customRegExp, errorMessage);
function getCharacterType(value);
function checkNumberLimit(value, maxValue, minValue);
function convertCharacter(value, str1, str2);
function checkDate(str_value);
function checkTime(str_value);
function checkZipCode(str_value);
function checkTelephoneNumber(str_value);
function checkMobilephoneNumber(str_value);
function checkURL(str_value);
function checkMailAddress(str_value);
function checkCustomRegExp(str_value, customRegExp, str_error);
function insertComma2String(str_value);

StraFormDesigner Ver1.5
Copyright(C) 2004-2008 FIT Corporation All Rights Reserved.

Last Update 2008/04/14
*/

/** EnterL[ŃtH[JXړ */
function focusByEnterKey(event){
  // EnterL[Ăꍇ
  var keyCode;
  switch(browserType){
    // 
    case 0:
    case 2:
      keyCode = event.keyCode;
      break;

    // 
    case 1:
      keyCode = (event.keyCode != 0) ? event.keyCode : event.charCode;
      break;
  }

  // EnterL[̃L[R[hύX
  if(keyCode == 0x0A)
    keyCode = 0x0D;

  if(keyCode != 0x0D)
    return;

  event.returnValue = false;
  event.cancelBubble = true;

  var element;
  switch(browserType){
    // 
    case 0:
    case 2:
      element = event.srcElement;
      break;

    // 
    case 1:
      element = event.target;
      break;
  }

  var tagName = element.tagName;

  // eLXgGȀꍇACTRLL[EnterL[𓯎ŉs
  if(tagName == "TEXTAREA" && event.ctrlKey){
    switch(browserType){
      // 
      case 0:
      case 2:{
        var textRange = document.selection.createRange();
        if(textRange != null){
          var offsetLeft = textRange.offsetLeft;
          var offsetTop = textRange.offsetTop;
          textRange = element.createTextRange();
          textRange.moveToPoint(offsetLeft, offsetTop);

          textRange.text = "\r\n";
          textRange.select();
        } else {
          element.value += "\r\n";
        }
      }
      break;

      // 
      case 1:{
        var selectionStart = element.selectionStart;

        var front = element.value.substring(0, element.selectionStart);
        var back = element.value.substring(element.selectionStart, element.value.length);
        element.value = front + "\r\n" + back;

        element.selectionStart = selectionStart + 1;
        element.selectionEnd = selectionStart + 1;
      }
      break;
    }

    return;
  }

  // SHIFTL[ĂȂꍇ
  if( !event.shiftKey ){
    // {^̏ꍇA{^
    if(element.type == "button"){
      element.click();

      return;
    } else {
      element = getNextFocusElement(element, true);
    }
  // SHIFTL[Ăꍇ
  } else {
    element = getNextFocusElement(element, false);
  }

  try{
    // tH[JXݒ肷
    setFocus( element.name );
  } catch(e) {
  }
}

/** Rg\ */
function showComment(visibility, element, event){
  var element_comment = getElementByName2(element.attributes.getNamedItem("name").nodeValue + "_comment");
  if(element_comment != null){
    element_comment.style.visibility = visibility;

    var left = 0;
    var top = 0;
    switch(browserType){
      // 
      case 0:
      case 2:
        left = event.x + document.body.scrollLeft;
        top = event.y + document.body.scrollTop;
        break;

      // 
      case 1:
        left = event.pageX;
        top = event.pageY;
        break;
    }

    element_comment.style.left = left;
    element_comment.style.top = top + 15;
  }
}

/** ͕K{ڂ̓͏Ԃ */
function checkEssentialItems(arrays){
  // ǉe[uElement擾
  var elements_table = getDynamicTableElements();

  var str_error = "";
  var nRadio = 0;
  var array_radioInfos = new Array();

  var length_arrays = arrays.length;
  for(var ii = 0; ii < length_arrays; ii++){
    // z擾
    var array = arrays[ii];
    var length_array = array.length;

    var nRepeat_max = 0;

    // Elementz擾
    var elements = getElementsByName2( array[0] );
    if(elements == null){
      if(elements_table != null){
        var length_elements_table = elements_table.length;
        for(var jj = 0; jj < length_elements_table; jj++){
          var nRepeat = elements_table[jj].rows.length;
          if(nRepeat > nRepeat_max)
            nRepeat_max = nRepeat;
        }
      } else {
        continue;
      }

      elements = new Array();

      for(var jj = 0; jj < nRepeat_max; jj++){
        var name = array[0] + "_R_" + (jj + 1);

        var element = getElementByName2(name);
        if(element != null){
          // 
          if(element.type == "radio"){
            var elements2 = getElementsByName2(name);
            var length_elements2 = elements2.length;
            for(var kk = 0; kk < length_elements2; kk++)
              elements[ elements.length ] = elements2[kk];
          // 
          } else {
            elements[jj] = element;
          }
        } else {
          break;
        }
      }
    }

    var nElement = elements.length;
    for(var jj = 0; jj < nElement; jj++){
      var element = elements[jj];
      var name = element.name;

      // R{{bNXAXg̏ꍇ
      if(element.tagName == "SELECT"){
        var elements_select = new Array();
        var index = 0;

        // Iڂ擾
        var length_options = element.options.length;
        for(var kk = 0; kk < length_options; kk++){
          if( element.options[kk].selected )
            elements_select[ index++ ] = element.options[kk].value;
        }

        var nMatch_select = 0;

        // IڂƔr
        var length_elements_select = elements_select.length;
        for(var kk = 0; kk < length_elements_select; kk++){
          for(var ll = 1; ll < length_array; ll++){
            if(elements_select[kk] == array[ll]){
              nMatch_select++;
              break;
            }
          }
        }

        if(length_elements_select == nMatch_select)
          str_error += name + "͓͕K{ڂł\r\n";
      } else {
        // `FbN{bNXꍇ
        if(element.type == "checkbox"){
          if((element.checked && array[1] == "true") || (!element.checked && array[1] == "false"))
            str_error += name + "͓͕K{ڂł\r\n";
        // WI{^̏ꍇ
        } else if(element.type == "radio") {
          var isUpdate = false;

          // ύXꍇ
          if((element.checked && element.value != array[1]) || (!element.checked && element.value == array[1])){
            isUpdate = true;
          // ύXꍇ
          } else {
          }

          var found = false;

          var length_array_radioInfos = array_radioInfos.length;
          for(var kk = 0; kk < length_array_radioInfos; kk++){
            var radioInfo = array_radioInfos[kk];
            if(radioInfo[0] == name){
              found = true;

              if( !radioInfo[1] )
                radioInfo[1] = isUpdate;
            }
          }

          // o^
          if( !found ){
            var radioInfo = new Array();
            radioInfo[0] = name;
            radioInfo[1] = isUpdate;

            array_radioInfos[ nRadio++ ] = radioInfo;
          }

          if(jj == nElement - 1){
            var length_array_radioInfos = array_radioInfos.length;
            for(var kk = 0; kk < length_array_radioInfos; kk++){
              var radioInfo = array_radioInfos[kk];
              if( !radioInfo[1] )
                str_error += radioInfo[0] + "͓͕K{ڂł\r\n";
            }

            nRadio = 0;
            array_radioInfos = new Array();
          }
        // eLXgtB[hApX[htB[hAeLXgGȀꍇ
        } else {
          if(array[1] == element.value)
            str_error += name + "͓͕K{ڂł\r\n";
        }
      }
    }
  }

  // G[bZ[W\
  if(str_error != ""){
    alert(str_error);

    return false;
  }

  return true;
}

/** ͕K{ڂ̓͏Ԃ */
function checkEssentialItems2(arrays){
  // ǉe[uElement擾
  var elements_table = getDynamicTableElements();

  var nNames = 0;
  var array_names = new Array();
  var nRadio = 0;
  var array_radioInfos = new Array();

  var length_arrays = arrays.length;
  for(var ii = 0; ii < length_arrays; ii++){
    // z擾
    var array = arrays[ii];
    var length_array = array.length;

    var nRepeat_max = 0;

    // Elementz擾
    var elements = getElementsByName2( array[0] );
    if(elements == null){
      if(elements_table != null){
        var length_elements_table = elements_table.length;
        for(var jj = 0; jj < length_elements_table; jj++){
          var nRepeat = elements_table[jj].rows.length;
          if(nRepeat > nRepeat_max)
            nRepeat_max = nRepeat;
        }
      } else {
        continue;
      }

      elements = new Array();

      for(var jj = 0; jj < nRepeat_max; jj++){
        var name = array[0] + "_R_" + (jj + 1);

        var element = getElementByName2(name);
        if(element != null){
          // 
          if(element.type == "radio"){
            var elements2 = getElementsByName2(name);
            var length_elements2 = elements2.length;
            for(var kk = 0; kk < length_elements2; kk++)
              elements[ elements.length ] = elements2[kk];
          // 
          } else {
            elements[jj] = element;
          }
        } else {
          break;
        }
      }
    }

    var nElement = elements.length;
    for(var jj = 0; jj < nElement; jj++){
      var element = elements[jj];
      var name = element.name;

      // R{{bNXAXg̏ꍇ
      if(element.tagName == "SELECT"){
        var elements_select = new Array();
        var index = 0;

        // Iڂ擾
        var length_options = element.options.length;
        for(var kk = 0; kk < length_options; kk++){
          if( element.options[kk].selected )
            elements_select[ index++ ] = element.options[kk].value;
        }

        var nMatch_select = 0;

        // IڂƔr
        var length_elements_select = elements_select.length;
        for(var kk = 0; kk < length_elements_select; kk++){
          for(var ll = 1; ll < length_array; ll++){
            if(elements_select[kk] == array[ll]){
              nMatch_select++;
              break;
            }
          }
        }

        if(length_elements_select == nMatch_select)
          array_names[ nNames++ ] = name;
      } else {
        // `FbN{bNXꍇ
        if(element.type == "checkbox"){
          if((element.checked && array[1] == "true") || (!element.checked && array[1] == "false"))
            array_names[ nNames++ ] = name;
        // WI{^̏ꍇ
        } else if(element.type == "radio") {
          var isUpdate = false;

          // ύXꍇ
          if((element.checked && element.value != array[1]) || (!element.checked && element.value == array[1])){
            isUpdate = true;
          // ύXꍇ
          } else {
          }

          var found = false;

          var length_array_radioInfos = array_radioInfos.length;
          for(var kk = 0; kk < length_array_radioInfos; kk++){
            var radioInfo = array_radioInfos[kk];
            if(radioInfo[0] == name){
              found = true;

              if( !radioInfo[1] )
                radioInfo[1] = isUpdate;
            }
          }

          // o^
          if( !found ){
            var radioInfo = new Array();
            radioInfo[0] = name;
            radioInfo[1] = isUpdate;

            array_radioInfos[ nRadio++ ] = radioInfo;
          }

          if(jj == nElement - 1){
            var length_array_radioInfos = array_radioInfos.length;
            for(var kk = 0; kk < length_array_radioInfos; kk++){
              var radioInfo = array_radioInfos[kk];
              if( !radioInfo[1] )
                array_names[ nNames++ ] = radioInfo[0];
            }

            nRadio = 0;
            array_radioInfos = new Array();
          }
        // eLXgtB[hApX[htB[hAeLXgGȀꍇ
        } else {
          if(array[1] == element.value)
            array_names[ nNames++ ] = name;
        }
      }
    }
  }

  return array_names;
}

/** ͕𐧌 */
function checkStringLength(element, maxLength, minLength){
  var value = element.value;
  var length_value = value.length;

  // ő啶𐧌
  if(maxLength != 0 && length_value > maxLength){
    // G[bZ[W\
    alert(maxLength + "ȏ͓͏o܂");

    // ő啶ȏ̕폜
    element.value = value.substring(0, maxLength);

    // tH[JX߂
    element.focus();
  }

  // ŏ𐧌
  if(minLength != 0 && length_value != 0 && length_value < minLength){
    // G[bZ[W\
    alert(minLength + "ȏ͂ĉ");

    // tH[JX߂
    element.focus();
  }
}

/** l */
function checkValueType(checkType, element){
  var value = element.value;
  if(value == "")
    return;

  var str_error = "";

  switch(checkType){
    // 
    case 1:{
      if( value.match(/[^0-9|.|,|\+|\-]/ig) )
        str_error = "p͂ĉ";

      break;
    }

    // p
    case 2:{
      if( value.match(/[^a-z]/ig) )
        str_error = "pp͂ĉ";

      break;
    }

    // p
    case 3:{
      if( value.match(/[^\w|.|,|\+|\-]/ig)  )
        str_error = "pp͂ĉ";

      break;
    }

    // t
    case 4:{
      str_error = checkDate(value);
      break;
    }

    // URL
    case 5:{
      str_error = checkURL(value);
      break;
    }

    // [AhX
    case 6:{
      str_error = checkMailAddress(value);
      break;
    }
  }

  // 
  if(str_error.length > 0){
    // G[bZ[W\
    alert(str_error);

    // lNA
    element.value = "";

    // tH[JX߂
    element.focus();
  }
}

/** l */
function checkValueType2(checkType, element, maxValue, minValue, customRegExp, errorMessage){
  var value = element.value;
  if(value == "")
    return;

  var str_error = "";
  var alphabet_half  = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'. ";
  var length_alphabet_half = alphabet_half.length;
  var alphabet_full  = "`abcdefghijklmnopqrstuvwxyfD@";
  var length_alphabet_full = alphabet_full.length;
  var number_half    = "0123456789.,-+\\$ ";
  var length_number_half = number_half.length;
  var number_full    = "OPQRSTUVWXDC|{@";
  var length_number_full = number_full.length;
  var sign_half  = "!\\\"#$%&'()=~|`{+*}<>?_-^@[;:],./ ";
  var length_sign_half = sign_half.length;
  var sign_full  = "Ihfij`beo{pHQ|OmGFnCD^@";
  var length_sign_full = sign_full.length;
  var katakana_half  = "ܦݧ ";
  var length_katakana_half = katakana_half.length;
  var katakana_half_special  = "";
  var length_katakana_half_special = katakana_half_special.length;
  var katakana_full  = "ACEGIJLNPRTVXZ\^`cegijklmnqtwz}~@BDFHb[ABJK@KMOQSUWY[]_adfhorux{psvy|";
  var length_katakana_full = katakana_full.length;
  var hiragana       = "ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂񂟂[ABJK@Âłǂ΂тԂׂڂς҂Ղ؂";
  var length_hiragana = hiragana.length;
  var array_strs = new Array(alphabet_half, number_half, sign_half, katakana_half, alphabet_full, number_full, sign_full, katakana_full, hiragana);
  var length_array_strs = array_strs.length;

  // pSpɕϊ
  if(checkType & 0x800){
    // p
    value = convertCharacter(value, alphabet_half, alphabet_full);
    // 
    value = convertCharacter(value, number_half, number_full);
    // L
    value = convertCharacter(value, sign_half, sign_full);

    // J^Ji
    var value2 = "";

    var length_value = value.length;
    for(var ii = 0; ii < length_value; ii++){
      var ch = value.charAt(ii);

      if(katakana_half_special.indexOf(ch) != -1){
        var index = katakana_half_special.indexOf(ch);
        if(ii < length_value - 1 && value.charAt(ii + 1) == ""){
          index += 61;
          ii++;
          ch = katakana_full.charAt(index);
        } else if(ii < length_value - 1 && value.charAt(ii + 1) == "") {
          index += 66;
          ii++;
          ch = katakana_full.charAt(index);
        } else {
          ch = katakana_full.charAt( katakana_half.indexOf(ch) );
        }
      } else {
        var index = katakana_half.indexOf(ch);
        if(index != -1)
          ch = katakana_full.charAt(index);
      }

      value2 += ch;
    }

    value = value2;

    element.value = value;
  }

  // Sp甼pɕϊ
  if(checkType & 0x1000){
    // p
    value = convertCharacter(value, alphabet_full, alphabet_half);
    // 
    value = convertCharacter(value, number_full, number_half);
    // L
    value = convertCharacter(value, sign_full, sign_half);

    // J^Ji
    var value2 = "";

    var length_value = value.length;
    for(var ii = 0; ii < length_value; ii++){
      var ch = value.charAt(ii);

      if(katakana_full.indexOf(ch) != -1){
        var index = katakana_full.indexOf(ch);
        if(index < length_katakana_half){
          ch = katakana_half.charAt( katakana_full.indexOf(ch) );
        } else {
          ch = katakana_half_special.charAt(index - 61);

          if(index < 81)
            ch += "";
          else
            ch += "";
        }
      }

      value2 += ch;
    }

    value = value2;

    element.value = value;
  }

  // 
  if(checkType & 0x3){
    // pASp̗ZbgĔppApApJ^JiASppASpAЂ炪ȁASpJ^JȋSĂZbgȂꍇ
    if(((checkType & 0x1) && !(checkType & 0x3C)) && ((checkType & 0x2) && !(checkType & 0x7C0))){
    } else {
      var str_error_charType = "";
      var array_strs_charType = new Array("pp", "p", "pL", "pJ^Ji", "pp", "Spp", "Sp", "SpL", "SpJ^Ji", "Ђ炪", "Spp");

      // G[bZ[W쐬
      var nCheck = 0;
      var nCheck_charType = 0;
      if((checkType & 0x3D) == 0x1){
        str_error_charType += "pA";
        nCheck++;
        nCheck_charType++;
      }
      for(var ii = 0; ii < 4; ii++){
        // pp̏ꍇ
        if(ii == 0 && (checkType & 0xC) == 0xC){
          str_error_charType += array_strs_charType[4] + "A";
          ii++;
          nCheck++;
          nCheck_charType += 2;
          continue;
        }

        if(checkType & (0x4 << ii)){
          str_error_charType += array_strs_charType[ii] + "A";
          nCheck++;
          nCheck_charType++;
        }
      }
      if((checkType & 0x7C2) == 0x2){
        str_error_charType += "SpA";
        nCheck++;
        nCheck_charType++;
      }
      for(var ii = 0; ii < 5; ii++){
        // Spp̏ꍇ
        if(ii == 0 && (checkType & 0xC0) == 0xC0){
          str_error_charType += array_strs_charType[10] + "A";
          ii++;
          nCheck++;
          nCheck_charType += 2;
          continue;
        }

        if(checkType & (0x40 << ii)){
          str_error_charType += array_strs_charType[ii + 5] + "A";
          nCheck++;
          nCheck_charType++;
        }
      }

      if(nCheck == 1)
        str_error_charType = str_error_charType.substring(0, str_error_charType.length - 1) + "œ͂ĉ\r\n";
      else if(nCheck > 1)
        str_error_charType = str_error_charType.substring(0, str_error_charType.length - 1) + "̂ꂩœ͂ĉ\r\n";

      var isError_charType = false;

      // gp𒲍
      var length_value = value.length;
      for(var ii = 0; ii < length_value; ii++){
        var ch = value.charAt(ii);
        var nNotFound = 0;

        for(var jj = 0; jj < 4; jj++){
          if(checkType & (0x4 << jj)){
            if(array_strs[jj].indexOf(ch) == -1)
              nNotFound++;
          }
        }

        for(var jj = 0; jj < 5; jj++){
          if(checkType & (0x40 << jj)){
            if(array_strs[jj + 4].indexOf(ch) == -1)
              nNotFound++;
          }
        }

        if(nCheck_charType == nNotFound)
          isError_charType = true;
      }

      // p`FbN
      if(checkType == 0x1 && (getCharacterType(value) & 0x2))
        isError_charType = true;
      // Sp`FbN
      if(checkType == 0x2 && (getCharacterType(value) & 0x1))
        isError_charType = true;

      if((checkType & 0x3D) == 0x1)
        checkType |= 0x3C;
      if((checkType & 0x7C2) == 0x2)
        checkType |= 0x7C0;

      // őlAŏl`FbN
      if((checkType & 0x88) > 0 && (maxValue != null || minValue != null)){
        var value_number = convertCharacter(value, number_full, number_half);

        var str_error_numberLimit = checkNumberLimit(getNumber(value_number), maxValue, minValue);
        if(str_error_numberLimit.length > 0){
          isError_charType = false;
          str_error = str_error_numberLimit;
        }
      }

      // 
      if(isError_charType)
        str_error += str_error_charType;
    }
  }

  // l^Cv
  if((checkType & 0xFE000) > 0){
    var isError_valueType = false;
    var str_error_valueType = "";
    var array_strs_valueType = new Array("t", "", "X֔ԍ", "dbԍ", "dbԍigсj", "URL", "[AhX");
    var length_array_strs_valueType = array_strs_valueType.length;

    // G[bZ[W쐬
    var nCheck = 0;
    for(var ii = 0; ii < length_array_strs_valueType; ii++){
      if(checkType & (0x2000 << ii)){
        str_error_valueType += array_strs_valueType[ii] + "A";
        nCheck++;
      }
    }

    if(nCheck == 1)
      str_error_valueType = str_error_valueType.substring(0, str_error_valueType.length - 1) + "͂ĉ\r\n";
    else if(nCheck > 1)
      str_error_valueType = str_error_valueType.substring(0, str_error_valueType.length - 1) + "̂ꂩ͂ĉ\r\n";

    // p
    value = convertCharacter(value, alphabet_full, alphabet_half);
    // 
    value = convertCharacter(value, number_full, number_half);
    // L
    value = convertCharacter(value, sign_full, sign_half);

    var nError = 0;

    // t`FbN
    if(checkType & 0x2000){
      var str_error_date = checkDate(value);
      if(str_error_date.length != 0)
        nError++;

      if(str_error_date != "t͂ĉ\r\n")
        str_error += str_error_date;
    }

    // `FbN
    if(checkType & 0x4000){
      var str_error_time = checkTime(value);
      if(str_error_time.length != 0)
        nError++;

      if(str_error_time != "͂ĉ\r\n")
        str_error += str_error_time;
    }

    // X֔ԍ`FbN
    if(checkType & 0x8000){
      if( checkZipCode(value) )
        nError++;
    }

    // dbԍ`FbN
    if(checkType & 0x10000){
      if( checkTelephoneNumber(value) )
        nError++;
    }

     // dbԍigсj`FbN
    if(checkType & 0x20000){
      if( checkMobilephoneNumber(value) )
        nError++;
    }

    // URL`FbN
    if(checkType & 0x40000){
      if( checkURL(value) )
        nError++;
    }

    // [AhX`FbN
    if(checkType & 0x80000){
      if( checkMailAddress(value) )
        nError++;
    }

    // 
    if(nCheck == nError)
      str_error += str_error_valueType;
  }

  // JX^
  if(customRegExp != null && errorMessage != null)
    str_error += checkCustomRegExp(value, customRegExp, errorMessage);

  // 
  if(str_error.length > 0){
    // G[bZ[W\
    alert(str_error);

    // lNA
    element.value = "";

    // tH[JX߂
    element.focus();
  }
}

/**  */
function getCharacterType(value){
  var type = 0;

  var length_value = value.length;
  for(var ii = 0; ii < length_value; ii++){
    var ch = value.charCodeAt(ii);

    // p
    if((ch >= 0x0 && ch < 0x81) || (ch >= 0xf8f0 && ch < 0xf8f4) || (ch >= 0xff61 && ch < 0xffa0))
      type |= 0x1;
    // Sp
    else
      type |= 0x2;
  }

  return type;
}

/**  */
function checkNumberLimit(value, maxValue, minValue){
  var str_error = "";

  // ől`FbN
  if(maxValue != null){
    if(value > maxValue)
      str_error += "őli" + maxValue + "j傫l͓͏o܂\r\n";
  }
  // ŏl`FbN
  if(minValue != null){
    if(value < minValue)
      str_error += "ŏli" + minValue + "j菬l͓͏o܂\r\n";
  }

  return str_error;
}

/** pƑSpϊ */
function convertCharacter(value, str1, str2){
  var value2 = "";

  var length_value = value.length;
  for(var ii = 0; ii < length_value; ii++){
    var ch = value.charAt(ii);

    if(str1.indexOf(ch) != -1)
      ch = str2.charAt( str1.indexOf(ch) );

    value2 += ch;
  }

  return value2;
}

/** Lȓt */
function checkDate(str_value){
  var str_error = "";

  // ͒l^Cv𔻒i0: 1:l 2:tAj
  var valueType = getValueType(str_value);
  if(valueType != 2){
    return "t͂ĉ\r\n";
  } else {
    year = null;
    month = null;
    day = null;

    getValue_daytime(str_value);
//alert(year + " : " + month + " : " + day);

    if(month == null || day == null)
      return "t͂ĉ\r\n";

    str_error = checkDate2(year, month, day);
  }

  return str_error;
}

/** LȎ */
function checkTime(str_value){
  var str_error = "";

  // ͒l^Cv𔻒i0: 1:l 2:tAj
  var valueType = getValueType(str_value);
  if(valueType != 2){
    return "͂ĉ\r\n";
  } else {
    hour = null;
    minute = null;
    second = null;

    getValue_daytime(str_value);
//alert(hour + " : " + minute + " : " + second);

    if(minute == null)
      return "͂ĉ\r\n";

    str_error = checkTime2(hour, minute, second);
  }

  return str_error;
}

/** LȗX֔ԍ */
function checkZipCode(str_value){
  var error = false;

  if( !str_value.match(/^\d{3}\d{4}$|^\d{3}-\d{4}$/) )
    error = true;

  return error;
}

/** Lȓdbԍ */
function checkTelephoneNumber(str_value){
  var error = false;

  if(!str_value.match(/^[0-9-]{6,9}$|^[0-9-]{10,12}$/) || (!str_value.match(/^\d{1,4}-\d{4}$|^\d{2,5}-\d{1,4}-\d{4}$/) && !str_value.match(/^\d{1,4}\d{4}$|^\d{2,5}\d{1,4}\d{4}$/)))
    error = true;

  return error;
}

/** Lȓdbԍigсj */
function checkMobilephoneNumber(str_value){
  var error = false;

  if(!str_value.match(/^\d{3}-\d{4}-\d{4}$|^\d{11}$/) && !str_value.match(/^\d{3}\d{4}\d{4}$/))
    error = true;

  return error;
}

/** LURL */
function checkURL(str_value){
  var error = false;

  if(!str_value.match(/(http|https|ftp|mail):\/\/[!#-9A-~]+\.+[a-z0-9]+\.+[a-z0-9]+/i) && !str_value.match(/[!#-9A-~]+\.+[a-z0-9]+\.+[a-z0-9]+/i))
    error = true;

  return error;
}

/** Lȃ[AhX */
function checkMailAddress(str_value){
  var error = false;

  if( !str_value.match(/^([\w\_\-\.]+)@([\w\_\-\.]+\.[\w\_\-\.]+)$/) )
    return true;

  var userID = RegExp.$1;
  var domain = RegExp.$2;

  if(domain.match(/\.{2,}/) != null)
    return true;

  var userID_start = userID.charAt(0);
  var userID_end = userID.charAt(userID.length - 1);
  var domain_start = domain.charAt(0);
  var domain_end = domain.charAt(domain.length - 1);

  if(userID_start == "_" || userID_start == "-" || userID_start == "." || userID_end == "_" || userID_end == "-" || userID_end == "." || domain_start == "_" || domain_start == "-" || domain_start == "." || domain_end == "_" || domain_end == "-" || domain_end == ".")
    return true;

  return error;
}

/** JX^ */
function checkCustomRegExp(str_value, customRegExp, str_error){
  if( !str_value.match(customRegExp) )
    return str_error;
  else
    return "";
}

/** ɃJ}} */
function insertComma2String(str_value){
  var str_integer = "";

  // ۑ
  var str_sign = "";
  if(str_value.charAt(0) == "+" || str_value.charAt(0) == "-")
    str_sign = str_value.charAt(0);

  // pA_ȊO̕폜
  var nDot = 0;
  var length_str = str_value.length;
  for(var ii = 0; ii < length_str; ii++){
    var ch = str_value.charAt(ii);
    if((ch >= "0" && ch <= "9") || ch == "."){
      // _̏ꍇ
      if(ch == "." && ++nDot > 1)
        continue;

      str_integer += ch;
    }
  }

  // 擾
  var str_decimal = "";
  var index = str_integer.indexOf(".");
  if(index != -1){
    str_decimal = str_integer.substring(index);
    if(str_decimal == ".")
      str_decimal = "";

    // 폜
    str_integer = str_integer.substring(0, index);
  }

  // J}}
  var str_comma = "";
  var length_str_integer = str_integer.length;
  for(var ii = 0; ii < length_str_integer; ii++){
    // RɃJ}}
    if(ii > 0 && !((length_str_integer - ii) % 3))
      str_comma += ",";

    str_comma += str_integer.charAt(ii);
  }

  // AA
  return str_sign + str_comma + str_decimal;
}

/**
action_stx.js

function startTimer();
function updateTimer();
function checkKeyCode(event, useCode, code, useSHIFT, isSHIFT, useCTRL, isCTRL, useALT, isALT);
function checkCondition(type, names, values);
function getURLBase(url);
function isReferenceForm();
function post(url);
function post2(url);
function checkSubmitted();
function calculate(element, calcType, itemType, names_value, name_target);
function calculateAverage(names);
function calculateMax(names);
function calculateMin(names);
function linkToURL(popup, href, width, height);
function setAttribute4Component(attributes, names);
function createPopup(url, title, x, y, width, height);
function calendar(nMonth, startType, name, str_format, arg1, arg2);
function showClock(name, reload);
function updateClock(name, reload);
function resetCaretPosition(element);
function setFocus(name);
function isRegistInCookie(key);
function setValue2Cookie(key, value);
function getValueFromCookie(key);
function setValue2UserData(element, key, value);
function getValueFromUserData(element, key);
function removeValueFromUserData(element, key);
function isRegistInUserData(element, key);
function isSelectedElement(name, elements);
function saveFormData(isAll, elements);
function getFormData(isAll, elements);
function deleteFormData(isAll, elements);
function deletePostData();
function setValue2Opener(names_child, name_parent);
function setValues2Opener(names_child, names_parent);
function showPopup4Image(src, magnifyRate_w, magnifyRate_h, fit, width, height);
function addRowDynamically(element, type, tableID, pos);
function deleteRowDynamically(element, tableID);
function getItemValue(element);
function isInputtedItem(element);
function deleteTable(isRow, type, name_table, elements);
function deleteRowByValue(table, name);
function deleteColumnByValue(table, name);
function deleteRowCompulsorily(table, indices);
function deleteColumnCompulsorily(table, indices);

StraFormDesigner Ver1.5
Copyright(C) 2004-2008 FIT Corporation All Rights Reserved.

Last Update 2008/04/14
*/

var timerID;
var timer = 0;

/** ^C}[쐬 */
function startTimer(){
  clearTimeout(timerID);

  // 1bupdateTimerĂяo
  timerID = setInterval("updateTimer()", 1000);
}

/** ^C}[XV */
function updateTimer(){
  timer++;
}

/** L[R[h */
function checkKeyCode(event, useCode, code, useSHIFT, isSHIFT, useCTRL, isCTRL, useALT, isALT){
  // WindowsȊȌꍇAEnterL[̃L[R[hύX
  if(code == 0x0A && navigator.platform.indexOf("Win") != -1){
    code = 0x0D;
  } else {
    var array_codes = new Array(155, 127);
    var length_array_codes = array_codes.length;
    var array_codes2 = new Array(45, 46);

    for(var ii = 0; ii < length_array_codes; ii++){
      if(code == array_codes[ii]){
        code = array_codes2[ii];
        break;
      }
    }
  }

  // L[R[hϊ
  var keyCode;
  switch(browserType){
    // 
    case 0:
    case 2:
      keyCode = event.keyCode;
      break;

    // 
    case 1:
      keyCode = (event.keyCode != 0) ? event.keyCode : event.charCode;
      break;
  }

  // L[
  if(useCode && code != keyCode)
    return false;

  // SHIFTL[
  if(useSHIFT){
    if(isSHIFT != event.shiftKey)
      return false;
  }

  // CTRLL[
  if(useCTRL){
    if(isCTRL != event.ctrlKey)
      return false;
  }

  // ALTL[
  if(useALT){
    if(isALT != event.altKey)
      return false;
  }

  return true;
}

/**  */
function checkCondition(type, names, values){
  var length_names = 0;
  if(names != null)
    length_names = names.length;

  // ^Cv
  switch(type){
    // l
    case 0:
      var conditionValue = values[0];
      if(conditionValue == "")
        conditionValue = 0;

      for(var ii = 0; ii < length_names; ii++){
        var value = getValueByName( names[ii] );
        value = getNumber(value);

        // 
        switch( values[1] ){
          // 
          case 0:{
            if(value != conditionValue)
              return false;
          }
          break;

          // Ȃ
          case 1:{
            if(value == conditionValue)
              return false;
          }
          break;

          // 
          case 2:{
            if(value <= conditionValue)
              return false;
          }
          break;

          // 艺
          case 3:{
            if(value >= conditionValue)
              return false;
          }
          break;

          // ȏ
          case 4:{
            if(value < conditionValue)
              return false;
          }
          break;

          // ȉ
          case 5:{
            if(value > conditionValue)
              return false;
          }
          break;
        }
      }
      break;

    // 
    case 1:{
      var conditionValue = values[0];

      for(var ii = 0; ii < length_names; ii++){
        var value = getValueByName( names[ii] );

        // 
        switch( values[1] ){
          // 
          case 0:{
            if(value != conditionValue)
              return false;
          }
          break;

          // Ȃ
          case 1:{
            if(value == conditionValue)
              return false;
          }
          break;
        }
      }
    }
    break;

    // ^C}[
    case 2:{
      var conditionValue = values[0];

      // 
      switch( values[1] ){
        // O
        case 0:{
          if(timer >= conditionValue)
            return false;
        }
        break;

        // 
        case 1:{
          if(timer != conditionValue)
            return false;
        }
        break;

        // 
        case 2:{
          if(timer <= conditionValue)
            return false;
        }
        break;
      }
    }
    break;
  }

  return true;
}

/** ݂̃y[WURLx[XURL쐬āAPOSTAhX𐶐 */
function getURLBase(url){
  var base = location.protocol + "//" + location.host;
  var path = location.pathname;

  if(url.indexOf(base) == -1){
    var index = path.indexOf("/", 1);
    if(index != -1)
      path = path.substring(0, index + 1);

    return base + path + url;
  } else {
    return url;
  }
}

/** QƗptH[ */
function isReferenceForm(){
  var search = location.search;
  var requests = search.substring(1, search.length).split("&");
  var isReference = false;

  // NG񂩂gresponseTypeh
  var length_requests = requests.length;
  for(var ii = 0; ii < length_requests; ii++){
    var map = requests[ii].split("=");

    // QƗptH[̏ꍇ
    if(map[0] == "responseType" && map[1] == "REFERENCE")
      isReference = true;
  }

  return isReference;
}

var unlockFormFlag = true;

/** f[^𑗐M */
function post(url){
  // ͗ptH[̏ꍇ
  if( !isReferenceForm() ){
    // tH[}bgݒŁgMlhg͒lhɐݒ肵ĂACe̔z
    var array_names_hidden4post = getElementByName2("array_names_hidden4format");
    var array_names = null;
    var length_array_names = 0;

    if(array_names_hidden4post != null){
      array_names = eval( array_names_hidden4post.value );
      length_array_names = array_names.length;
    }

    var isInDynamicTable = false;
    var elements_table = getDynamicTableElements();
    var length_elements_table;
    if(elements_table != null)
      length_elements_table = elements_table.length;
    var all = getFormElements( document.form );

    // 
    var nElement = all.length;
    for(var ii = 0; ii < nElement; ii++){
      var element = all[ii];
      var name = element.name;
      if(name == null)
        continue;

      // ̏ꍇAdisabledNA
      if( element.disabled )
        element.disabled = false;

      // ͎Ɂge[usA폜hsꍇA폜ꂽZ̃ACe̒l𑗐M
      var index_hidden4post = name.indexOf("_hidden4post");
      if(index_hidden4post > 0)
        element.name = name.substring(0, index_hidden4post);

      // ACeg_R_h폜
      var name2 = name;
      var index_repeat = name.indexOf("_R_");
      if(index_repeat > 0 && elements_table != null){
        if(element.type != "hidden"){
          var element2 = element;
          if( !isInDynamicTable ){
            // ǉe[ũACe
            while(true){
              if(element2 == null || element2.tagName == "FORM")
                break;

              if(element2.tagName == "TABLE"){
                for(var jj = 0; jj < length_elements_table; jj++){
                  if(elements_table[jj].name == element2.name){
                    isInDynamicTable = true;
                    break;
                  }
                }

                break;
              }

              element2 = element2.parentNode;
            }
          }

          if(isInDynamicTable)
            name2 = name.substring(0, index_repeat);
        }
      } else {
        isInDynamicTable = false;
      }

      // tH[}bgݒ肵ĂACe̒lɓ͒l
      for(var jj = 0; jj < length_array_names; jj++){
        if(name2 == array_names[jj]){
          var element_hidden4inputValue = getElementByName2(name + "_hidden4inputValue");
          if(element_hidden4inputValue != null){
            element.value = element_hidden4inputValue.value;
            break;
          }
        }
      }
    }
  }

  // MURLݒ
  document.form.action = getURLBase(url);

  unlockFormFlag = false;

  // M
  document.form.submit();
}

/** f[^𑗐M */
function post2(url){
  if(getElementByName2("_QUERY_IMPORT_FORM_HTML") == null)
    post(url);
}

/** dM֎~ */
function checkSubmitted(){
  // QƗptH[̏ꍇ
  if( isReferenceForm() )
    return true;

  // Mς݂̏ꍇ
  if(getValueFromCookie("submittedForm") == document.URL){
    if( confirm("ɑMς݂łAēxM܂H") )
      return true;

    return false;
  // M̏ꍇ
  } else {
    setValue2Cookie("submittedForm", document.URL);

    return true;
  }
}

/** vZ */
function calculate(element, calcType, itemType, names_value, name_target){
  var name_srcElement = element.name;
  var result = 0;
  var length_names = names_value.length;

  switch(itemType){
    // 
    case 1:{
      var iRow = 0;
      var index_repeat = name_srcElement.indexOf("_R_");
      if(index_repeat > 0){
        iRow = Number( name_srcElement.substring(index_repeat + 3, name_srcElement.length) );

        for(var ii = 0; ii < length_names; ii++)
          names_value[ii] += "_R_" + iRow;

        name_target += "_R_" + iRow;
      }
    }
    break;

    // 
    case 2:{
      var name_value = names_value[0];
      var element_value = getElementByName2(name_value + "_R_1");
      var rowIndex = 0;

      var element_table = null;
      var element = element_value;
      while(true){
        if(element == null || element.tagName == "FORM")
          break;

        if(element.tagName == "TR"){
          rowIndex = element.rowIndex;
        } else if(element.tagName == "TABLE") {
          element_table = element;
          break;
        }

        element = element.parentNode;
      }

      // 
      if(element_table != null){
        names_value = new Array();

        // 
        var rows = element_table.getElementsByTagName("TR");
        if(rows != null){
          var length_rows = rows.length - rowIndex;
          for(var ii = 0; ii < length_rows; ii++)
            names_value.push(name_value + "_R_" + (ii + 1));

          length_names = names_value.length;
        }
      }
    }
    break;
  }

  for(var ii = 0; ii < length_names; ii++){
    // 񂩂琔l֘AȊO̕폜
    var value = getNumberByName( names_value[ii] );

    // lݒ
    if(ii == 0 && (calcType >= 1 && calcType <= 3)){
      result = value;
    } else {
      // 
      switch(calcType){
        // a
        case 0:
          result += value;
          break;

        // 
        case 1:
          result -= value;
          break;

        // 
        case 2:
          result *= value;
          break;

        // 
        case 3:
          result /= value;
          break;
      }
    }
  }

  // 
  switch(calcType){
    // 
    case 4:
      result = calculateAverage(names_value);
      break;

    // ő
    case 5:
      result = calculateMax(names_value);
      break;

    // ŏ
    case 6:
      result = calculateMin(names_value);
      break;
  }

  // 
  getElementByName2(name_target).value = result;

  // lBf[^ɕۑ
  setValue2Hidden(name_target, "_hidden4inputValue", result);
}

/** ςvZ */
function calculateAverage(names){
  var total = 0;

  var length_names = names.length;
  for(var ii = 0; ii < length_names; ii++)
    total += getNumberByName( names[ii] );

  return total / length_names;
}

/** ővZ */
function calculateMax(names){
  var result = -Number.MAX_VALUE;

  var length_names = names.length;
  for(var ii = 0; ii < length_names; ii++)
    result = Math.max(result, getNumberByName( names[ii] ));

  return result;
}

/** ŏvZ */
function calculateMin(names){
  var result = Number.MAX_VALUE;

  var length_names = names.length;
  for(var ii = 0; ii < length_names; ii++)
    result = Math.min(result, getNumberByName( names[ii] ));

  return result;
}

/** N */
function linkToURL(popup, href, width, height){
  // |bvAbvEBhE\
  if(popup)
    window.open(href, "", "menubar=1, scrollbars=1, status=1, resizable=1, width=" + width + ", " + "height=" + height);
  // EBhEŃN
  else
    window.location.href = href;
}

/** ݒ */
function setAttribute4Component(attributes, names){
  // z񐔕[v
  var length_names = names.length;
  for(var ii = 0; ii < length_names; ii++){
    var elements = getElementsByName2( names[ii] );
    if(elements == null)
      break;

    var nElement = elements.length;
    for(var jj = 0; jj < nElement; jj++){
      var element = elements[jj];

      // OiF
      if( attributes[0] )
        element.style.color = attributes[1];
      // wiF
      if( attributes[2] )
        element.style.backgroundColor = attributes[3];
      // tHg
      if( attributes[4] )
        element.style.fontFamily = attributes[5];
      // tHgTCY
      if( attributes[6] )
        element.style.fontSize = attributes[7];
      // {[h
      if(attributes[8] == 1)
        element.style.fontWeight = "bold";
      else if(attributes[8] == 2)
        element.style.fontWeight = "normal";
      // C^bN
      if(attributes[9] == 1)
        element.style.fontStyle = "italic";
      else if(attributes[9] == 2)
        element.style.fontStyle = "normal";
      // L
      if(attributes[10] == 1)
        element.disabled = false;
      else if(attributes[10] == 2)
        element.disabled = true;
      // s
      if(attributes[11] == 1)
        element.style.visibility = "visible";
      else if(attributes[11] == 2)
        element.style.visibility = "hidden";
      // l
      if( attributes[12] ){
        var value = attributes[13];

        if(element.tagName == "INPUT" && (element.type == "text" || element.type == "password"))
          value = value.replace(/\r\n+/ig, "");
        else if(element.tagName == "SPAN")
          value = value.replace(/\r\n+/ig, "<br>");

        setValue(element, value);

        // lBf[^ɕۑ
        setValue2Hidden(element.name, "_hidden4inputValue", value);
      }
      // NX
      if(attributes[14] != null){
        var str_className = attributes[14];
        if(str_className.indexOf("+") != -1){
          element.style.color = "";
          element.style.backgroundColor = "";
          element.style.fontFamily = "";
          element.style.fontSize = "";
          element.style.fontWeight = "";
          element.style.fontStyle = "";
          element.disabled = "";
          element.style.visibility = "";

          var name = getName(element);
          var name4hidden = "_hidden4className";

          var element_hidden = getElementByName2(name + name4hidden);
          if(element_hidden == null){
            element_hidden = document.createElement("input");
            element_hidden.name = name + name4hidden;
            element_hidden.id = element_hidden.name;
            element_hidden.type = "hidden";
            element_hidden.value = element.className;

            document.form.appendChild(element_hidden);
          } else {
            element.className = element_hidden.value;
          }

          element.className += str_className.replace(/\++/ig, " ");
        } else {
          element.className = str_className;
        }
      }
    }
  }
}

/** |bvAbvEBhE\ */
function createPopup(url, title, x, y, width, height){
  var style = ""

  if(x != null){
    style += "left=" + x + ",";
    style += "screenX=" + x + ",";
  }
  if(y != null){
    style += "top=" + y + ",";
    style += "screenY=" + y + ",";
  }
  style += "toolbar=no,";
  style += "location=no,";
  style += "directories=no,";
  style += "status=no,";
  style += "menubar=no,";
  style += "scrollbars=no,";
  style += "resizable=yes,";
  style += "innerWidth=" + width + ",";
  style += "innerHeight=" + height + ",";
  style += "width=" + width + ",";
  style += "height=" + height;

  return window.open(url, title, style);
}

var popup_calendar;

var date_now = new Date();
var date_now_temp = date_now;
var openPopup = true;

var year_set = -1;
var month_set = -1;
var day_set = -1;

/** J_[Rg[\ */
function calendar(nMonth, startType, name, str_format, arg1, arg2){
  var element = getElementByName2(name);
  element.blur();

  if(arguments.length <= 4){
    arg1 = 0;
    arg2 = 0;
  } else {
    openPopup = false;
  }

  if(arg1 == 0 && arg2 == 0)
    date_now = new Date();

  if(str_format != null){
    str_format = str_format.replace(/\"+/ig, "&quot;");
    str_format = str_format.replace(/\'+/ig, "\\\\'");
    str_format = "'" + str_format + "'";
  }

  // N擾
  year_now = date_now.getYear();
  if(year_now < 1900)
    year_now += 1900;
  month_now = date_now.getMonth();
  day_now = date_now.getDate();

  // Nɒl𔽉f
  if(startType == 1){
    // Bf[^̒l擾
    if(str_format != null){
      var element_hidden4inputValue = getElementByName2(name + "_hidden4inputValue");
      if(element_hidden4inputValue != null)
        element.value = element_hidden4inputValue.value;
    }

    var str_value = getValueByName(name);
    var tokens_value = str_value.split("/");
    if(tokens_value.length == 3){
      year_set = Number( tokens_value[0] );
      month_set = Number( tokens_value[1] ) - 1;
      day_set = Number( tokens_value[2] );
    } else {
      year_set = year_now;
      month_set = month_now;
      day_set = day_now;
    }
  // SẴJ_[Rg[ŋNɒl𔽉f
  } else if(startType == 2) {
    if(year_set == -1 && month_set == -1 && day_set == -1){
      year_set = year_now;
      month_set = month_now;
      day_set = day_now;
    }
  } else {
    year_set = year_now;
    month_set = month_now;
    day_set = day_now;
  }

  // XV
  if(month_now == 11 && arg1 > 0){
    month_now = -1 + arg1;
    year_now++;
  } else if(month_now == 0 && arg1 < 0){
    month_now = 12 + arg1;
    year_now--;
  } else {
    month_now += arg1;
  }

  // 2000NΉ
  if(year_now < 1900)
    year_now = 1900 + year_now;

  year_now += arg2;

  // 
  date_now = new Date(year_now, month_now, 1);

  // yyyymm
  var now_yyyymm = year_now * 100 + month_now;

  // yyyy/mm
  var title = year_now + "/" + (month_now + 1);

  var week = new Array("", "", "", "", "", "", "y");

  // J_[EBhE\
  if(openPopup){
    var nRow = nMonth;
    if(nRow > 4)
      nRow = 4;
    var width = 170 * nRow - (3 * (nRow - 1));

    var nColumn = Math.ceil(nMonth / 4);
    var height = 190 * nColumn + 2;

    var x = 100;
    var y = 20;
    switch(browserType){
      // 
      case 0:
      case 2:
        if(event != null){
          x = event.screenX + 30;
          y = event.screenY - 180;
        }
        break;

      // 
      case 1:
        x += window.screenX;
        y += window.screenY;
        break;
    }

    // 
    popup_calendar = createPopup("", "", x, y, width, height);
  }

  // J_[\zp̎擾
  var date_first = date_now; // 1
  var time_first = date_first - (date_first.getDay() * 1000 * 60 * 60 * 24); // ŏ̓j

  time_first = new Date(time_first);

  // HTML쐬
  var str_html = "";
  str_html += "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n";
  str_html += "<html>\r\n";
  str_html += "<head>\r\n";
  str_html += "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=shift_jis\">\r\n";
  str_html += "<title>ް</title>\r\n";
  str_html += "<style>\r\n";
  str_html += "  body { font: 18px; line-height: 12px; margin: 0px; }\r\n";
  str_html += "  th { font: 18px; line-height: 12px; font-weight: 900; }\r\n";
  str_html += "  td { font: 18px; font-family: Arial; line-height: 12px; }\r\n";
  str_html += "  a { text-decoration: none; color: #000000; font: 15px; font-family: Arial; line-height: 12px; }\r\n";
  str_html += "  input { font: 15px; font-family: Arial; line-height: 10px; padding: 0px; }\r\n";
  str_html += "</style>\r\n";
  str_html += "<script type=\"text/javascript\">\r\n";
  str_html += "<!--\r\n";
  str_html += "function setDateValue(name, date, str_format){\r\n";
  str_html += "  opener.setValue(opener.getElementByName2(name), date);\r\n";
  str_html += "\r\n";
  str_html += "  if(str_format != null)\r\n";
  str_html += "    opener.convertValue_format(opener.getElementByName2(name), str_format);\r\n";
  str_html += "\r\n";
  str_html += "  var str_value;\r\n";
  str_html += "  var element_hidden4inputValue = opener.getElementByName2(name + \"_hidden4inputValue\");\r\n";
  str_html += "  if(element_hidden4inputValue != null)\r\n";
  str_html += "    str_value = element_hidden4inputValue.value;\r\n";
  str_html += "  else\r\n";
  str_html += "    str_value = opener.getValueByName(name);\r\n";
  str_html += "\r\n";
  str_html += "  var tokens_value = str_value.split(\"/\");\r\n";
  str_html += "  if(tokens_value.length == 3){\r\n";
  str_html += "    opener.year_set = Number( tokens_value[0] );\r\n";
  str_html += "    opener.month_set = Number( tokens_value[1] ) - 1;\r\n";
  str_html += "    opener.day_set = Number( tokens_value[2] );\r\n";
  str_html += "  }\r\n";
  str_html += "\r\n";
  str_html += "  close();\r\n";
  str_html += "}\r\n";
  str_html += "-->\r\n";
  str_html += "</script>\r\n";
  str_html += "</head>\r\n";
  str_html += "<center>\r\n";
  str_html += "<body bgcolor=\"white\">\r\n";
  str_html += "<form>\r\n";

  var year_now2 = year_now;
  var month_now2 = month_now;
  var day_now2 = day_now;
  if(arguments[4] == null && arguments[5] == null){
    year_now2 = year_set;
    month_now2 = month_set;
    day_now2 = day_set;
  }

  now_yyyymm = year_now2 * 100 + month_now2;

  // 
  for(var ii = 0; ii < nMonth; ii++){
    date_now = new Date(year_now2, month_now2, 1);
    date_first = date_now; // 1
    time_first = date_first - (date_first.getDay() * 1000 * 60 * 60 * 24); // ŏ̓j
    time_first = new Date(time_first);

    var left = (ii % 4) * 168;
    var top = Math.floor(ii / 4) * 190;

    str_html += "<table border=\"0\" bgcolor=\"#dddddd\" bordercolor=\"#dddddd\" width=\"170\" height=\"170\"";
    if(nMonth != 1)
      str_html += " style=\"position: absolute; left: " + left + "; top: " + top + "\";";
    str_html += ">\r\n";

    // 
    str_html += "  <tr id=\"trmonth\" bgcolor=\"orange\" bordercolor=\"orange\" width=\"170\" height=\"17\">\r\n";
    str_html += "  <th colspan=\"7\" width=\"170\" height=\"17\" align=\"center\" style=\"font: 21px; line-height: 12px; font-weight: 900; margin: 0px; padding: 2px;\">\r\n";
    str_html += "    <nobr>\r\n";

    title = year_now2 + "/" + (month_now2 + 1);
    month_now2++;
    if(month_now2 >= 12){
      month_now2 = 0;
      year_now2++;
    }

    str_html += title + "<br>";

    str_html += "<br><input type=\"button\" style=\"font: 15px; font-family: Arial; line-height: 10px; padding: 0px; height: 25px;\" value=\"<<\" ";
    str_html += "onclick=\"opener.calendar(" + nMonth + ", " + startType + ", '" + name + "', " + str_format + ", 0, -1);\">";
    str_html += "<input type=\"button\" style=\"font: 15px; font-family: Arial; line-height: 10px; padding: 0px; height: 25px;\" value=\"<\" ";
    str_html += "onclick=\"opener.calendar(" + nMonth + ", " + startType + ", '" + name + "', " + str_format + ", -1, 0);\">";
    str_html += "<input type=\"button\" style=\"font: 15px; font-family: Arial; line-height: 10px; padding: 0px; height: 25px;\" value=\"o\" ";
    str_html += "onclick=\"opener.calendar(" + nMonth + ", " + startType + ", '" + name + "', " + str_format + ", 0, 0);\">";
    str_html += "<input type=\"button\" style=\"font: 15px; font-family: Arial; line-height: 10px; padding: 0px; height: 25px;\" value=\">\" ";
    str_html += "onclick=\"opener.calendar(" + nMonth + ", " + startType + ", '" + name + "', " + str_format + ", 1, 0);\">";
    str_html += "<input type=\"button\" style=\"font: 15px; font-family: Arial; line-height: 10px; padding: 0px; height: 25px;\" value=\">>\" ";
    str_html += "onclick=\"opener.calendar(" + nMonth + ", " + startType + ", '" + name + "', " + str_format + ", 0, 1);\">\r\n";

    str_html += "    </nobr>\r\n";
    str_html += "  </th>\r\n";
    str_html += "  </tr>\r\n";

    // T
    str_html += "  <tr bgcolor=\"pink\" width=\"170\" height=\"17\">\r\n";

    for(var jj = 0; jj < 7; jj++){
      str_html += "    <th style=\"font: 16px;\" align=\"center\" width=\"17\" height=\"17\">";
      str_html +=       week[jj] + "\r\n";
      str_html += "    </th>\r\n";
    }
    str_html += "  </tr>\r\n";

    // 
    for(var jj = 0; jj < 6; jj++){
      str_html += "  <tr bgcolor=\"#ffffff\">\r\n";

      for(var kk = 0; kk < 7; kk++){
        var day_next = time_first.getTime() + (kk * 1000 * 60 * 60 * 24);
        var date_next = new Date(day_next);

        wrtdate = date_next.getDate();
        var month_next = date_next.getMonth();
        var year_next = date_next.getYear();
        if(year_next < 1900)
          year_next += 1900;

        var next_yyyymm = year_next * 100 + month_next;
        var yyyymmdd = year_next + "/" + (month_next + 1) + "/" + wrtdate;

        var str_html_a  = "<a href=\"javascript:setDateValue('" + name + "', '" + yyyymmdd + "', " + str_format + ");\">";
            str_html_a += "<font color=\"#000000\">";
            str_html_a += wrtdate;
            str_html_a += "</font>";
            str_html_a += "</a>";

        // 
        if(next_yyyymm != now_yyyymm){ 
          str_html += "    <td align=\"center\" bgcolor=\"#cccccc\" width=\"17\" height=\"17\">";
          str_html += str_html_a;
        // 
        } else if(wrtdate  == date_now_temp.getDate()  && month_next == date_now_temp.getMonth() && date_next.getYear() == date_now_temp.getYear()) {
          str_html += "    <td align=\"center\" bgcolor=\"magenta\" width=\"17\" height=\"17\">";
          str_html += "<font color=\"#ffffff\">" + str_html_a + "</font>";
        // 
        } else if(wrtdate  == day_set && month_next == month_set) {
          var year_next = date_next.getYear();
          if(year_next < 1900)
            year_next += 1900;

          if(year_next == year_set){
            str_html += "    <td align=\"center\" bgcolor=\"lime\" width=\"17\" height=\"17\">";
            str_html += "<font color=\"#ffffff\">" + str_html_a + "</font>";
          } else {
            str_html += "    <td align=\"center\" width=\"17\" height=\"17\">";
            str_html += str_html_a;
          }
        // 
        } else {
          str_html += "    <td align=\"center\" width=\"17\" height=\"17\">";
          str_html += str_html_a;
        }

        str_html += "</td>\r\n";
      }

      str_html += "  </tr>\r\n";

      time_first = new Date(day_next);
      time_first = time_first.getTime() + (1000 * 60 * 60 * 24);
      time_first = new Date(time_first);
    }

    now_yyyymm = year_now2 * 100 + month_now2;

    str_html += "</table>\r\n";
  }

  month_now2 -= nMonth;
  if(month_now2 < 0){
    month_now2 += 12;
    year_now2--;
  }
  date_now = new Date(year_now2, month_now2, 1);
  day_now2 = date_now.getDate();

  str_html += "</form>\r\n";

  str_html += "</body>\r\n";
  str_html += "</center>\r\n";
  str_html += "</html>\r\n";

  // EBhE\
  popup_calendar.document.write(str_html);
  popup_calendar.document.close();
  popup_calendar.focus();

  openPopup = true;
}

var clockID;

/** \ */
function showClock(name, reload){
  updateClock(name, reload);

  // XV
  if(reload){
    clearTimeout(clockID);

    // 1bupdateClockĂяo
    clockID = setInterval("updateClock(\"" + name + "\", " + reload + ")", 1000);
  }
}

/** XV */
function updateClock(name, reload){
  var element = getElementByName2(name);
  if(element != null)
    setValue(element, new Date().toLocaleString());
}

/** Lbgړ */
function resetCaretPosition(element){
  if( !element.createTextRange )
    return;

  var textRange = element.createTextRange();
  if(textRange == null)
    return;

  textRange.collapse();
  textRange.move("character", element.value.length);
  textRange.select();

  return;
}

/** tH[JXݒ */
function setFocus(name){
  var element = getElementByName2(name);
  if(element != null){
    if(element.disabled || element.type == "hidden"){
      element = getNextFocusElement(element, true);
      if(element == null)
        return;
    }

    try{
      element.focus();
    } catch(e) {
      return;
    }

    // eLXgtB[hAeLXgGȀꍇALbgړ
    if((element.tagName == "INPUT" && element.type == "text") || element.tagName == "TEXTAREA"){
      resetCaretPosition(element);

      // lI
      if(element.tagName == "INPUT")
        element.select();
    }
  }
}

/** lNbL[ɓo^ς݂ */
function isRegistInCookie(key){
  key = escape(key);

  var index = document.cookie.indexOf(key);
  if(index > 0){
    // 2Ԗڈȍ~ɓo^Ăꍇ
    if(document.cookie.charAt(index - 2) == ";")
      return true;
  } else {
    // o^ĂȂꍇ
    if(index == -1)
      return false;
    // ŏɓo^Ăꍇ
    else
      return true;
  }
}

/** lNbL[ɐݒ */
function setValue2Cookie(key, value){
  document.cookie = escape(key) + "=" + escape(value);
}

/** lNbL[擾 */
function getValueFromCookie(key){
  // lo^ĂȂꍇ
  if( !isRegistInCookie(key) )
    return null;

  key = escape(key);

  var value = "";

  // ؂
  var token = document.cookie.split(key + "=");
  if(token.length > 1){
    value = document.cookie.split(key + "=")[1];
    value = unescape( value.split(";")[0] );
  }

  return value;
}

/** lUserDataɐݒ */
function setValue2UserData(element, key, value){
  element.setAttribute(key, value);
  element.save(key);
}

/** lUserData擾 */
function getValueFromUserData(element, key){
  element.load(key);
  return element.getAttribute(key);
}

/** lUserData폜 */
function removeValueFromUserData(element, key){
  element.removeAttribute(key);
}

/** lUserDataɓo^ς݂ */
function isRegistInUserData(element, key){
  element.load(key);

  // o^Ăꍇ
  if(element.getAttribute(key) != null)
    return true;
  // o^ĂȂꍇ
  else
    return false;
}

/** Elementz񒆂Ɏw肳ꂽElement݂邩 */
function isSelectedElement(name, elements){
  // 
  var nElement = elements.length;
  for(var ii = 0; ii < nElement; ii++){
    if(getElementByName2( elements[ii] ).name == name)
      return true;
  }

  return false;
}

/** tH[f[^userDataɕۑ */
function saveFormData(isAll, elements){
  var all = getFormElements( document.form );

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    var element = all[ii];
    var name = element.name;
    if(element.type == "radio")
      name = element.className.replace(/\ /g, "_");

    // Elementz񒆂Ɏw肳ꂽElement݂邩
    if(!isAll && !isSelectedElement(element.name, elements))
      continue;

    // ̓ACeȊȌꍇ
    if(element.tagName != "INPUT" && element.tagName != "TEXTAREA" && element.tagName != "SELECT")
      continue;
    // {^̏ꍇ
    if(element.tagName == "INPUT" && element.type == "button")
      continue;

    // lUserData擾
    var value = getValueFromUserData(element, name);

    // lݒ肳ĂȂA܂͒lقȂꍇ
    if(value == null || value != element.value){
      value = element.value;

      // 
      if(element.tagName == "INPUT"){
        // `FbN{bNX̏ꍇ
        if(element.type == "checkbox"){
          value = element.checked;
        // WI{^̏ꍇ
        } else if(element.type == "radio") {
          value = element.checked + "\\" + escape( element.value );
        }
      // R{{bNXAXg̏ꍇ
      } else if(element.tagName == "SELECT") {
        value = "";

        var length_options = element.options.length;
        for(var jj = 0; jj < length_options; jj++){
          value += element.options[jj].selected;

          if(jj != length_options - 1)
            value += "\\";
        }
      }

      // lUserDataɐݒ
      setValue2UserData(element, name, value);
    }
  }
}

/** tH[f[^userData擾 */
function getFormData(isAll, elements){
  var all = getFormElements( document.form );

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    var element = all[ii];
    var name = element.name;
    if(element.type == "radio")
      name = element.className.replace(/\ /g, "_");

    // lUserDataɓo^ς݂
    if( !isRegistInUserData(element, name) )
      continue;

    // Elementz񒆂Ɏw肳ꂽElement݂邩
    if(!isAll && !isSelectedElement(element.name, elements))
      continue;

    // lUserData擾
    var value = getValueFromUserData(element, name);

    // lݒ肳Ăꍇ
    if(value != null){
      // 
      if(element.tagName == "INPUT"){
        // `FbN{bNX̏ꍇ
        if(element.type == "checkbox"){
          if(value == "true")
            element.checked = true;
          else
            element.checked = false;
        // WI{^̏ꍇ
        } else if(element.type == "radio") {
          element.checked = false;

          var token = value.split("\\");

          if(token[0] == "true" && element.value == token[1])
            element.checked = true;
        // eLXgtB[hApX[htB[hAeLXgGȀꍇ
        } else {
          element.value = value;
        }
      // R{{bNXAXg̏ꍇ
      } else if(element.tagName == "SELECT") {
        var token = value.split("\\");

        var length_options = element.options.length;
        for(var jj = 0; jj < length_options; jj++){
          if(token[jj] == "true")
            element.options[jj].selected = true;
          else
            element.options[jj].selected = false;
        }
      // 
      } else {
        element.value = value;
      }
    }
  }
}

/** tH[f[^userData폜 */
function deleteFormData(isAll, elements){
  var all = getFormElements( document.form );

  // 
  var nElement = all.length;
  for(var ii = 0; ii < nElement; ii++){
    var element = all[ii];
    var name = element.name;
    if(element.type == "radio")
      name = element.className.replace(/\ /g, "_");

    // Elementz񒆂Ɏw肳ꂽElement݂邩
    if(!isAll && !isSelectedElement(element.name, elements))
      continue;

    // ̓ACeȊȌꍇ
    if(element.tagName != "INPUT" && element.tagName != "TEXTAREA" && element.tagName != "SELECT")
      continue;
    // {^̏ꍇ
    if(element.tagName == "INPUT" && element.type == "button")
      continue;

    // lUserDataɐݒ
    setValue2UserData(element, name, "");
  }
}

/** Mf[^폜 */
function deletePostData(){
  if( confirm("Mf[^폜܂?") )
    post("./FormDataRemover?responseType=REMOVE");
}

/** ĂяotH[Elementɒlݒ */
function setValue2Opener(names_child, name_parent){
  var value = "";

  // ݒ肷l쐬
  var length_names_child = names_child.length;
  for(var ii = 0; ii < length_names_child; ii++){
    var element_child = getElementByName2( names_child[ii] );
    if(element_child != null)
      value += element_child.value;
  }

  // ĂяotH[Element擾
  var element_parent = opener.document.getElementsByName(name_parent)[0];
  // lݒ
  if(element_parent != null)
    element_parent.value = value;
}

/** ĂяotH[Elementɒlݒij */
function setValues2Opener(names_child, names_parent){
  // 
  var length_names_child = names_child.length;
  for(var ii = 0; ii < length_names_child; ii++){
    // tH[Element擾
    var element_child = getElementByName2( names_child[ii] );
    if(element_child == null)
      continue;

    // ĂяotH[Element擾
    var element_parent = opener.document.getElementsByName( names_parent[ii] )[0];
    // lݒ
    if(element_parent != null)
      element_parent.value = element_child.value;
  }
}

/** 摜pEBhE\ */
function showPopup4Image(src, magnifyRate_w, magnifyRate_h, fit, width, height){
  // IMG^O쐬
  var element_img = document.createElement("img");
  element_img.setAttribute("src", src);

  var popup_image = createPopup("", "", null, null, width, height);

  var str_html = "";
  str_html += "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n";
  str_html += "<html>\r\n";
  str_html += "<head>\r\n";
  str_html += "<script type=\"text/javascript\">\r\n";
  str_html += "<!--\r\n";
  str_html += "  function showPopup4Image(src, magnifyRate_w, magnifyRate_h, fit, width, height){\r\n";
  str_html += "    var image = new Image();\r\n";
  str_html += "    image.src = src;\r\n";
  str_html += "\r\n";
  str_html += "    // 摜TCYgAkꍇ\r\n";
  str_html += "    if( !fit ){\r\n";
  str_html += "      width = image.width * magnifyRate_w;\r\n";
  str_html += "      height = image.height * magnifyRate_h;\r\n";
  str_html += "    }\r\n";
  str_html += "\r\n";
  str_html += "    var element_img = document.getElementsByName(\"image\")[0];\r\n";
  str_html += "    element_img.width = width;\r\n";
  str_html += "    element_img.height = height;\r\n";
  str_html += "\r\n";
  str_html += "    window.innerWidth = width;\r\n";
  str_html += "    window.innerHeight = height;\r\n";

  var height_diff = 0;
  switch(browserType){
    // 
    case 0:
    case 2:
      width_diff = 16;
      height_diff = 64;
      break;

    // 
    case 1:
      width_diff = 32;
      height_diff = 52;
      break;
  }
  str_html += "    window.resizeTo(width + " + width_diff + ", height + " + height_diff + ");\r\n";

  str_html += "  }\r\n";
  str_html += "-->\r\n";
  str_html += "</script>\r\n";
  str_html += "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=shift_jis\">\r\n";
  str_html += "<title>" + src + "</title>\r\n";
  str_html += "</head>\r\n";
  str_html += "<body onload=\"showPopup4Image('" + src + "', " + magnifyRate_w + ", " + magnifyRate_h + ", " + fit + ", " + width + ", " + height + ");\">\r\n";
  str_html += "<center>\r\n";
  str_html += "<img name=\"image\" src=\"" + src + "\">\r\n";
  str_html += "</center>\r\n";
  str_html += "</body>\r\n";
  str_html += "</html>\r\n";

  // EBhE\
  popup_image.document.write(str_html);
  popup_image.document.close();
  popup_image.focus();
}

/** IɃe[usǉ */
function addRowDynamically(element, type, tableID, pos){
  // MURLݒ
  document.form.action = "XmlImporter";

  // Bf[^ݒ
  document.form.TABLE_ID.value = tableID;
  document.form.TABLE_FUNCTION.value = pos;
  document.form.COUNT.value = "1";
  document.form.BTN_NAME.value = element.name;
  document.form.ADDROW_TYPE.value = type;

  // f[^𑗐M
  post( document.form.action );
}

/** IɃe[us폜 */
function deleteRowDynamically(element, tableID){
  var element_table = getElementByNameFromDocument(tableID);
  var nAction = 0;
  var str_triggers = new Array("onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onkeydown", "onkeyup", "onfocus", "onblur", "onchange");
  var length_str_triggers = str_triggers.length;

  // sǉA폜ΏۍsJEg
  var rows = element_table.getElementsByTagName("TR");
  if(rows != null){
    var length_rows = rows.length;
    for(var ii = 0; ii < length_rows; ii++){
      // s擾
      var row = rows[ii];
      var includeAction = false;

      // Zz擾
      var cells = row.getElementsByTagName("TD");
      var length_cells = cells.length;
      for(var jj = 0; jj < length_cells; jj++){
        // Z擾
        var cell = cells[jj];
        // ZElementz擾
        var childNodes = cell.childNodes;

        var length_childNodes = childNodes.length;
        for(var kk = 0; kk < length_childNodes; kk++){
          var child = childNodes[kk];

          // egKɓo^ĂANV𒲍
          for(var ll = 0; ll < length_str_triggers; ll++){
            var str_trigger = str_triggers[ll];
            var attributes = child.attributes;
            if(attributes != null && attributes.getNamedItem(str_trigger) != null && attributes.getNamedItem(str_trigger).nodeValue != null){
              var nodeValue = attributes.getNamedItem(str_trigger).nodeValue;
              if(nodeValue.indexOf("addRowDynamically") != -1 || nodeValue.indexOf("deleteRowDynamically") != -1){
                includeAction = true;
                break;
              }
            }
          }
        }

        if(includeAction){
          nAction++;
          break;
        }
      }
    }
  }

  // G[bZ[W\
  if(nAction <= 1){
    alert("Ō̍s͍폜o܂");
    return;
  }

  // MURLݒ
  document.form.action = "XmlImporter";

  // Bf[^ݒ
  document.form.TABLE_ID.value = tableID;
  document.form.TABLE_FUNCTION.value = "delete";
  document.form.COUNT.value = "1";
  document.form.BTN_NAME.value = element.name;

  // f[^𑗐M
  post( document.form.action );
}

/**  */
function getItemValue(element){
  var values = new Array();

  // R{{bNXAXg̏ꍇ
  if(element.tagName == "SELECT"){
    var nSelected = 0;
    var nMatch_select = 0;

    var length_options = element.options.length;
    for(var ii = 0; ii < length_options; ii++){
      if( element.options[ii].selected )
        values.push( element.options[ii].value );
    }
  } else {
    // `FbN{bNXꍇ
    if(element.type == "checkbox"){
      if( element.checked )
        values.push( element.value );
    // WI{^̏ꍇ
    } else if(element.type == "radio") {
      if( element.checked )
        values.push( element.value );
    // eLXgtB[hApX[htB[hAeLXgGȀꍇ
    } else {
      values.push( element.value );
    }
  }

  return values;
}

/** ACe͍ς݂ */
function isInputtedItem(element){
  var isInputted = false;

  // x̏ꍇ
  if(element.tagName == "SPAN"){
    if(element.innerHTML != "")
      isInputted = true;
  // R{{bNXAXg̏ꍇ
  } else if(element.tagName == "SELECT") {
    var length_options = element.options.length;
    for(var ll = 0; ll < length_options; ll++){
      if( element.options[ll].selected ){
        isInputted = true;
        break;
      }
    }
  } else {
    // `FbN{bNXꍇ
    if(element.type == "checkbox"){
      if( element.checked )
        isInputted = true;
    // WI{^̏ꍇ
    } else if(element.type == "radio") {
      if( element.checked )
        isInputted = true;
    // eLXgtB[hApX[htB[hAeLXgGȀꍇ
    } else {
      if( element.value )
        isInputted = true;
    }
  }

  return isInputted;
}

/** e[u̍sA폜 */
function deleteTable(isRow, type, name_table, elements){
  // wElementɒl͂ĂȂ΍폜
  if(type == 0){
    // e[uElement擾
    var tables;
    switch(browserType){
      // 
      case 0:
      case 2:
        tables = document.all.tags("TABLE");
        break;

      // 
      case 1:
        tables = document.getElementsByTagName("TABLE");
        break;
    }

    var length_tables = tables.length;
    var nElement = elements.length;
    for(var ii = 0; ii < length_tables; ii++){
      for(var jj = 0; jj < nElement; jj++){
        // s폜
        if(isRow)
          deleteRowByValue(tables[ii], elements[jj]);
        // 폜
        else
          deleteColumnByValue(tables[ii], elements[jj]);
      }
    }
  // Iɍ폜
  } else {
    // e[uElement擾
    var table = getElementByName2(name_table);

    // s폜
    if(isRow)
      deleteRowCompulsorily(table, elements);
    // 폜
    else
      deleteColumnCompulsorily(table, elements);
  }
}

/** wElementɒl͂ĂȂ΃e[us폜 */
function deleteRowByValue(table, name){
  if(table == null)
    return;

  // sz擾
  var rows = table.getElementsByTagName("TR");
  if(rows == null)
    return;

  var length_rows = rows.length;
  for(var ii = 0; ii < length_rows; ii++){
    // s擾
    var row = rows[ii];

    // Zz擾
    var cells = row.getElementsByTagName("TD");
    var length_cells = cells.length;
    for(var jj = 0; jj < length_cells; jj++){
      // Z擾
      var cell = cells[jj];
      // ZElementz擾
      var childNodes = cell.childNodes;

      var length_childNodes = childNodes.length;
      for(var kk = 0; kk < length_childNodes; kk++){
        var child = childNodes[kk];

        // e[ȕꍇAċA
        if(child.tagName == "TABLE"){
          deleteRowByValue(child, name);
        } else {
          // l͂ĂȂꍇ
          if(name == getName(child) && !isInputtedItem(child)){
            // s
            var rowspan;
            switch(browserType){
              // 
              case 0:
              case 2:
                rowspan = new Number( cell.attributes.getNamedItem("rowspan").nodeValue );
                break;

              // 
              case 1:
                rowspan = cell.rowspan
                break;
            }

            if(rowspan == null)
              rowspan = 1;

            for(var ll = ii + rowspan - 1; ll >= ii; ll--){
              var row2 = rows[ll];

              // Zz擾
              var cells2 = row2.getElementsByTagName("TD");
              var length_cells2 = cells2.length;
              for(var mm = 0; mm < length_cells2; mm++){
                // Z擾
                var cell2 = cells2[mm];
                // ZElementz擾
                var childNodes2 = cell2.childNodes;

                var length_childNodes2 = childNodes2.length;
                for(var nn = 0; nn < length_childNodes2; nn++){
                  var child2 = childNodes2[nn];
                  if(child2.name != null){
                    // lBf[^ɕۑ
                    var values = getItemValue(child2);
                    if(values.length > 0)
                      setValue2Hidden(child2.name, "_hidden4post", values[0]);
                  }
                }
              }

              // s폜
              table.deleteRow(ll);
            }

            return;
          }
        }
      }
    }
  }
}

/** wElementɒl͂ĂȂ΃e[u폜 */
function deleteColumnByValue(table, name){
  if(table == null)
    return;

  // sz擾
  var rows = table.getElementsByTagName("TR");
  if(rows == null)
    return;

  var found = false;
  // CfbNXz
  var iColumns = new Array(1);

  var length_rows = rows.length;
  for(var ii = 0; ii < length_rows; ii++){
    // s擾
    var row = rows[ii];

    // Zz擾
    var cells = row.getElementsByTagName("TD");
    var length_cells = cells.length;
    for(var jj = 0; jj < length_cells; jj++){
      // ZElementz擾
      var childNodes = cells[jj].childNodes;

      var length_childNodes = childNodes.length;
      for(var kk = 0; kk < length_childNodes; kk++){
        var child = childNodes[kk];

        // e[ȕꍇAċA
        if(child.tagName == "TABLE"){
          deleteColumnByValue(child, name);
        } else {
          // l͂ĂȂꍇ
          if(name == getName(child) && !isInputtedItem(child)){
            iColumns[0] = jj + 1;
            found = true;

            break;
          }
        }
      }
    }
  }

  // IɃe[u폜
  if(found)
    deleteColumnCompulsorily(table, iColumns);
}

/** IɃe[us폜 */
function deleteRowCompulsorily(table, indices){
  if(table == null)
    return;

  // sz擾
  var rows = table.getElementsByTagName("TR");
  if(rows == null)
    return;

  var length_rows = rows.length;
  var length_indices = indices.length;
  for(var ii = length_rows - 1; ii >= 0; ii--){
    for(var jj = 0; jj < length_indices; jj++){
      // s폜
      if(ii == indices[jj] - 1)
        table.deleteRow(ii);
    }
  }
}

/** IɃe[u폜 */
function deleteColumnCompulsorily(table, indices){
  if(table == null)
    return;

  // sz擾
  var rows = table.getElementsByTagName("TR");
  if(rows == null)
    return;

  var length_indices = indices.length;
  var length_row = rows.length;
  for(var ii = length_indices - 1; ii >= 0; ii--){
    var index = indices[ii] - 1;

    for(var jj = 0; jj < length_row; jj++){
      // s擾
      var row = rows[jj];
      // Zz擾
      var cells = row.getElementsByTagName("TD");
      var iCell = 0;

      var length_cells = cells.length;
      for(var kk = 0; kk < length_cells; kk++){
        // Z擾
        var cell = cells[kk];

        // s
        var rowspan;
        switch(browserType){
          // 
          case 0:
          case 2:
            rowspan = new Number( cell.attributes.getNamedItem("rowspan").nodeValue );
            break;

          // 
          case 1:
            rowspan = cell.rowspan;
            break;
        }

        if(rowspan == null)
          rowspan = 1;

        // 
        var colspan;
        switch(browserType){
          // 
          case 0:
          case 2:
            colspan = new Number( cell.attributes.getNamedItem("colspan").nodeValue );
            break;

          // 
          case 1:
            colspan = cell.colspan;
            break;
        }

        if(colspan == null)
          colspan = 1;

        // 
        if(iCell == index){
          // 폜
          row.deleteCell(kk);

          jj += rowspan - 1;
          break;
        }

        iCell += colspan;
      }
    }
  }
}

/** checkEssentialItems() for custom script */
function checkEssentialItems4CustomScript(){
  return checkEssentialItems2( new Array() );
}

