/**
 * 更新履歴の表示・非表示制御
 * 
 * @return なし
 */
function showChangeLog() {
  if (changeLogPane.style.display == 'none') {
    changeLogPane.style.display = 'block';
  } else {
    changeLogPane.style.display = 'none';
  }
}

/**
 * 指定されたテキストボックスの値を空文字にする
 * 
 * @param inputFields
 *          テキストボックス名の配列ｓ
 * @return なし
 */
function clearInputFields(inputFields) {
  var fields_length = inputFields.length;
  for ( var i = 0; i < fields_length; i++) {
    var fieldName = inputFields[i];
    var field = getElementByName(fieldName);
    field.value = '';
  }
}

/**
 * 表オブジェクトにおいて、<br>
 * 第一引数のオブジェクトが属する行から、第二引数のオブジェクトの値を取得する
 * 
 * @param src
 * @param target
 * @return targetの値
 */
function getRowId(src, target) {
  // 表オブジェクトはデータ行が一行の時と、複数行の時とでオブジェクトの名前が異なる。
  // 一行のときは、デザイナで設計したとおりの名前。
  // 複数行のときは、サフィックスに「_R_行番号」が付加される
  // 下記はこれを踏まえて実装されている

  var rowId;

  if (src.name.indexOf("_R_") != -1) {
    // オブジェクト名に_R_が含まれていれば、データ行が複数行だと認識する
    var nameArr = src.name.split("_R_", 2);
    var lineNo = nameArr[1];
    var lineStr = "_R_" + lineNo;
    rowId = getValueByName(target + lineStr);

  } else {
    // データ行が一行のとき
    rowId = getValueByName(target);

  }

  return rowId;
}

/**
 * 別ウィンドウを開く
 * 
 * @param url
 * @return なし
 */
function showAnotherWindow(url) {
  showAnotherWindow(url, 1024, 660);
}

/**
 * 別ウィンドウを開く
 * 
 * @param url
 * @param width
 * @param height
 * @return なし
 */
function showAnotherWindow(url, width, height) {
  linkToURL(true, url, width, height);
}

/**
 * 
 * 表オブジェクトから、削除チェックボックスがチェックされた行の<br>
 * キー情報を取得し、これを指定されたテキストボックスに代入する
 * 
 * @param delFlgName
 *          チェックボックス名
 * @param idName
 *          キーフィールド名
 * @param delIds
 *          キー情報を代入するテキストボックス
 * @return なし
 */
function findDelTarget(delFlgName, idName, delIds) {
  var allElems = getAllElements();
  var allElemLength = allElems.length;
  var delIdsField = getElementByName(delIds);
  delIdsField.value = "";

  for ( var i = 0; i < allElemLength; i++) {
    var elem = allElems[i];
    if (elem.name != null && elem.name.indexOf(delFlgName) != -1) {
      if (elem.checked) {
        var nameArr = elem.name.split("_R_", 2);
        var lineNo = nameArr[1];
        if (lineNo != null) {
          var lineStr = "_R_" + lineNo;
          var idValue = getValueByName(idName + lineStr);
          if (delIdsField.value.length > 0) {
            delIdsField.value = delIdsField.value + "|";
          }
          delIdsField.value = delIdsField.value + idValue;
        }
      }
    }
  }

}

/**
 * スクロールエリアの幅と高さを変更する
 * 
 * @param id
 *          スクロールエリアのID
 * @param widthMargin
 *          画面幅のマージン
 * @param heightMargin
 *          画面高のマージン
 * @return なし
 */
function adjustScrollArea(id, widthMargin, heightMargin) {
  var width = document.body.clientWidth;
  var height = document.body.clientHeight;
  var scrollArea = document.getElementById(id);

  scrollArea.style.width = width - widthMargin;
  scrollArea.style.height = height - heightMargin;
}

/**
 * スクロールエリアの高さを変更する
 * 
 * @param id
 *          スクロールエリアのID
 * @param heightMargin
 *          画面高のマージン
 * @return なし
 */
function adjustScrollAreaHeight(id, heightMargin) {
  var height = document.body.clientHeight;
  var scrollArea = document.getElementById(id);

  scrollArea.style.height = height - heightMargin;
}

/**
 * 子画面から呼出し元ウィンドウに値を戻す<br>
 * 第一引数のオブジェクトの行から、第二引数のオブジェクトの値をもどす
 * 
 * @param id
 * @param srcs
 * @return
 */
function sendDatas2Parent(id, srcs) {
  var dlm = "_R_";
  var nameArr = id.name.split(dlm, 2);
  var lineNo = nameArr[1];
  var lineStr = dlm + lineNo;

  var fields_length = srcs.length;
  for ( var i = 0; i < fields_length; i++) {
    var fieldName = srcs[i];

    var value = getValueByName(fieldName + lineStr);
    var parent = opener.document.getElementsByName(fieldName)[0];
    parent.value = value;

  }

  window.close();
}
