/**
 * 
 * StraformX
 * XmlImporter(XMLデータをHTMLに差し込んで表示する)APIを利用するサンプル
 *
 */

package jp.co.epson.watch.plaWasabi.stxsample;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.fit.stx.servercomponent.core.XmlImporter;
import jp.co.fit.stx.servercomponent.core.XmlImporterIF;

public class XmlImporterSample extends HttpServlet {
  private static final long serialVersionUID = -4179302240112304672L;
  // 設定
  private String currentDir;
  private String dataDir = "";
  private String xslFile = "gijiroku.xsl";
  private String htmlFile = "gijiroku_i.htm";
  private String datapath = "/WEB-INF/stxdata";

  protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,
      IOException {
    // HTMLファイル、XMLファイル、XSLファイル
    ServletContext sc = getServletConfig().getServletContext();
    currentDir = sc.getRealPath("/") + "stxsample" + File.separator;
    dataDir = sc.getRealPath(datapath) + File.separator; // データxmlの格納ディレクトリの取得

    // ID指定の取得
    String id = req.getParameter("id");

    // 結果出力をresponseに設定して、HTML生成を呼び出し
    importTest(res.getOutputStream(), id);
//    importTest(System.out, id);

  }

  // XMLのデータを入力フォームにセットする。
  private void importTest(OutputStream out, String id) {
    int rv = -1;
    FileInputStream input_html = null;
    FileInputStream[] xmls = null;
    FileInputStream[] xsls = null;

    try {
      input_html = new FileInputStream(currentDir + htmlFile);
      String datapath = dataDir + id + ".xml";
      File xmlfile = new File(datapath);

      if ((id != null) && (xmlfile.exists())) {
        // ID指定のある場合は、対応XMLを読み込みインポートする
        xmls = new FileInputStream[] { new FileInputStream(datapath) };
        xsls = new FileInputStream[] { new FileInputStream(currentDir + xslFile) };

        // XmlImporterを呼び出し
        XmlImporterIF xi = new XmlImporter();
        rv = xi.importer(XmlImporter.IMPORT_FOR_INPUT, xmls, xsls, input_html, out);

      } else {
        // ID指定のない場合は、htmlをそのまま出力
        int c;
        while ((c = input_html.read()) != -1) {
          out.write(c);
        }
      }
      if (rv == 0) {
        System.out.println("XmlImporter OK.");
      }

    } catch (Exception e) {
      e.printStackTrace();

    } finally {
      try {
        input_html.close();
        if (xmls != null) {
          for (int i = 0; i < xmls.length; i++) {
            xmls[i].close();
          }
        }
        if (xsls != null) {
          for (int i = 0; i < xsls.length; i++) {
            xsls[i].close();
          }
        }
        out.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }

  }
}
