/**
 * 
 * StraformX
 * XmlImporter(XMLデータをHTMLに差し込んで表示する)APIを利用するサンプル
 *
 */

package jp.co.epson.watch.plaWasabi.stxServlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.epson.watch.plaWasabi.entity.Zifile;
import jp.co.epson.watch.plaWasabi.service.ZifileService;

import org.seasar.framework.container.SingletonS2Container;

public class Image extends HttpServlet {
  private static final long serialVersionUID = -5447249644471527862L;

  private static final String imageFile = "noimage.jpg";
  private static final String datapath = "/img";

  protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,
      IOException {

    String cal = req.getParameter("cal");
    String plan = req.getParameter("plan");

    ZifileService zifileService = SingletonS2Container.getComponent(ZifileService.class);
    Zifile zifile = zifileService.findById(cal + "-" + plan + ".JPG");

    if (zifile == null) {
      zifile = zifileService.findById(plan + ".JPG");
    }

    if (zifile != null && zifile.zifi200 != null) {
      for (int i = 0; i < zifile.zifi200.length; i++) {
        res.getOutputStream().write(zifile.zifi200[i]);
      }

    } else {
      ServletContext sc = getServletConfig().getServletContext();
      String dataDir = sc.getRealPath(datapath) + File.separator;

      String filePath = dataDir + imageFile;

      InputStream is = new FileInputStream(new File(filePath));

      int b;
      while ((b = is.read()) != -1) {
        res.getOutputStream().write(b);
      }

    }

  }

}
