package jp.co.epson.watch.plaWasabi.service.schema.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.epson.watch.plaWasabi.entity.UserTabColumns;
import jp.co.epson.watch.plaWasabi.entity.UserTables;
import jp.co.epson.watch.plaWasabi.service.schema.CacheManager;
import jp.co.epson.watch.plaWasabi.service.schema.DbColumnDef;
import jp.co.epson.watch.plaWasabi.service.schema.DbTableDef;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.jdbc.OrderByItem;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.DestroyMethod;
import org.seasar.framework.container.annotation.tiger.InitMethod;

public class CacheManagerService implements CacheManager {
  
  /**
   * Commons Logging instance.
   */
  private static Log log = LogFactory.getLog(CacheManager.class);

  @Binding
  private JdbcManager jdbcManager;
  
  private long initialized = 0;
  private Map<String, UserTables> userTables;
  private Map<String, UserTabColumns> userTabColumns;
  private Map<String, List<UserTables>> columnTablesMapping;
  
  @InitMethod
  @Override
  public synchronized void init() {
    log.info("Start Initialization");
    long start = System.currentTimeMillis();
    this.destroy();
    List<UserTables> _userTables = this.jdbcManager.from(UserTables.class)
      .innerJoin("userTabColumnsList")
      .innerJoin("userTabColumnsList.userColComments")
      .leftOuterJoin("userTabColumnsList.userConsColumnsList")
      .leftOuterJoin("userTabColumnsList.userConsColumnsList.userConstraints")
      .leftOuterJoin("userTabColumnsList.userConsColumnsList.userConstraints.rUserConsColumnsList")
      .leftOuterJoin("userTabColumnsList.userConsColumnsList.userConstraints.rUserConsColumnsList.rUserConstraints")
      .orderBy(
    		  new OrderByItem("T1_.TABLE_NAME")
    		  ,new OrderByItem("T2_.COLUMN_NAME")
    		  ,new OrderByItem("T4_.POSITION")
    		  ,new OrderByItem("T6_.POSITION"))
      .getResultList();

    this.userTables = new HashMap<String, UserTables>();
    this.userTabColumns = new HashMap<String, UserTabColumns>();
    this.columnTablesMapping = new HashMap<String, List<UserTables>>();
    
    for (UserTables userTable : _userTables)
    {
      userTable.init();
      this.userTables.put(userTable.tableName, userTable);
      for (UserTabColumns userTabColumn : userTable.userTabColumnsList)
      {
        this.userTabColumns.put(userTable.tableName + "." + userTabColumn.columnName, userTabColumn);
        if (this.columnTablesMapping.containsKey(userTabColumn.columnName))
        {
         List<UserTables> tmp = (List<UserTables>)this.columnTablesMapping.get(userTabColumn.columnName);
         tmp.add(userTable);
        }
        else
        {
          List<UserTables> tmp = new ArrayList<UserTables>();
          tmp.add(userTable);
          this.columnTablesMapping.put(userTabColumn.columnName, tmp);
        }
      }
    }
    this.initialized = System.currentTimeMillis();
    log.info("Complete Initialization " + ((this.initialized - start)/1000) + " second(s)");
  }
  
  @DestroyMethod
  @Override
  public synchronized void destroy() {
    log.info("Destroying...");
    if (null != this.userTables)
    {
//      Set<String> keySet = this.userTables.keySet();
//      Iterator<String> iterator = keySet.iterator();
//      while (iterator.hasNext())
//      {
//        String key = iterator.next();
//        UserTables userTable = this.userTables.get(key);
//        userTable.destroy();
//      }
      this.userTables.clear();
      this.userTables = null;
    }
    if (null != this.userTabColumns)
    {
      this.userTabColumns.clear();
      this.userTabColumns = null;
    }
    if (null != this.columnTablesMapping)
    {
      this.columnTablesMapping.clear();
      this.columnTablesMapping = null;
    }
    this.initialized = 0;
  }

  @Override
  public synchronized DbColumnDef getColumn(String columnName) {
    if (this.columnTablesMapping.containsKey(columnName.toUpperCase()))
    {
      List<UserTables> tmp = this.columnTablesMapping.get(columnName.toUpperCase());
      if (tmp.size() == 1)
      {
        return this.getColumn(tmp.get(0).tableName ,columnName.toUpperCase());
      }
      else if (tmp.size() > 1)
      {
        throw new WasabiRuntimeException("Duplicate Column name does exist.");
      }
      else
      {
        throw new WasabiRuntimeException("Invalid size()=" + tmp.size() + " : getColumn('" + columnName + "')");
      }
    }
    else
    {
      return null;
    }
  }

  @Override
  public synchronized DbColumnDef getColumn(String tableName, String columnName) {
    return this.userTabColumns.get(tableName.toUpperCase() + "." + columnName.toUpperCase());
  }

  @Override
  public synchronized DbTableDef getTable(String tableName) {
    return this.userTables.get(tableName.toUpperCase());
  }

  

}
