package jp.co.epson.watch.plaWasabi.service;

import static jp.co.epson.watch.plaWasabi.entity.WaterproofNames.waterproofId;
import static org.seasar.extension.jdbc.operation.Operations.asc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

import jp.co.epson.watch.plaWasabi.entity.Waterproof;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * {@link Waterproof}のサービスクラスです。
 * 
 * @author S2JDBC-Gen
 */
public class WaterproofService extends AbstractService<Waterproof> {

  /**
   * 識別子でエンティティを検索します。
   * 
   * @param waterproofId
   *          識別子
   * @return エンティティ
   */
  public Waterproof findById(String waterproofId) {
    return select().id(waterproofId).getSingleResult();
  }

  /**
   * 識別子の昇順ですべてのエンティティを検索します。
   * 
   * @return エンティティのリスト
   */
  public List<Waterproof> findAllOrderById() {
    return select().orderBy(asc(waterproofId())).getResultList();
  }

  public InputStream getJSON() {
    JSONArray array = new JSONArray();

    List<Waterproof> waterproofs = this.findAll();
    for (Waterproof waterproof : waterproofs) {
      JSONObject jsonObj = new JSONObject();
      jsonObj.put("name", waterproof.waterproofName);
      jsonObj.put("label", waterproof.waterproofId);
      array.add(jsonObj);
    }

    StringBuilder jsonStr = new StringBuilder();
    jsonStr.append("{ identifier: 'label',items: ");
    jsonStr.append(array.toString());
    jsonStr.append("}");

    InputStream is = new ByteArrayInputStream(jsonStr.toString().getBytes(Charset.forName("UTF-8")));

    return is;
  }

}