package jp.co.epson.watch.plaWasabi.service;

import static jp.co.epson.watch.plaWasabi.entity.ChangeLogNames.seq;
import static org.seasar.extension.jdbc.operation.Operations.asc;

import java.math.BigInteger;
import java.util.List;

import jp.co.epson.watch.plaWasabi.entity.ChangeLog;

public class ChangeLogService extends AbstractService<ChangeLog> {

  /**
   * 識別子でエンティティを検索します。
   * 
   * @param seq
   *          識別子
   * @return エンティティ
   */
  public ChangeLog findById(BigInteger seq) {
    return select().id(seq).getSingleResult();
  }

  /**
   * 識別子の昇順ですべてのエンティティを検索します。
   * 
   * @return エンティティのリスト
   */
  public List<ChangeLog> findAllOrderById() {
    return select().orderBy(asc(seq())).getResultList();
  }

}