package jp.co.epson.watch.plaWasabi.security;

import java.io.Serializable;
import java.security.Principal;

public class UserPrincipal implements Principal, Serializable {

  private static final long serialVersionUID = -8112240081933019031L;
  private String name;

  public UserPrincipal(String name) {
    if (name == null) {
      throw new NullPointerException();
    }
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public boolean equals(Object obj) {
    if (obj == null)
      return false;

    if (this == obj)
      return true;

    if (!(obj instanceof UserPrincipal))
      return false;
    UserPrincipal that = (UserPrincipal) obj;

    if (this.getName().equals(that.getName()))
      return true;
    return false;
  }

  public int hashCode() {
    return name.hashCode();
  }

  public String toString() {
    return name;
  }

}
