package jp.co.epson.watch.plaWasabi.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;

import jp.co.epson.watch.plaWasabi.service.schema.DbColumnDef;
import jp.co.epson.watch.plaWasabi.service.schema.DbTableDef;

@Entity
public class UserTables implements DbTableDef {

  /** tableNameプロパティ */
  @Id
  @Column
  public String tableName;

  @OneToMany(mappedBy="userTables")
  public List<UserTabColumns> userTabColumnsList;

  
  
  
  @Transient
  private List<DbColumnDef> columns = null;
  
  @Transient
  private List<DbColumnDef> primaryKey = null;
  
  @Transient
  private List<Map<DbColumnDef, DbColumnDef>> foreignKeys = null;
  
  
  public synchronized void init()
  {
    // Column
    if (null == this.columns)
    {
      this.columns = new ArrayList<DbColumnDef>(this.userTabColumnsList); 
    }
    // Primary Key
    if (null == this.primaryKey)
    {
      this.primaryKey = new ArrayList<DbColumnDef>();
      for (UserTabColumns utc : this.userTabColumnsList)
      {
        if (utc.isPrimaryKey())
        {
          this.primaryKey.add(utc);
        }
      }
    }
    // Foreign Keys
    if (null == this.foreignKeys)
    {
      Map<String, Map<DbColumnDef, DbColumnDef>> FKsMap
        = new HashMap<String, Map<DbColumnDef, DbColumnDef>>();
      for (UserTabColumns col : this.userTabColumnsList)
      {
        Map<String,DbColumnDef> colFKsMap = col.getForeingKey();
        Set<String> keySet = colFKsMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext())
        {
          String FKname = iterator.next().toString();
          DbColumnDef FKcol
            = (DbColumnDef)colFKsMap.get(FKname);
          
          if (FKsMap.containsKey(FKname))
          {
            Map<DbColumnDef, DbColumnDef> FKMap = FKsMap.get(FKname);
            FKMap.put(col, FKcol);
          }
          else
          {
            Map<DbColumnDef, DbColumnDef> FKMap = new HashMap<DbColumnDef, DbColumnDef>();
            FKMap.put(col, FKcol);
            FKsMap.put(FKname, FKMap);
          }
        }
      }
      this.foreignKeys = new ArrayList<Map<DbColumnDef, DbColumnDef>>();
      Set<String> keySet = FKsMap.keySet();
      Iterator<String> iterator = keySet.iterator();
      while (iterator.hasNext())
      {
        this.foreignKeys.add(FKsMap.get(iterator.next().toString()));
      }
    }
  }
  
  public synchronized void destroy()
  {
    if (null != this.columns)
    {
      this.columns.clear();
      this.columns = null;
    }
    if (null != this.primaryKey)
    {
      this.primaryKey.clear();
      this.primaryKey = null;
    }
    if (null != this.foreignKeys)
    {
      this.foreignKeys.clear();
      this.foreignKeys = null;
    }
  }
  
  
  @Override
  public List<DbColumnDef> getColumns() { 
    return this.columns;
  }

  @Override
  public List<Map<DbColumnDef, DbColumnDef>> getForeignKeys() {
    return this.foreignKeys;
  }

  @Override
  public String getName() {
    return this.tableName.toLowerCase();
  }

  @Override
  public List<DbColumnDef> getPrimaryKey() {
    return this.primaryKey;
  }

	@Override
	public DbColumnDef getColumn(String columnName) {
	for (DbColumnDef col : this.columns)
	{
		if (0 == col.getName().compareToIgnoreCase(columnName))
		{
			return col;
		}
	}
	return null;
}

}