/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.co.epson.watch.plaWasabi.action.stx.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.fit.stx.servercomponent.core.HtmlTableAction;
import jp.co.fit.stx.servercomponent.core.HtmlTableActionIF;
import jp.co.fit.stx.servercomponent.core.XmlExporter;
import jp.co.fit.stx.servercomponent.core.XmlExporterIF;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.Execute;

public class TableAction {

  @Resource
  private HttpServletRequest request;

  @Resource
  private HttpServletResponse response;

  @Resource
  private ServletContext context;

  // private static final String EDIT_PAGE =
  // "../../../../stx/kikaku/condition.jsp";
  private static final String EDIT_PAGE = "../../../../stx/test/test_i.htm";

  private static final String DISP_PAGE = "../../../../stx/test/test_r.htm";

  private static final String XSL_FILE = "D:\\wasaClipse\\workspace\\plaWasabiWeb\\src\\main\\webapp"
      + File.separator + "stx" + File.separator + "test" + File.separator + "test.xsl";

  private static final String DTD_FILE = "D:\\wasaClipse\\workspace\\plaWasabiWeb\\src\\main\\webapp"
      + File.separator + "stx" + File.separator + "test" + File.separator + "test.dtd";

  @Execute(validator = false, urlPattern = "edit")
  public String edit() throws IOException {

    // request.setAttribute("kikaku", kikaku);

    // if ("K".equals(kikaku.kika216)) {
    // request.setAttribute("confirm", true);
    // }

    FileInputStream[] xsls = null;
    request.setCharacterEncoding("UTF-8");
    OutputStream out = response.getOutputStream();
    try {
      // xslとdtdをセット
      xsls = new FileInputStream[] { new FileInputStream(XSL_FILE) };
      String[] dtds = new String[] { DTD_FILE };

      XmlExporterIF xe = new XmlExporter();

//      int rv[] = xe.exporter((HashMap) request.getParameterMap(), xsls, dtds,
//          new OutputStream[] { out });
//
//      if (rv[0] == 0) {
//        System.out.println("XML Exporter OK.");
//      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      try {
        if (xsls != null) {
          for (int i = 0; i < xsls.length; i++) {
            xsls[i].close();
          }
        }
        out.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }

    String s = "test";
    // return EDIT_PAGE;
    return null;
  }

  @Execute(validator = false, urlPattern = "disp")
  public String disp() {

    // request.setAttribute("kikaku", kikaku);
    // if (request.isUserInRole("ADMIN")) {
    // request.setAttribute("confirmable", true);
    // }
    // if ("K".equals(kikaku.kika216)) {
    // request.setAttribute("confirm", true);
    // }
    String s = "test";
    return DISP_PAGE;
  }

  @Execute(validator = false, urlPattern = "addrow")
  public String addrow() throws IOException {
    // if (true) return EDIT_PAGE;
    // 文字コードのセット

    request.setCharacterEncoding("MS932");

    FileInputStream html = null;
    OutputStream os = response.getOutputStream();
    try {
      /**
       * //サーバーから固定的に行操作を行う場合は、以下のようなキーと値およびpostされた値をHashMapにセットします // 行追姥pパラメータ
       * params.put("TABLE_ID","Table2");
       * params.put("TABLE_FUNCTION",HtmlTableAction.ROW_INSERT_AFTER);
       * params.put("BTN_NAME","TextField24_R_2"); params.put("COUNT","1");
       **/

      // ServletContext sc = this.servlet.getServletContext();

      String htmlfile = "D:\\wasaClipse\\workspace\\plaWasabiWeb\\src\\main\\webapp"
          + File.separator + "stx" + File.separator + "test" + File.separator + "test_i.htm";
      // テンプレートHTMLをセット
      html = new FileInputStream(htmlfile);

      // request.getParameterMap().put("TABLE_ID","Table1");
      // request.getParameterMap().put("TABLE_FUNCTION",HtmlTableAction.ROW_INSERT_AFTER);
      // request.getParameterMap().put("BTN_NAME","Button1");
      // request.getParameterMap().put("COUNT","10");

      System.out.println(htmlfile);

      // APIを呼ｄ双し
      HtmlTableActionIF ha = new HtmlTableAction();
      int rv = ha.tableAction((HashMap) request.getParameterMap(),
          HtmlTableActionIF.IMPORT_FOR_INPUT, html, os);

      if (rv == 0) {
        System.out.println("HtmlTableAction OK.");
      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (html != null)
        try {
          html.close();
        } catch (IOException e) {
          e.printStackTrace();
        }

      if (null != os) {
        os.close();
        os = null;
      }
    }
    return null;
  }

  public JdbcManager jdbcManager;

  @Execute(validator = false)
  public String index() {

    Map<Object, String> param = new HashMap<Object, String>();
    param.put("KIKA311", "1");
    // param.put("KIKA110", "2");
    // param.put("KIKA206", "3");
    // param.put("KIKA109", "4");

    // param.put("KIKA311", null);
    // param.put("kika112", "112");
    int count = jdbcManager.updateBySqlFile("config/query/kikaku_test.sql", param).execute();

    // return PAGE;
    return EDIT_PAGE;

  }

}
