class ObjectListClass{
private:
	int num;  // Total number of objects
	int next; // The next object to be fetched
	IDispatch** buff;
public:
	ObjectListClass();
	~ObjectListClass();
	IDispatch* fetch();
	void reset();
	void RegisterObject(IDispatch* obj);
	void UnregisterObject(IDispatch* obj);
};

class TempMemory{
private:
	int num; // Total number
	void** buff;
public:
	TempMemory();
	~TempMemory();
	void Discard(void* data);
	int* TempIntArray(int arraylen);
	LPSTR TempANSI(int strlen);
	LPWSTR TempUNI(int strlen);
	LPSTR TempANSI(LPSTR str);
	LPWSTR TempUNI(LPWSTR str);
	LPSTR TempANSI(LPWSTR str);
	LPWSTR TempUNI(LPSTR str);
	LPSTR TempANSI(LPSTR str1, LPSTR str2);
	LPWSTR TempUNI(LPWSTR str1, LPWSTR str2);
	LPSTR TempANSI(VARIANTARG* rgvarg);
	VARIANTARG* TempRgvarg();
	VARIANTARG* TempRgvarg(VARIANTARG* rgvarg);
};


class COMDATA
{
  //This class is used for storing the data of each COM object.
private:
	TempMemory strdata;      // Temporary memory space used for storing string data.
	IDispatch* pComClass; // Keeps the pointer to parent COMDATA object.
	int StructureType;
	void* StructureAddress;
	bool ImportedStructure; // The flag to show if the structure has came from SDL.dll
	DWORD GetOrSetStructureValue(bool mode, LPWSTR name, VARIANTARG* rgvarg, int key, int sType, void* pSA);
	HINSTANCE hDLL;
	bool UseUnicodeForDynaCall; // The flag to use unicode in xxx.dll
public:
	COMDATA(IDispatch* obj);
	~COMDATA();
	IDispatch* pIDispatch();
	LPWSTR FuncPrefix; // L"SDL_", L"TTF_" etc.
	LPWSTR MethodName; // This does not cotain above prefix.
	LPWSTR CopySTR(LPWSTR str); // To keep a unicode string as data.
	LPWSTR CopySTR(VARIANTARG* rgvarg);
	void DeleteSTR(LPWSTR str); // To delete the kept string data.
	void* SetStructure(int what, void* pStructure=NULL);
	void* pStructure(); // Returns the pointer to structure.
	DWORD SetStructureValue(LPWSTR name, VARIANTARG* rgvarg, int key);
	DWORD GetStructureValue(LPWSTR name, VARIANTARG* rgvarg, int key);
	DWORD LoadDLL(LPWSTR filename, LPWSTR prefix, bool useUnicode);
	DWORD DynaCall(LPWSTR funcname, VARIANTARG* rgvarg, int cArgs, int *eax=NULL, int *edx=NULL);
	DWORD DynaCall(LPWSTR funcname, int cArgs, int* Stack, int *eax=NULL, int *edx=NULL);
	int edx;
};
