#include "suppon.h"

IDispatch* CreateObject(LPWSTR file, LPWSTR clsidstr){
	GUID clsid;
	if (NOERROR!=CLSIDFromString(clsidstr,&clsid)) return NULL;
	return CreateObject(file,&clsid);
}


IDispatch* CreateObject(LPWSTR file, const GUID* clsid){
	// General variables
	int i;

	// Load DLL & check DllGetClassObject
	HINSTANCE hDLL;
	void* Address;
	if (!(hDLL=LoadLibraryW(file))) return 0;
	if (!(Address=GetProcAddress(hDLL,"DllGetClassObject"))) return 0;

	// DllGetClassObject(&clsid,IID_IClassFactory,(LPVOID*)&ppv);
	IClassFactory* ppv=0;
	void *Stack1,*Stack2,*Stack3;
	Stack3=&ppv;
	Stack2=(void*)&IID_IClassFactory;
	Stack1=(void*)clsid;
	_asm push Stack3;
	_asm push Stack2;
	_asm push Stack1;
	_asm call Address;
	_asm mov i,eax;
	if (i!=S_OK || !ppv) return 0;

	// Class factory was succesfully obteined.
	// Lets get the object.

	IDispatch* ppvObject=0;
	if (S_OK!=ppv->QueryInterface(IID_IClassFactory, (void**) &ppv)) return 0;
	ppv->Release();
	if (S_OK!=ppv->CreateInstance(NULL,IID_IUnknown,(void**)&ppvObject)) return 0;
	ppv->Release();
	if (!ppvObject) return 0;
	if (S_OK!=ppvObject->QueryInterface(IID_IDispatch,(void**)&ppvObject)) return 0;
	ppvObject->Release();

	return ppvObject;
}
