#include "comserver.h"
#include "include\SDL.h"
#include "include\SDL_syswm.h"
#include <wchar.h>
#include <direct.h>

// Enum
typedef enum {
	Struct_NULL=0,
	Struct_SDL_AudioSpec,
	Struct_SDL_AudioCVT,
	Struct_SDL_CDtrack,
	Struct_SDL_CD,
	Struct_SDL_ActiveEvent,
	Struct_SDL_KeyboardEvent,
	Struct_SDL_MouseMotionEvent,
	Struct_SDL_MouseButtonEvent,
	Struct_SDL_JoyAxisEvent,
	Struct_SDL_JoyBallEvent,
	Struct_SDL_JoyHatEvent,
	Struct_SDL_JoyButtonEvent,
	Struct_SDL_ResizeEvent,
	Struct_SDL_ExposeEvent,
	Struct_SDL_QuitEvent,
	Struct_SDL_UserEvent,
	Struct_SDL_SysWMEvent,
	Struct_SDL_keysym,
	Struct_SDL_Cursor,
	Struct_SDL_RWops,
	Struct_Uint64,
	Struct_Sint64,
	Struct_SDL_SysWMinfo,
	Struct_SDL_SysWMmsg,
	Struct_SDL_version,
	Struct_SDL_Rect,
	Struct_SDL_Color,
	Struct_SDL_Palette,
	Struct_SDL_PixelFormat,
	Struct_SDL_Surface,
	Struct_SDL_VideoInfo,
	Struct_SDL_Overlay,
	Struct_SDL_Event,
	Struct_SDL_Joystick,
	Struct_Mix_Chunk,
} STRUCTURE_TYPE;


//object.cpp
ObjectListClass* ObjectList();
IDispatch* NewComObjcet();
IDispatch* NewStructureObject(STRUCTURE_TYPE what, void* pStructure=NULL);

//comserver.cpp
COMDATA* GetDataFromComClass(IDispatch* pDisp);
LPSTR ModulePath();
LPSTR ModuleDir();

//structure.cpp
STRUCTURE_TYPE ResolveStructureTypeFromName(LPWSTR name);
bool ConverToStructureObjectOrString(LPWSTR funcName, void* pStruct, VARIANT* pVarResult);

//data.cpp
LPWSTR ResolveSTR(VARIANTARG* rgvarg);
int Redim(void*** buffer,int* num);
void Discard(void** buffer,int num,int *total);
int CopyINT(VARIANTARG* rgvarg);
double CopyDBL(VARIANTARG* rgvarg);

//dynacall.cpp
DWORD CallSDL(LPWSTR funcname, VARIANTARG* rgvarg, int cArgs, int *eax=NULL, int *edx=NULL);
int CallSDL(LPWSTR funcname, int cArgs, int* Stack);
int CallSDL(LPWSTR funcname);
int CallSDL(LPWSTR funcname, int p1);
int CallSDL(LPWSTR funcname, int p1, int p2);
int CallSDL(LPWSTR funcname, int p1, int p2, int p3);
int CallSDL(LPWSTR funcname, int p1, int p2, int p3, int p4);
int CallSDL(LPWSTR funcname, int p1, int p2, int p3, int p4, int p5);
HWND GetHWND();

//constants.cpp
BSTR ConstScript(char* header, char* footer, char* prefix, char* postfix);

