import styled from 'styled-components';

const WindowButton = styled.div`
  width: 45px;
  height: 100%;
  min-width: 45px;
  margin-right: 1px;
  position: relative;
  display: flex;
  -webkit-box-align: center;
  align-items: center;
  -webkit-box-pack: center;
  justify-content: center;
  transition: 0.2s background-color;
  box-sizing: border-box;
  -webkit-app-region: no-drag;
  &:first-child {
    margin-right: 0;
  }
  &:hover {
    background-color: ${props => props.isClose ? '#e81123' : 'rgba(196, 196, 196, 0.4)'};
  }
`;

export default WindowButton;