const builder = require('electron-builder');
const fs = require('fs');
const packageJson = JSON.parse(fs.readFileSync('./app/package.json', 'utf8'));

builder.build({
    platform: 'mac',
    config: {
        'appId': `org.aoichaan0513.${packageJson.name}`,
        'productName': packageJson.name,
        'copyright': `Copyright 2019 ${packageJson.author.name}. All rights reserved.`,
        'asar': true,
        'fileAssociations': [
            {
                'name': 'Document',
                'description': packageJson.name,
                'role': 'Viewer',
                'ext': 'html'
            }
        ],
        'mac': {
            'target': 'dmg',
            'icon': './static/icon.png',
        },
    },
});