import styled from 'styled-components';

const ToolbarButton = styled.div`
  background-color: initial;
  border: none;
  border-radius: 2px;
  width: 30px;
  height: 30px;
  margin: 5px;
  margin-left: ${props => props.isMarginLeft ? '5px' : '0px'};
  padding: 3px;
  display: ${props => props.isShowing ? 'display' : 'none'};
  background-image: url(${props => props.src});
  background-size: ${props => props.size};
  background-position: center;
  background-repeat: no-repeat;
  transition: 0.2s background-color;
  box-sizing: border-box;
  float: ${props => props.isRight ? 'right' : 'left'};
  &:hover {
    ${props => props.isEnabled && `background-color: ${!props.isDarkModeOrPrivateMode ? 'rgba(0, 0, 0, 0.06)' : 'rgba(130, 130, 130, 0.3)'};`}
  }
`;

export default ToolbarButton;