import React, { Component } from 'react';

import PropTypes from 'prop-types';
import { makeStyles, useTheme, createMuiTheme } from '@material-ui/core/styles';
import { ThemeProvider } from '@material-ui/styles';

import AppBar from '@material-ui/core/AppBar';
import CssBaseline from '@material-ui/core/CssBaseline';
import Divider from '@material-ui/core/Divider';
import Drawer from '@material-ui/core/Drawer';
import Hidden from '@material-ui/core/Hidden';
import IconButton from '@material-ui/core/IconButton';
import List from '@material-ui/core/List';
import ListItem from '@material-ui/core/ListItem';
import ListItemIcon from '@material-ui/core/ListItemIcon';
import ListItemText from '@material-ui/core/ListItemText';
import Collapse from '@material-ui/core/Collapse';
import Toolbar from '@material-ui/core/Toolbar';
import Typography from '@material-ui/core/Typography';

import PublicIcon from '@material-ui/icons/PublicOutlined';

import HomeIcon from '@material-ui/icons/HomeOutlined';
import HistoryIcon from '@material-ui/icons/HistoryOutlined';
import DownloadsIcon from '@material-ui/icons/GetAppOutlined';
import BookmarksIcon from '@material-ui/icons/BookmarksOutlined';
import AppsIcon from '@material-ui/icons/AppsOutlined';
import ShopIcon from '@material-ui/icons/ShopOutlined';
import SettingsIcon from '@material-ui/icons/SettingsOutlined';
import HelpIcon from '@material-ui/icons/HelpOutlineOutlined';
import InfoIcon from '@material-ui/icons/InfoOutlined';

import ExpandLessIcon from '@material-ui/icons/ExpandLess';
import ExpandMoreIcon from '@material-ui/icons/ExpandMore';
import MailIcon from '@material-ui/icons/Mail';
import MenuIcon from '@material-ui/icons/Menu';

const lightTheme = createMuiTheme({
    palette: {
        type: 'light'
    },
});
const darkTheme = createMuiTheme({
    palette: {
        type: 'dark'
    },
});

const drawerWidth = 240;

const useStyles = makeStyles(theme => ({
    root: {
        display: 'flex',
    },
    drawer: {
        [theme.breakpoints.up('sm')]: {
            width: drawerWidth,
            flexShrink: 0,
        },
    },
    appBar: {
        marginLeft: drawerWidth,
        [theme.breakpoints.up('sm')]: {
            width: `calc(100% - ${drawerWidth}px)`,
        },
    },
    menuButton: {
        marginRight: theme.spacing(2),
        [theme.breakpoints.up('sm')]: {
            display: 'none',
        },
    },
    toolbar: theme.mixins.toolbar,
    drawerPaper: {
        width: drawerWidth,
    },
    nested: {
        paddingLeft: theme.spacing(4),
    },
    link: {
        color: 'inherit',
        textDecoration: 'none'
    },
    content: {
        width: `calc(100% - ${drawerWidth}px)`,
        flexGrow: 1,
        padding: theme.spacing(3),
    },
}));

function NavigationBar(props) {
    const { container } = props;
    const classes = useStyles();

    const [open, setOpen] = React.useState(false);
    const [mobileOpen, setMobileOpen] = React.useState(false);

    function handleNestedListClick() {
        setOpen(!open);
    }

    function handleDrawerToggle() {
        setMobileOpen(!mobileOpen);
    }

    const drawer = (
        <ThemeProvider theme={window.getDarkTheme() ? darkTheme : lightTheme}>
            <List>
                <ListItem>
                    <ListItemIcon><PublicIcon /></ListItemIcon>
                    <ListItemText primary="Flast" />
                </ListItem>
            </List>
            <Divider />
            <List>
                <a className={classes.link} href="flast://home">
                    <ListItem button>
                        <ListItemIcon><HomeIcon /></ListItemIcon>
                        <ListItemText primary="ホーム" />
                    </ListItem>
                </a>
            </List>
            <Divider />
            <List>
                <a className={classes.link} href="flast://history">
                    <ListItem button>
                        <ListItemIcon><HistoryIcon /></ListItemIcon>
                        <ListItemText primary="履歴" />
                    </ListItem>
                </a>
                <a className={classes.link} href="flast://downloads">
                    <ListItem button>
                        <ListItemIcon><DownloadsIcon /></ListItemIcon>
                        <ListItemText primary="ダウンロード" />
                    </ListItem>
                </a>
                <a className={classes.link} href="flast://bookmarks">
                    <ListItem button>
                        <ListItemIcon><BookmarksIcon /></ListItemIcon>
                        <ListItemText primary="ブックマーク" />
                    </ListItem>
                </a>
            </List>
            <Divider />
            <List>
                <a className={classes.link} href="flast://apps">
                    <ListItem button>
                        <ListItemIcon><AppsIcon /></ListItemIcon>
                        <ListItemText primary="アプリ" />
                    </ListItem>
                </a>
                <a className={classes.link} href="">
                    <ListItem button>
                        <ListItemIcon><ShopIcon /></ListItemIcon>
                        <ListItemText primary="Flast Store" />
                    </ListItem>
                </a>
            </List>
            <Divider />
            <List>
                <ListItem button onClick={handleNestedListClick}>
                    <ListItemIcon><SettingsIcon /></ListItemIcon>
                    <ListItemText primary="設定" />
                    {open ? <ExpandLessIcon /> : <ExpandMoreIcon />}
                </ListItem>
                <Collapse in={open} timeout="auto" unmountOnExit>
                    <List component="div" disablePadding dense>
                        <a className={classes.link} href="flast://settings">
                            <ListItem button className={classes.nested}>
                                <ListItemText primary="ホーム" />
                            </ListItem>
                        </a>
                    </List>
                </Collapse>
                <a className={classes.link} href="flast://help">
                    <ListItem button>
                        <ListItemIcon><HelpIcon /></ListItemIcon>
                        <ListItemText primary="ヘルプ" />
                    </ListItem>
                </a>
            </List>
            <Divider />
            <List>
                <a className={classes.link} href="flast://settings#about">
                    <ListItem button>
                        <ListItemIcon><InfoIcon /></ListItemIcon>
                        <ListItemText primary={`${window.getAppName()} について`} />
                    </ListItem>
                </a>
            </List>
        </ThemeProvider>
    );

    return (
        <ThemeProvider theme={window.getDarkTheme() ? darkTheme : lightTheme}>
            <div className={classes.root}>
                <CssBaseline />
                <AppBar position="fixed" className={classes.appBar}>
                    <Toolbar>
                        <IconButton
                            color="inherit"
                            aria-label="Open drawer"
                            edge="start"
                            onClick={handleDrawerToggle}
                            className={classes.menuButton}
                        >
                            <MenuIcon />
                        </IconButton>
                        <Typography variant="h6" noWrap>{props.title}</Typography>
                    </Toolbar>
                </AppBar>
                <nav className={classes.drawer}>
                    <Hidden smUp implementation="css">
                        <Drawer
                            container={container}
                            variant="temporary"
                            open={mobileOpen}
                            onClose={handleDrawerToggle}
                            classes={{ paper: classes.drawerPaper }}
                            ModalProps={{ keepMounted: true }}
                        >
                            {drawer}
                        </Drawer>
                    </Hidden>
                    <Hidden xsDown implementation="css">
                        <Drawer
                            classes={{ paper: classes.drawerPaper }}
                            variant="permanent"
                            open
                        >
                            {drawer}
                        </Drawer>
                    </Hidden>
                </nav>
                <main className={classes.content}>
                    <div className={classes.toolbar} />
                    <ThemeProvider theme={window.getDarkTheme() ? darkTheme : lightTheme}>
                        {props.children}
                    </ThemeProvider>
                </main>
            </div>
        </ThemeProvider>
    );
}

NavigationBar.propTypes = {
    container: PropTypes.object,
};

export default NavigationBar;