const { app, ipcMain, protocol, session, BrowserWindow, BrowserView, Menu, nativeImage, clipboard, dialog, Notification } = require('electron');
const path = require('path');
const fs = require('fs');
const url = require('url');
const os = require('os');

const WindowManager = require('./WindowManager');
const windowManager = new WindowManager();

let loginCallback;
let mainWindow;
let subWindow;

getBaseWindow = (width = 1100, height = 680, minWidth = 320, minHeight = 600, x, y, frame = false) => {
    return new BrowserWindow({
        width, height, minWidth, minHeight, x, y, 'titleBarStyle': 'hidden', frame, fullscreenable: true,
        webPreferences: {
            nodeIntegration: true,
            webviewTag: true,
            plugins: true,
            experimentalFeatures: true,
            contextIsolation: false,
        }
    });
}

registerProtocols = () => {
    protocol.registerFileProtocol('my', (request, callback) => {
        const parsed = url.parse(request.url);

        if (parsed.hostname.endsWith('.css') || parsed.hostname.endsWith('.js')) {
            return callback({
                path: path.join(app.getAppPath(), 'pages', parsed.hostname),
            });
        } else {
            return callback({
                path: path.join(app.getAppPath(), 'pages', `${parsed.hostname}.html`),
            });
        }
    }, (error) => {
        if (error) console.error('Failed to register protocol: ' + error);
    });
}

module.exports = class Application {
    loadWindow = () => {
        protocol.registerSchemesAsPrivileged([
            { scheme: 'my', privileges: { standard: true, bypassCSP: true, secure: true } }
        ]);

        app.on('ready', () => {
            // registerProtocols();
            
            Menu.setApplicationMenu(null);

            windowManager.addWindow();
        });

        app.on('window-all-closed', () => {
            if (process.platform !== 'darwin') {
                app.quit();
            }
        });

        app.on('activate', () => {
        });

        app.on('login', (e, webContents, request, authInfo, callback) => {
            e.preventDefault();

            subWindow = getBaseWindow(320, 230, 320, 230);
            // subWindow.setParentWindow(mainWindow);
            subWindow.setMovable(false);
            subWindow.setResizable(false);
            subWindow.setMinimizable(false);
            subWindow.setMaximizable(false);
            const startUrl = process.env.ELECTRON_START_URL || url.format({
                pathname: path.join(__dirname, '/../build/index.html'), // 警告：このファイルを移動する場合ここの相対パスの指定に注意してください
                protocol: 'file:',
                slashes: true,
                hash: '/authentication',
            });

            subWindow.loadURL(startUrl);
            loginCallback = callback;
        });

        ipcMain.on('authorization', (event, arg) => {
            loginCallback(arg.username, arg.password);
            subWindow.close();
        });
    }

    loadExtension = (id) => {
        const extensionDir = path.resolve(os.homedir(), 'AppData\\Local\\Google\\Chrome\\User Data\\Default\\Extensions');

        const versions = fs.readdirSync(`${extensionDir}/${id}`).sort();
        const version = versions.pop();

        BrowserWindow.addExtension(`${extensionDir}/${id}/${version}`);
    }
};