/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for Table
 */
public class Table extends SennaObject {
    /**
     * call sen_table_create().
     *
     * @param ctx SennaContext
     * @param name name
     * @param path path
     * @param flags flasgs
     * @param encoding encoding
     */
    public static native Type create(SennaContext ctx, String name, String path,
				     int flags, Type key_type, int encoding)
	throws SennaException;

    /* for open() */
    private Table() {
    }

    /**
     * call sen_table_open().
     *
     * @param ctx SennaContext
     * @param name name
     * @param path path
     * @return opened table
     * @throws SennaException
     */
    private native Table open(SennaContext ctx, String name, String path) throws SennaException;

    /**
     * creates new object with sen_table_open().
     *
     * @param ctx SennaContext
     * @param name name
     * @param path path
     * @throws SennaException
     */
    public Table(SennaContext ctx, String name, String path) throws SennaException {
	open(ctx, name, path);
    }

    /**
     * call sen_table_lookup().
     *
     * @param key key
     * @param flags flags
     * @return matched record's sen_id
     * @throws SennaException
     */
    public native int lookup(String key, int flags) throws SennaException;

    /**
     * call sen_table_add().
     *
     * @return created record's sen_id
     * @throws SennaException
     */
    public native int add() throws SennaException;

    /**
     * call sen_table_get_key().
     *
     * @param sen_id sen_id
     * @return key
     * @throws SennaException
     */
    public native String getKey(int sen_id) throws SennaException;

    /**
     * call sen_table_delete().
     *
     * @param key key
     * @throws SennaException
     */
    public native void delete(String key) throws SennaException;

    /**
     * call sen_table_delete_by_id().
     *
     * @param sen_id sen_id
     * @throws SennaException
     */
    public native void deleteByID(int sen_id) throws SennaException;

    /**
     * call sen_table_truncate().
     *
     * @throws SennaException
     */
    public native void truncate() throws SennaException;

    /**
     * call sen_table_sort().
     *
     * @param limit
     * @param option
     * @return result
     * @throws SennaException
     */
    public native Table sort(int limit, int option) throws SennaException;

    /**
     * call sen_table_group().
     *
     * @param keys
     * @return result
     * @throws SennaException
     */
    public native Table group(String keys[]) throws SennaException;

    /**
     * call sen_table_setoperation().
     *
     * @param table
     * @param operation
     * @return result
     * @throws SennaException
     */
    public native Table setoperation(Table table, int operation) throws SennaException;

    /**
     * call sen_table_difference().
     *
     * @param table
     * @return array size is 2. 1st object is from this table, 2nd object is from param.
     * @throws SennaException
     */
    public native Table[] difference(Table table) throws SennaException;

    /**
     * call sen_table_column().
     *
     * @param name
     * @return matched column
     * @throws SennaException
     */
    public native Column getColumn(String name) throws SennaException;

    /**
     * call sen_table_size().
     *
     * @return number of record in this table
     * @throws SennaException
     */
    public native int size() throws SennaException;
}
