/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for Space
 */
public class Space extends SennaObject {
    /**
     * call sen_space_create().
     *
     * @param ctx
     *            SenaContext
     * @param path
     *            path
     * @return created space
     * @throws SennaException
     */
    public static native Space create(SennaContext ctx, String path) throws SennaException;

    /**
     * call sen_space_create().
     *
     * @param ctx
     *            SennaContext
     * @param path
     *            path
     * @param encoding
     *            default encoding for this space
     * @return created space
     * @throws SennaException
     */
    public static native Space create(SennaContext ctx, String path, int encoding)
	throws SennaException;

    /* for create() */
    private Space() {
    }

    /**
     * call sen_space_open().
     *
     * @param ctx
     *            SennaContext
     * @param path
     *            path
     * @param encoding
     *            default encoding for this space
     * @return opened space
     * @throws SennaException
     */
    private native Space open(SennaContext ctx, String path, int encoding)
	throws SennaException;

    /**
     * creates new object with sen_space_open().
     *
     * @param ctx SennaContext
     * @param path path
     * @throws SennaException
     */
    public Space(SennaContext ctx, String path) throws SennaException {
	open(ctx, path, Senna.SEN_ENC_DEFAULT);
    }

    /**
     * creates new object with sen_space_open().
     *
     * @param ctx
     *            SennaContext
     * @param path
     *            path
     * @param encoding
     *            default encoding
     * @throws SennaException
     */
    public Space(SennaContext ctx, String path, int encoding) throws SennaException {
	open(ctx, path, encoding);
    }

}
