/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * SennaExcepion
 */
public class SennaException extends Exception {

    private static final long serialVersionUID = 4758313833334805879L;

    /**
     * Constructs a SennaException with the specified detail message.
     * 
     * @param message
     *            message
     */
    public SennaException(String message) {
        super(message);
    }

    /**
     * Constructs a SennaException with the specified detail message and sen_rc.
     * 
     * @param message
     *            message
     * @param rc
     *            sen_rc
     */
    public SennaException(String message, int rc) {
        this(message + "\n" + "error code: " + rc + "\n");
    }
}
