/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for Cursor
 */
public class Cursor {
    /**
     * call sent_table_cursor_open().
     *
     * @param table table
     * @param min minimum value of key condition
     * @param max maximum value of key condition
     * @return opened cursor
     * @throws SennaException
     */
    private native Cursor open(Table table, String min, String max) throws SennaException;

    /**
     * create new object with sen_table_cursor_open().
     *
     * @param table table
     * @param min minimum value of key condition
     * @param max maximum value of key condition
     * @throws SennaException
     */
    public Cursor(Table table, String min, String max) throws SennaException {
	open(table, min, max);
    }

    /**
     * call sen_table_cursor_close().
     *
     * @throws SennaException
     */
    public native void close() throws SennaException;

    /**
     * call sen_table_cursor_next().
     *
     * @return sen_id
     * @throws SennaException
     */
    public native int next() throws SennaException;

    /**
     * call sen_table_cursor_get_key().
     *
     * @return key
     * @throws SennaException
     */
    public native String getKey() throws SennaException;

    /**
     * call sen_table_cursor_get_value().
     *
     * @return value
     * @throws SennaException
     */
    public native String getValue() throws SennaException;

    /**
     * call sen_table_cursor_set_value().
     *
     * @param value
     * @param type
     * @throws SennaException
     */
    public native void setValue(String value, int type) throws SennaException;

    /**
     * call sen_table_cursor_delete().
     *
     * @throws SennaException
     */
    public native void delete() throws SennaException;
}
