#import "TimeZone.h"
#import"Option.h"
#import "OTPViewController.h"

@implementation TimeZone
- (void)viewDidLoad
{
	self.title = @"タイムゾーン設定";
	[super viewDidLoad];
	/*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"戻る" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;
    [cancelButtonItem release];*/
	arrayNo = [[NSMutableArray alloc] init];
	
	[arrayNo addObject:@"東京"];
	[arrayNo addObject:@"エニウェトク、クエジェリン"];
	[arrayNo addObject:@"ミッドウェー島、サモア"];
	[arrayNo addObject:@"ハワイ"];
	[arrayNo addObject:@"アラスカ"];
	[arrayNo addObject:@"太平洋標準時（米国、カナダ）、ティファナ"];
	[arrayNo addObject:@"アリゾナ"];
	[arrayNo addObject:@"山地標準時（米国、カナダ）"];
	[arrayNo addObject:@"サスカチュワン"];
	[arrayNo addObject:@"メキシコシティ"];
	[arrayNo addObject:@"中央アメリカ "];
	[arrayNo addObject:@"中部標準時（米国、カナダ)"];
	[arrayNo addObject:@"インディアナ東部"];
	[arrayNo addObject:@"ボゴタ、リマ、キト"];
	[arrayNo addObject:@"東部標準時（米国、カナダ）"];
	[arrayNo addObject:@"カラカス、ラパス"];
	[arrayNo addObject:@"サンティアゴ"];
	[arrayNo addObject:@"大西洋標準時 (カナダ)"];
	[arrayNo addObject:@"ニューファンドランド"];
	[arrayNo addObject:@"グリーンランド"];
	[arrayNo addObject:@"ブエノスアイレス、ジョージタウン"];
	[arrayNo addObject:@"ブラジリア"];
	[arrayNo addObject:@"中央大西洋"];
	[arrayNo addObject:@"アゾレス諸島"];
	[arrayNo addObject:@"ガーボベルデ諸島"];
	[arrayNo addObject:@"カサブランカ、モンロビア"];
	[arrayNo addObject:@"グリニッジ,ダブリン、エジンバラ、リスボン、ロンドン"];
	
	[arrayNo addObject:@"アムステルダム、ベルリン、ベルン、ローマ、ストックホルム"];
	[arrayNo addObject:@"サラエボ、スコピエ、ソフィア、ビリニュス、ワルシャワ、ザグレブ"];
	[arrayNo addObject:@"ブリュッセル、マドリード、コペンハーゲン、パリ"];
	[arrayNo addObject:@"ベオグラード、プラチスラバ、ブダペスト、リュブリャナ、プラハ"];
	[arrayNo addObject:@"西中央アフリカ"];
	[arrayNo addObject:@"アテネ、イスタンブール、ミンスク"];
	[arrayNo addObject:@"エルサレム"];
	[arrayNo addObject:@"カイロ"];
	[arrayNo addObject:@"ハラーレ、プレトリア"];
	[arrayNo addObject:@"ブカレスト"];
	[arrayNo addObject:@"ヘルシンキ、リガ、タリン	"];
	[arrayNo addObject:@"クウェート、リヤド	"];
	[arrayNo addObject:@"ナイロビ	"];
	[arrayNo addObject:@"バクダット"];	
	[arrayNo addObject:@"モスクワ、ボルゴグラード、サンクトペテルブルグ"];	
	[arrayNo addObject:@"テヘラン	"];	
	[arrayNo addObject:@"アブダビ、マスカット"];	
	[arrayNo addObject:@"バグ、トビリシ、エレバン	"];	
	[arrayNo addObject:@"カブール	"];	
	[arrayNo addObject:@"イスラマバード、カラチ、タシケント	"];	
	[arrayNo addObject:@"エカテリンバーグ"];	
	[arrayNo addObject:@"カルカッタ、チェンナイ、ムンバイ、ニューデリー"];	
	[arrayNo addObject:@"カトマンズ"];	
	[arrayNo addObject:@"アスタナ、ダッカ"];	
	[arrayNo addObject:@"アルマティ、ノボシビルスク"];	
	[arrayNo addObject:@"スリ、ジャヤワルダナプラ	"];	
	[arrayNo addObject:@"ラングール"];	
	[arrayNo addObject:@"クラスノヤルスク"];	
	[arrayNo addObject:@"バンコク、ハノイ、ジャカルタ"];	
	[arrayNo addObject:@"イルクーツク、ウランバートル"];	
	[arrayNo addObject:@"クアラルンプール、シンガポール"];	
	[arrayNo addObject:@"パース"];	
	[arrayNo addObject:@"台北"];	
	[arrayNo addObject:@"北京、重慶、香港、ウルムチ"];	
	[arrayNo addObject:@"ソウル"];	
	[arrayNo addObject:@"ヤクーツク"];
	[arrayNo addObject:@"日本"];
	//[arrayNo addObject:@"大阪、札幌、東京"];	
	[arrayNo addObject:@"アデレード"];	
	[arrayNo addObject:@"ダーウィン"];	
	[arrayNo addObject:@"ウラジオストク"];	
	[arrayNo addObject:@"キャンベラ、メルボルン、シドニー"];	
	[arrayNo addObject:@"グアム、ポートモレスビー	"];	
	[arrayNo addObject:@"ブリスベン"];	
	[arrayNo addObject:@"ホバート	"];	
	[arrayNo addObject:@"マガダン、ソロモン諸島、ニューカレドニア"];	
	[arrayNo addObject:@"オークランド、ウェリントン"];	
	[arrayNo addObject:@"フィジー、カムチャッカ、マーシャル諸島"];	
	[arrayNo addObject:@"ヌクアロファ"];
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	
	if([defaults boolForKey:@"BTimeZoneSelect"]){
		NSInteger defaultState = [defaults integerForKey:@"CompState"];
		indexRow = defaultState;
	}else {
		indexRow = 63;
	}

	[pickerView selectRow:indexRow  inComponent:0 animated:YES];
	pickLine = [self utc: indexRow];
	int pickLine1 = (pickLine*100)/100;
	int pickLine2 = pickLine*100-pickLine1*100;
	
	if (pickLine1>0) {
		if (pickLine2) {
			[mlabel setText:[NSString stringWithFormat:@"+%d:%2.0f",pickLine1,pickLine2 * 0.6]];
		}else {
			[mlabel setText:[NSString stringWithFormat:@"+%d",pickLine1]];
		}
	}else {
		if (pickLine2) {
			[mlabel setText:[NSString stringWithFormat:@"%d:%2.0f",pickLine1,-(pickLine2 * 0.6)]];
		}else {
			[mlabel setText:[NSString stringWithFormat:@"%d",pickLine1]];
		}
	}
	
	[lable setText:[NSString stringWithFormat:@"%8.0f",[[NSDate date] timeIntervalSince1970]/60 +pickLine * 60]];

}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView;
{
	return 1;
}

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
	//***************タイマー処理**********//
	NSInteger secondsLeft = 10;
    endAt = [[NSDate dateWithTimeIntervalSinceNow:secondsLeft] retain];    
    timer = [[NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(timerFired:) userInfo:nil repeats:YES] retain];
    [self timerFired: timer];
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component;
{
	return [arrayNo count];
	
}

- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component;
{
	return [arrayNo objectAtIndex:row];
}

-(IBAction)ButtonSetUp{
	BOOL BTimeZoneSelected = TRUE;
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	NSInteger lastState = [pickerView selectedRowInComponent:0];
	[defaults setInteger:lastState forKey:@"CompState"];
	[defaults setBool:BTimeZoneSelected forKey: @"BTimeZoneSelect"];
	 
	NSInteger defaultState = [defaults integerForKey:@"CompState"];
	pickLine = [self utc: defaultState ];
	[defaults setInteger:pickLine forKey:@"TimeZone"];
	
	int pickLine1 = (pickLine*100)/100;
	int pickLine2 = pickLine*100-pickLine1*100;
	
	if (pickLine1>0) {
		if (pickLine2) {
			[mlabel setText:[NSString stringWithFormat:@"+%d:%2.0f",pickLine1,pickLine2 * 0.6]];
		}else {
			[mlabel setText:[NSString stringWithFormat:@"+%d",pickLine1]];
		}
	}else {
		if (pickLine2) {
			[mlabel setText:[NSString stringWithFormat:@"%d:%2.0f",pickLine1,-(pickLine2 * 0.6)]];
		}else {
			[mlabel setText:[NSString stringWithFormat:@"%d",pickLine1]];
		}
	}
}
- (void) timerFired:(NSTimer *)theTimer
{
	[lable setText:[NSString stringWithFormat:@"%8.0f",[[NSDate date] timeIntervalSince1970]/60 + pickLine * 60 ]];
}

- (float) utc:(int ) pickerLine
{
	switch (pickerLine) {
		case 0:
			return +9;
			break;
		case 1:
			return -12;
			break;
		case 2:
			return -11;
			break;
		case 3:
			return -10;
			break;
		case 4:
			return -9;
			break;
		case 5:
			return -8;
			break;
		case 6:
		case 7:
			return -7;
			break;
		case 8:
		case 9:
		case 10:
		case 11:
			return -6;
			break;
		case 12:
		case 13:
		case 14:
			return -5;
			break;
		case 15:
		case 16:
		case 17:
			return -4;
			break;
		case 18:
			return -3.5;
			break;
		case 19:
		case 20:
		case 21:
			return -3;
			break;
		case 22:
			return -2;
			break;
		case 23:
		case 24:
			return -1;
			break;
		case 25:
		case 26:
			return 0;
			break;
		case 27:
		case 28:
		case 29:
		case 30:
		case 31:
			return 1;
			break;
		case 32:
		case 33:
		case 34:
		case 35:
		case 36:
		case 37:
			return 2;
			break;
		case 38:
		case 39:
		case 40:
		case 41:
			return 3;
			break;
		case 42:
			return 3.5;
			break;
		case 43:
		case 44:
			return 4;
			break;
		case 45:
			return 4.5;
			break;
		case 46:
		case 47:
			return 5;
			break;
		case 48:
			return 5.5;
			break;
		case 49:
			return 5.75;
			break;
		case 50:
		case 51:
		case 52:
			return 6;
			break;
		case 53:
			return 6.5;
			break;
		case 54:
		case 55:
			return 7;
			break;
		case 56:
		case 57:
		case 58:
		case 59:
		case 60:
			return 8;
			break;
		case 61:
		case 62:
		case 63:
			return 9;
			break;
		case 64:
		case 65:
			return 9.5;
			break;
		case 66:
		case 67:
		case 68:
		case 69:
		case 70:
			return 10;
			break;
		case 71:
			return 11;
			break;
		case 72:
		case 73:
			return 12;
			break;
		case 74:
			return 13;
			break;
		default:
			break;
	}
	return 0;
}
 
/*
-(void)viewWillDisappear:(BOOL)animated{                        
	
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	NSInteger lastState = [pickerView selectedRowInComponent:0];
	[defaults setInteger:lastState forKey:@"CompState"];
}*/
/*
// デフォルトでは一番上が選択されている(つまり上に空白が見える)ので
// 強制的に移動する。
- (void)viewDidLoad {
	[super viewDidLoad];
	
	//[pickerView selectRow:1 + 100 inComponent:0];// animated:NO];
	/// [pickerView selectRow:8 + 100 inComponent:1];// animated:NO];
	// [pickerView selectRow:0 + 100 inComponent:2];// animated:NO];
}


// 3列を指定
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView {
	return 1;
}

// component列目の行数を返します。今回は全component210行です(適当に決めた)
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
	return 5*(component+1);
}

// 0～9の全10種類にあわせて表示する文字列を返す。
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component {
	static NSString *numbers[] = { @"hanoi", @"haiphong", @"haiduong", @"namdinh", @"ninhbinh"};
	return numbers[row % 10];
}*/
/*
// pickerで行が選択された(回転が止まった)時に、真ん中辺に選択を移動させる。
// animated:NOでやればユーザーには変更されたことが見えない。
// 今回は100～109行目に強制的に移動

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component {
	[pickerView selectRow:row % 10 + 100 inComponent:component animated:NO];
}
*/


 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
		//BTimeZoneSelected = FALSE;
    }
    return self;
}



// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
/*- (void)viewDidLoad {
	self.title = @"Setup Timezone";
    [super viewDidLoad];
}*/


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}
/*- (void)back{
	OptionView *option = [[OptionView alloc] initWithNibName:@"OptionView" bundle:nil];
	[self.navigationController pushViewController:option animated:NO];
}
*/
/*- (void)back{
	Option *otpView = [[Option alloc] initWithNibName:@"Option" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}*/

@end
