//
//  OptionView.m
//  OTP
//
//  Created by DaoVanDien on 3/11/10.
//  Copyright 2010 __人財ソリューション__. All rights reserved.
//
#define DEBUG_BUILD

#ifdef DEBUG_BUILD
#define DEBUGLOG(x) x
#define LogMethod() NSLog(@"%@ %@", self, NSStringFromSelector(_cmd))
#else
#define DEBUGLOG(x)
#define LogMethod() 
#endif

#import "OptionView.h"
#import "TimeZone.h"
#import "SeciossOTP.h"
#import "UserData.h"
#import "OTPViewController.h"

@implementation OptionView
#pragma mark ControlEventTarget Actions
- (void)segmentAction:(UISegmentedControl*)sender
{
	
	if ([activeTextField canResignFirstResponder])
		[activeTextField resignFirstResponder];
	//
	DEBUGLOG(NSLog(@"segmentAction: sender = %d, segment = %d",  [sender tag], [sender selectedSegmentIndex]));
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	NSInteger segmentState = [sender selectedSegmentIndex];
	[defaults setInteger:segmentState forKey:@"SegState"];
}
- (void)viewDidLoad {
	self.title = @"オプション";
	arrayButton1 = [[NSArray alloc] initWithObjects:@"タイムゾーン設定",nil];
	arrayButton2 = [[NSArray alloc] initWithObjects:@"",nil];
	UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"戻る" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;
    [cancelButtonItem release];
    [super viewDidLoad];
}

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}
#pragma mark Table view methods

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	switch (section) {
		case 0:
			return [arrayButton1 count];
			break;
		case 1:
			return [arrayButton2 count];
			break;
		default:
			break;
	}
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {    
    static NSString *CellIdentifier = @"Cell";    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithFrame:CGRectZero reuseIdentifier:CellIdentifier] autorelease];
    }
	switch (indexPath.section) {
		case 0:
			cell.text = [arrayButton1 objectAtIndex:indexPath.row];
			break;
		case 1:
		{
			UISegmentedControl *difficultyControl = [ [ UISegmentedControl alloc ] initWithFrame: CGRectMake(158, 6, 150, 30) ];
			[difficultyControl insertSegmentWithTitle: @"スイング" atIndex: 0 animated: NO ];
			[difficultyControl insertSegmentWithTitle: @"文字表現" atIndex: 1 animated: NO ];
						
			NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
			NSInteger segState = [defaults integerForKey:@"SegState"];
			
			difficultyControl.selectedSegmentIndex = segState;
			difficultyControl.tag = 2;
			[difficultyControl addTarget:self action:@selector(segmentAction:) forControlEvents:UIControlEventValueChanged];
			[ cell addSubview: difficultyControl ];
			
			cell.text = @"シークレット方式";
			[difficultyControl release];
		}
			break;
		
		default:
			break;
	}
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	TimeZone *time = [[TimeZone alloc] initWithNibName:@"TimeZone" bundle:nil];
	switch (indexPath.section) {
			
		case 0:
			[self.navigationController pushViewController:time animated:YES];
			break;
		default:
			break;
	}
}

/*- (void)back{
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}*/
- (void)back{
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}

@end
