package SeciossOTP;

import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.security.SecureRandom;

import SeciossOTP.Base64;

import org.bouncycastle.crypto.InvalidCipherTextException;
import java.io.UnsupportedEncodingException;
 
public class AES_PBE_BC {
 
    //  Iteration count
    private static int iterationCount = 25;
    private PaddedBufferedBlockCipher cipher;
    private KeyParameter keyParam;
    private ParametersWithIV params;

    //  8-byte Salt
    private byte[] salt = new byte[8];
    private int saltset = 0;
    
 
    public AES_PBE_BC(char[] pass, byte[] newSalt) {
	if(newSalt.length >= 8)
	{
		saltset = 1;
		for(int i = 0; i < 8; i++)
			salt[i] = newSalt[i];
		System.out.println("Setting salt to: "+new String(salt));
	}

        try {
       	    init(pass);
        } catch (Exception e) {
       	    System.out.println("ERROR: " + e.getMessage());
       	}
    }

    public void setIV(byte[] iv)
    {
	params.iv = iv;
    }

    public byte[] getIV()
    {
	return params.iv;
    }

    public byte[] getKey()
    {
	return keyParam.getKey();
    }

    public void setKey(char[] pass)
    {
	byte[] tmpB = new byte[pass.length];

	for(int i = 0; i < pass.length; i++)
		tmpB[i] = (byte)pass[i];

	keyParam.setKey(tmpB);
    }

    public byte[] getSalt()
    {
	if(saltset == 0)
	{
	    System.out.println("Generating new salt.");
	    SecureRandom sr = new SecureRandom();

	    int j = 0;
	    for(int i = 0; i < 8; i++)
	    {
		do
		{
			j = sr.nextInt() * 4096;
			if(j < 0)
				j *= -1;
			j = j % 127;
		} while(j < 32 | j > 126);

		salt[i] = (byte)j;
	    }
	    saltset = 1;
	    System.out.println("New salt is: "+new String(salt));
	}

	return salt;
    }

    private void init(char[] pass) throws Exception {
        PBEParametersGenerator generator = new PKCS5S2ParametersGenerator();

	if(saltset == 0)
		getSalt();

        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes(pass), salt, iterationCount);
        params = (ParametersWithIV) generator.generateDerivedParameters(128, 128);

        keyParam = (KeyParameter) params.getParameters();
        cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESFastEngine()), new PKCS7Padding());
    }
    
    public String encrypt(String plainText) throws Exception {
        cipher.init(true, keyParam);
        byte[] plainTextBytes = plainText.getBytes("UTF8");
        byte[] cipherTextBytes = new byte[cipher.getOutputSize(plainTextBytes.length)];
       	int outputLen = cipher.processBytes(plainTextBytes, 0, plainTextBytes.length, cipherTextBytes, 0);

        cipher.doFinal(cipherTextBytes, outputLen);

	return new String(Base64.encode(cipherTextBytes));
    }
    
    public String decrypt(String cipherTextB64) throws Exception {
        cipher.init(false, keyParam);
        byte[] cipherTextBytes = Base64.decode(cipherTextB64);
        byte[] plainTextBytes = new byte[cipher.getOutputSize(cipherTextBytes.length)];
        int outputLen = cipher.processBytes(cipherTextBytes, 0, cipherTextBytes.length, plainTextBytes, 0);
        cipher.doFinal(plainTextBytes, outputLen);
        return new String(plainTextBytes, "UTF8");  
    }
}
