/*
 *
 * Mobile One Time Passwords (Mobile-OTP) for Java 2 Micro Edition, J2ME
 * (c) 2009 by SECIOSS OTP
 * (c) 2007 by the Free Auth Project - http://www.freeauth.org
 * written by Matthias Straub, Heilbronn, Germany, 2003
 * (c) 2003 by Matthias Straub
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * This program uses the MD5 library for java by Santeri Paavolainen
 * that was also released under the terms of the GPL
 *
 * This program uses the bouncy castle libraries for hashing and encryption
 * that was also released under the terms of the GPL
 *
 */

package SeciossOTP;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.bouncycastle.security.SecureRandom;

import SeciossOTP.MD5;

// OneTimePasswordAlgorithm
import org.openauthentication.otp.OneTimePasswordAlgorithm;
//

public class SeciossOTP extends MIDlet implements CommandListener
{
	private Command doNextCommand = new Command("", Command.SCREEN, 2);

	private Command checkForDefaultsNoCommand = new Command("", Command.SCREEN, 1);
	private Command checkForDefaultsYesCommand = new Command("͂", Command.SCREEN, 2);
	private Command newAliasDeleteCommand = new Command("폜", Command.SCREEN, 1);
	private Command newManSecDeleteCommand = new Command("폜", Command.SCREEN, 1);
	private Command ManualSecretCommand = new Command("V[Nbgœ", Command.SCREEN, 2);
	private Command aboutMainCommand = new Command("SeciossOTPɂ", Command.SCREEN, 2);
	private Command aboutMenuCommand = new Command("SeciossOTPɂ", Command.SCREEN, 3);
	private Command exitMainCommand = new Command("I", Command.SCREEN, 1);
	private Command exitMenuCommand = new Command("I", Command.SCREEN, 3);
	private Command backCommand = new Command("߂", Command.BACK, 1);
	private Command cancelCommand = new Command("߂", Command.BACK, 1);
        private Command tzsaveCommand = new Command("ۑ", Command.BACK, 2);
	private Command timezoneCommand = new Command ("^C][ݒ", Command.SCREEN, 2);
	private Command newPassCodeCommand = new Command ("VpX[h", Command.SCREEN, 2);
	private Command mainMenuCommand = new Command ("Cj[", Command.SCREEN, 1);
	private Command resetSecretCommand = new Command("V[NbgZbg", Command.SCREEN, 3);
	private Command deleteSecretCommand = new Command("V[Nbg폜", Command.SCREEN, 3);
	private Command wipeCommand = new Command("DB폜", Command.SCREEN, 3);
	private Command selectSecretCommand = new Command("I", Command.SCREEN, 2);
	private Command uploadAlert = new Command("OK", Command.ITEM, 1);

	private String currentAction = "";
	private String nextAction = "";
	private String seed = "";
	private String secret = "";
	private String initdate = "";
	private String PIN = "";
	private String pindis = "";
	private String alias = "";
	private String newalias = "";
	private String search = "";
	private int manualsecret = 0;
	private RecordStore meta = null;
	private RecordStore rs = null;
        private int totalRecords = 0;
        private int currentRecord = -1;
	private int timez = 12;
	private int firstRun = 0;
	private String usenetwork = "Y";
	private String epoch;
	private Calendar cnow;
	private Date now = new Date();
	private long lastpress = 0;
	private long thispress = 0;
	private long serverts = 0;
	private long serverepoch = 0;
	private long aliasmode = 0;
	private char lastkey;
	private AES_PBE_BC secretdecode;
	private String tmpbuf = "";
	protected Timer timer;
	protected TimerTask updateTask;
	private Canvas lowinput = null;

	private String UserAgent = new String(getAppProperty("MIDlet-Name"))+" version "+new String(getAppProperty("MIDlet-Version"));
	
	// OneTimePasswordAlgorithm
	private long movingFactor;
	private int codeDigits = 8;
	private boolean addChecksum = false;
	private int truncationOffset = -1;
	private String secretPIN;
	//

	private Font defFont = Font.getFont(Font.FACE_MONOSPACE, Font.STYLE_PLAIN, Font.SIZE_MEDIUM);

        public void pauseApp()
        {
        }
        
        public void destroyApp(boolean unconditional)
        {
		System.out.println("Closing RS due to app closing.");
		seed = alias = secret = "";
               	try
               	{
               		if(meta!=null){
               		meta.closeRecordStore();
               		}
               		if(rs!=null){
               		rs.closeRecordStore();
               		}
               	}
               	catch(RecordStoreException rse) {}
		notifyDestroyed();
        }

        public SeciossOTP()
        {
        }

	private void doCurrentAction()
	{
		if(currentAction.equals("doFirstRun"))
			doFirstRun();
		else if(currentAction.equals("checkForDefaults"))
			checkForDefaults();
		else if(currentAction.equals("newSecret"))
			newSecret();
		else if(currentAction.equals("newManualSecret"))
			newManualSecret();
		else if(currentAction.equals("newAlias"))
			newAlias();
		else if(currentAction.equals("donewPassCode"))
			donewPassCode();
		else if(currentAction.equals("startApp"))
			startApp();
		else
                	mainApp();
	}

	public void commandAction(Command c, Displayable s)
        {
		if(c == exitMenuCommand | c == exitMainCommand)
                        destroyApp(false);

		else if(c == checkForDefaultsNoCommand)
			newSecret();

		else if(c == checkForDefaultsYesCommand)
			LoadDefaults();

		else if(c == backCommand | c == cancelCommand)
			doCurrentAction();

		else if(c == timezoneCommand)
			doTimeZone();

		else if(c == tzsaveCommand)
			doTZsave();

		else if(c == aboutMainCommand | c == aboutMenuCommand)
			doAboutCommand();

		else if(c == doNextCommand)
		{
			if(nextAction == "newAliasNextCommand")
			{
				if(newalias.length() >= 1)
					generateInit();
				else
					newAlias();
			} else if(nextAction == "newManSecNextCommand") {
				if(seed.length() < 16)
					newManualSecret();
				else
					newAlias();
			} else if(nextAction == "resetNextCommand") {
				doresetNext();
			} else if(nextAction == "dodeleteSecret") {
				dodeleteNext();
			} else if(nextAction == "wipeCommand") {
				doDBWipe();
			}
		}
		else if(c == newAliasDeleteCommand)
			donewAliasDeleteCommand();

		else if(c == ManualSecretCommand)
		{
			manualsecret = 1;
			seed = "";
			newManualSecret();
		}

		else if(c == newManSecDeleteCommand)
			donewManSecDeleteCommand();

		else if(c == newPassCodeCommand)
			donewPassCode();

		else if(c == resetSecretCommand)
		{
			nextAction = "resetNextCommand";
			doNext("̃V[NbgZbg悤ƂĂ܂B{ɂ낵łH");
		}
		else if(c == deleteSecretCommand)
		{
			nextAction = "dodeleteSecret";
			doNext("̃V[Nbg폜悤ƂĂ܂B{ɂ낵łH");
		}
		else if(c == mainMenuCommand)
		{
			currentRecord = -1;
			seed = alias = secret = initdate = "";
			aliasmode = 0;
			mainApp();
		}

		else if(c == wipeCommand)
		{
			nextAction = "wipeCommand";
			doNext("[̃f[^x[X폜Ă낵łH");
		}
		else if(c == selectSecretCommand | c == List.SELECT_COMMAND)
			doselectSecret();

		else if(c == uploadAlert)
			mainApp();

		else
			System.out.println("I missed something! "+c);
	}

	private void doselectSecret()
	{
		Display display = Display.getDisplay(this);
		List options = (List)display.getCurrent();
		int option = options.getSelectedIndex();
		if(option > 0)
		{
			secret = initdate = alias = "";
			try
			{
				String tmpStr = "";
				currentRecord = (option - 1) * 3;
				try
				{
					tmpStr = new String(rs.getRecord(currentRecord+2));
				} catch (NullPointerException e) {}

				if(tmpStr.length() >= 16)
					secret = decodeString(tmpStr.getBytes());
				else
					secret = new MD5(tmpStr).asHex();

				secret = secret.substring(0, 16);

				initdate = new String(rs.getRecord(currentRecord+3));
				alias = new String(rs.getRecord(currentRecord+4));
				System.out.println("Hash loaded from slot"+((currentRecord / 3) + 1));
				System.out.println("Alias: "+alias);
				donewPassCode();
			} catch(RecordStoreException rse) { System.out.println("RS Error! Read"); }

		} else {
			newSecret();
		}
	}

	private void mainApp()
	{
		currentAction = "mainApp";
		if(search.length() > 0)
			System.out.println("Search: '"+search+"'");
		List options = new List("V[NbgI", Choice.IMPLICIT);
		options.append("VV[Nbg", null);
		for(int loop = 0; loop < totalRecords; loop++)
		{
			int recnum = loop * 3 + 4;
			try
			{
				alias = new String(rs.getRecord(recnum));
				if(search.length() > 0)
				{
					if(!alias.startsWith(search))
						continue;
				}
			} catch(RecordStoreException rse) { System.out.println("RS Error! Read"); }
			options.append(alias, null);
		}

		options.addCommand(exitMainCommand);
		options.addCommand(mainMenuCommand);
		options.addCommand(aboutMainCommand);
		//options.addCommand(timezoneCommand);
		//options.addCommand(backupCommand);
		//options.addCommand(restoreCommand);
		options.addCommand(wipeCommand);
		//options.addCommand(testDefCommand);
		options.setCommandListener(this);
		for(int loop = 0; loop < totalRecords + 1; loop++)
		{
			options.setFont(loop, defFont);
		}
		Display.getDisplay(this).setCurrent(options);
	}

	public void startApp()
	{
		currentAction = "startApp";

		try
		{
        		rs = RecordStore.openRecordStore("SeciossOTP.DB", true);
			totalRecords = rs.getNumRecords();
		}
	       	catch(RecordStoreException rse) {System.out.println("RS Error! Open");}

//		checkTS();

		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				int w=getWidth();
				int h=getHeight();
				if(PIN.length() < 8)
				{
					if(totalRecords <= 0)
						showString(h, w, g, "Í邽߂ɁAohm͂ĂB");
					else
						showString(h, w, g, "𕜍邽߂ɁAohm͂ĂB");

					g.drawString("PIN: "+pindis,1,h-20,0);
				} else {
					showString(h, w, g, "̂܂܂ł҂B");
					displayTimer();
				}
			}

			protected void keyPressed (int keyCode)
			{
				if(keyCode >= '0' & keyCode <= '9')
				{
					PIN += (char)keyCode;
					if(PIN.length() < 8)
					{
						pindis += "*";
					} else {
						pindis += "*";
						PIN = PIN.substring(0, 8);
					}
				}
				repaint();
			}
		};

		lowinput.addCommand(exitMainCommand);
		lowinput.addCommand(aboutMainCommand);
		lowinput.setCommandListener(this);
		Display.getDisplay(this).setCurrent(lowinput);
	}

	private void displayTimer()
	{
System.out.println("Starting timer and waiting 25ms, should be enough for the display to refresh.");
		timer = new Timer();
		updateTask = new TimerTask()
		{
			public void run()
			{
System.out.println("Cancelling timer and jumping.");
				timer.cancel();
				dostartNext();
			}
		};

		long interval = 25;

		timer.schedule(updateTask, interval, interval);
	}

	private void checkDB()
	{
		firstRun = 0;
		if(totalRecords <= 0)
			firstRun = 1;

		if(totalRecords <= 0)
		{
			try
			{
				rs.addRecord("12".getBytes(),0,"12".length());
			} catch (RecordStoreException rse) {
				System.out.println("Failed to add timez to RMS");
			}
		}

		if(firstRun == 0)
		{
			totalRecords = (totalRecords - 1) / 3;
			try
			{
				tmpbuf = new String(rs.getRecord(1));
				System.out.println("Before: "+tmpbuf);
				timez = Integer.parseInt(tmpbuf);
				System.out.println("Timez: "+timez);
			} catch (NumberFormatException err) {
				System.out.println("Corrupted DB!");
				timez = -9;
			} catch (RecordStoreException rse) {
				System.out.println("Empty DB!");
				timez = -9;
			}
		}

		if(timez < -1 | timez > 25)
		{
			timez = 12;
			firstRun = 1;
			totalRecords = 0;
			try
			{
				rs.closeRecordStore();
				RecordStore.deleteRecordStore("SeciossOTP.DB");
				rs = RecordStore.openRecordStore("SeciossOTP.DB", true);
			}
			catch(RecordStoreException rse) {System.out.println("RS Error! Open");}
		}

		if(totalRecords == 1)
		{
			mainApp();
		} else if(firstRun != 0) {
			checkTS();
			doFirstRun();
		} else {
			mainApp();
		}
	}

	private void dostartNext()
	{
		if(PIN.length() >= 8)
		{
			String DBPIN = PIN.substring(0, 8);
			secretPIN = PIN;
			PIN = pindis = "";

			int hasCrypto = 0, oldRecords = 0;
			RecordStore oldrs = null;
	        	try
			{
        			meta = RecordStore.openRecordStore("SeciossOTP.META", true);
				hasCrypto = meta.getNumRecords();
				if(hasCrypto >= 1)
					secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), meta.getRecord(1));

				if(totalRecords <= 0)
				{
	        			oldrs = RecordStore.openRecordStore("SeciossOTP", false);
					oldRecords = oldrs.getNumRecords();
				}
			}
	       		catch(RecordStoreException rse) {System.out.println("RS Error! Open");}

			if(totalRecords <= 0 & hasCrypto <= 0 & oldRecords > 0)
			{
				try
				{
					secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), "".getBytes());
					meta.addRecord(secretdecode.getSalt(),0,8);
					for(int i = 1; i <= oldRecords; i++)
					{
						if((i - 2) / 3 == 0)
							tmpbuf = encodeString(new String(oldrs.getRecord(i)));
						else
							tmpbuf = new String(oldrs.getRecord(i));
						rs.addRecord(tmpbuf.getBytes(),0,tmpbuf.length());
					}
					oldrs.closeRecordStore();
					RecordStore.deleteRecordStore("SeciossOTP");
					totalRecords = rs.getNumRecords();
				} catch (RecordStoreException rse) {}
			}

			if(totalRecords > 0)
			{
				DBPIN = "";
				checkDB();
			} else {
				try
				{
					secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), "".getBytes());
					meta.addRecord(secretdecode.getSalt(),0,8);
					checkDB();
				} catch (RecordStoreException rse) {}
			}
		} else {
			startApp();
		}
	}

	private void doresetNext()
	{
		secret = "";
		aliasmode = 1;
		newSecret();
	}

	private void dodeleteNext()
	{
		alias = secret = seed = PIN = pindis = "";
		aliasmode = 0;
		try
		{
			int j = 0;
			String[] tmpsecret = new String[totalRecords-1];
			String[] tmpdate = new String[totalRecords-1];
			String[] tmpalias = new String[totalRecords-1];
			System.out.println("Need to delete: "+currentRecord);
			for(int i = 2; i < totalRecords * 3; i += 3)
			{
				System.out.println("Trying: "+i);
				if(i != currentRecord + 2)
				{
					tmpsecret[j] = new String(rs.getRecord(i));
					tmpdate[j] = new String(rs.getRecord(i+1));
					tmpalias[j] = new String(rs.getRecord(i+2));
					System.out.println("Alias: "+tmpalias[j]);
					j++;
				} else {
					System.out.println("Skipped "+i+" due to deletion!");
				}
			}
			j--;
			rs.closeRecordStore();
			RecordStore.deleteRecordStore("SeciossOTP.DB");
			rs = RecordStore.openRecordStore("SeciossOTP.DB", true);
			rs.addRecord("12".getBytes(),0,"12".length());
			rs.setRecord(1,(""+timez).getBytes(),0,(""+timez).length());
			for(int i = 0; i <= j; i++)
			{
				rs.addRecord(tmpsecret[i].getBytes(),0,tmpsecret[i].length());
				rs.addRecord(tmpdate[i].getBytes(),0,tmpdate[i].length());
				rs.addRecord(tmpalias[i].getBytes(),0,tmpalias[i].length());
			}
			currentRecord = -1;
			totalRecords--;
		}
		catch(RecordStoreException rse) {}
		mainApp();
	}

	private void doNext(final String message)
	{
		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				int w=getWidth();
				int h=getHeight();
				showString(h, w, g, message);
			}
		};

		lowinput.addCommand(cancelCommand);
		lowinput.addCommand(doNextCommand);
		lowinput.setCommandListener(this);
		Display.getDisplay(this).setCurrent(lowinput);
	}

	private void donewPassCode()
	{
		currentAction = "donewPassCode";
		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				g.setColor(255,255,255);
				int w=getWidth();
				int h=getHeight();
				g.fillRect(0,0,w,h);
				g.setColor(0,0,0);
				g.setFont(defFont);
				g.drawString("V[NbgF"+alias,1,1,0);
				now = new Date();
				//epoch = ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
				long dispepoch = (now.getTime() / 1000) + ((timez - 12) * 3600);
				dispepoch -= (int)(dispepoch / 60) * 60;
				dispepoch = 59 - dispepoch;
				/*
				String otp = epoch + secret;
				MD5 hash = new MD5(otp);
				if(OTPbits == 64)
					otp = getOTP64(hash.asHex());
				else
					otp = getOTP32(hash.asHex());
				*/
				
				// OneTimePasswordAlgorithm
				movingFactor = (((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
				String otp = OneTimePasswordAlgorithm.generateOTP((secret+secretPIN).getBytes(), movingFactor, codeDigits, addChecksum, truncationOffset);
				//
				g.drawString("pX[hF" + otp,1,30,0);
				g.drawString("F"+dispepoch,1,50,0);
			}
		};

		lowinput.addCommand(mainMenuCommand);
		//lowinput.addCommand(timezoneCommand);
		//lowinput.addCommand(switchCharSetCommand);
		//lowinput.addCommand(infoCommand);
		lowinput.addCommand(resetSecretCommand);
		lowinput.addCommand(deleteSecretCommand);
		lowinput.addCommand(aboutMenuCommand);
		lowinput.addCommand(exitMenuCommand);
		lowinput.setCommandListener(this);
		Display.getDisplay(this).setCurrent(lowinput);

		startTimer();
	}

	protected void startTimer()
	{
		timer = new Timer();
		updateTask = new TimerTask()
		{
			public void run()
			{
				if(lowinput != null)
					lowinput.repaint();
			}
		};

		long interval = 1000;

		timer.schedule(updateTask, interval, interval);
	}

	protected void stopFrameTimer()
	{
		timer.cancel();
	}

	private void doFirstRun()
	{
		System.out.println("FirstRun()!");
		currentAction = "doFirstRun";

		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				int w = getWidth();
				int h = getHeight();
				g.setColor(255,255,255);
				g.fillRect(0,0,w,h);
				showString(h, w, g, "悤ArnsoցB{^ĂB");
			}

			protected void keyPressed (int keyCode)
			{
				if(keyCode >= 32)
					checkForDefaults();
			}
		};

		lowinput.addCommand(exitMainCommand);
		lowinput.addCommand(aboutMainCommand);
		lowinput.setCommandListener(this);
		Display.getDisplay(this).setCurrent(lowinput);
	}

	private void donewAliasDeleteCommand()
	{
		if(newalias.length() > 0)
			newalias = newalias.substring(0, newalias.length() - 1);
		newAlias();
	}

	private void donewManSecDeleteCommand()
	{
		if(seed.length() > 0)
			seed = seed.substring(0, seed.length() - 1);
		newManualSecret();
	}

	private void newAlias()
	{
		currentAction = "newAlias";

       		lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
        			int w=getWidth();
        			int h=getHeight();
				g.setColor(255,255,255);
				g.fillRect(0,0,w,h);
				showString(h-40, w, g, "VV[NbgɑΉGCAX͂ĂB");
        			g.drawString("GCAX: "+newalias,1,h-20,0);
               		}

               		protected void keyPressed (int keyCode)
               		{
				if(keyCode >= 32)
					newalias = checkKey((char)keyCode, newalias);
				repaint();
               		}
               	};

		nextAction = "newAliasNextCommand";
               	lowinput.addCommand(newAliasDeleteCommand);
               	lowinput.addCommand(doNextCommand);
               	lowinput.addCommand(aboutMenuCommand);
               	lowinput.addCommand(exitMenuCommand);
               	lowinput.setCommandListener(this);
               	Display.getDisplay(this).setCurrent(lowinput);

		if(aliasmode > 0)
			generateInit();
	};

	private void generateInit()
	{
		currentAction = "generateInit";

		if(secret == "")
		{
			if(manualsecret == 0)
			{
				char[] charset = "123456789abcdefhkmnprstuvwxyzABCDEFGHKMNPQRSTUVWXYZ=+[]&@#*!-?%:".toCharArray();
				secret = "";
				SecureRandom rand = new SecureRandom();
				seed += ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
				for(int i = 0; i < 100; i++)
					seed += ""+(rand.nextInt() * 16384);
				char[] vals = hexToChar(new MD5(seed).asHex());
				for(int i = 0; i < 16; i++)
				{
					int j = vals[i] >> 2;
					while(j > 63)
						j -= 64;
					secret += charset[j];
				}
			} else {
				secret = seed.substring(0,16);
			}

			cnow=Calendar.getInstance();
			String day="" + cnow.get(Calendar.DAY_OF_MONTH);
			String month="" + (cnow.get(Calendar.MONTH)+1);
			String hour="" + cnow.get(Calendar.HOUR);
			String minute="" + cnow.get(Calendar.MINUTE);
			String year="" + cnow.get(Calendar.YEAR);
			if(day.length() < 2)
				day="0"+day;
			if(month.length() < 2)
				month="0"+month;
			if(hour.length() < 2)
				hour="0"+hour;
			if(minute.length() < 2)
				minute="0"+minute;
			if(year.length() < 2)
				year="0"+year;
			initdate=year+month+day+hour+minute;

			try
			{
				if(currentRecord == -1)
				{
					totalRecords++;
					currentRecord = (totalRecords * 3) - 3;
					alias = newalias;
					if(newalias.length() <= 0)
						alias = "Dummy Alias";
					if(alias.length() > 16)
						alias = alias.substring(0, 16);
					tmpbuf = encodeString(secret);
					rs.addRecord(tmpbuf.getBytes(),0,tmpbuf.length());
					rs.addRecord(initdate.getBytes(),0,initdate.length());
					rs.addRecord(alias.getBytes(),0,alias.length());
					System.out.println("New hash generated, stored in slot"+(totalRecords));
					System.out.println("Alias: "+alias);
				} else {
					if(newalias.length() > 0 & aliasmode == 0)
					{
						alias = newalias;
						alias = alias.substring(0, 16);
						rs.setRecord(currentRecord+4,alias.getBytes(),0,alias.length());
					}

					tmpbuf = encodeString(secret);
					rs.setRecord(currentRecord+2,tmpbuf.getBytes(),0,tmpbuf.length());
					System.out.println("Hash reset, stored in slot"+(currentRecord/3+1));
					System.out.println("Alias: "+alias);
				}
				PIN = newalias = seed = "";
				aliasmode = 0;
			}
			catch (RecordStoreException rse) {System.out.println("RS Error! Write");}
		}

       		lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
				g.setColor(255,255,255);
				int w=getWidth();
				int h=getHeight();
				g.fillRect(0,0,w,h);
				g.setColor(0,0,0);
				g.setFont(defFont);
				g.drawString("V[Nbg=",w/7,h/3-2,0);
				g.drawString(secret.substring(0,8),w/6,h/2,0);
				g.drawString(secret.substring(8,16),w/6,h/2+h/5,0);
               		}
               	};

               	lowinput.addCommand(mainMenuCommand);
               	lowinput.addCommand(newPassCodeCommand);
               	lowinput.addCommand(aboutMenuCommand);
               	lowinput.addCommand(exitMenuCommand);
               	lowinput.setCommandListener(this);
               	Display.getDisplay(this).setCurrent(lowinput);
	};

	private void newManualSecret()
	{
		currentAction = "newManualSecret";

       		lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
        			int w=getWidth();
        			int h=getHeight();
				g.setColor(255,255,255);
				g.fillRect(0,0,w,h);
				showString(40, w, g, "V[Nbg͂ĂB");
				if(seed.length() > 0)
				{
					int max = 8;
					if(seed.length() < max)
						max = seed.length();

	        			g.drawString(seed.substring(0,max),1,60,0);
				}

				if(seed.length() > 8)
				{
					int max = 16;
					if(seed.length() < max)
						max = seed.length();

	        			g.drawString(seed.substring(8,max),1,80,0);
				}
               		}

               		protected void keyPressed (int keyCode)
               		{
				if(keyCode >= 32)
					seed = checkKey((char)keyCode, seed);

				if(seed.length() > 16)
					seed = seed.substring(0, 16);
				repaint();
               		}
               	};

		nextAction = "newManSecNextCommand";
		lowinput.addCommand(newManSecDeleteCommand);
		lowinput.addCommand(doNextCommand);
               	lowinput.addCommand(aboutMenuCommand);
               	lowinput.addCommand(exitMenuCommand);
               	lowinput.setCommandListener(this);
               	Display.getDisplay(this).setCurrent(lowinput);
	}

	private void newSecret()
	{
		currentAction = "newSecret";

		int rsAvailable = 0;

		try
		{
			rsAvailable = rs.getSizeAvailable();
		} catch (RecordStoreException rse) {}

		if(rsAvailable > 100 | currentRecord >= 0)
		{
	       		lowinput = new Canvas()
        	       	{
               			public void paint(Graphics g)
               			{
        				int w=getWidth();
	        			int h=getHeight();
					g.setColor(255,255,255);
					g.fillRect(0,0,w,h);
					showString(h-40, w, g, "VV[Nbg𐶐邽߂ɁAׂɂQO{^͂ĂB");
        				g.drawString("c: "+(20 - seed.length()),1,h-20,0);
	               		}

        	       		protected void keyPressed (int keyCode)
               			{
					if(keyCode >= 32)
					{
						seed += (char)keyCode;
						if(seed.length() >= 20 & aliasmode == 0)
							newAlias();
						else if(seed.length() >= 20)
							generateInit();
						else
							repaint();
					}
        	       		}
               		};

	               	lowinput.addCommand(mainMenuCommand);
			lowinput.addCommand(ManualSecretCommand);
               		lowinput.addCommand(aboutMenuCommand);
	               	lowinput.addCommand(exitMenuCommand);
        	       	lowinput.setCommandListener(this);
               		Display.getDisplay(this).setCurrent(lowinput);
		} else {
	       		lowinput = new Canvas()
        	       	{
               			public void paint(Graphics g)
               			{
        				int w=getWidth();
	        			int h=getHeight();
					g.setColor(255,255,255);
					g.fillRect(0,0,w,h);
					showString(h, w, g, "f[^x[X̗eʂsĂ܂Bo^f[^Pȏ폜ĂB");
	               		}
			};

	               	lowinput.addCommand(cancelCommand);
        	       	lowinput.setCommandListener(this);
               		Display.getDisplay(this).setCurrent(lowinput);
		}
	}

	private void showString(int h, int w, Graphics g, String tmpstr)
	{
		int ww = 10;//p̏ꍇB
		ww = 20;//SđSpƂB
		g.setColor(255,255,255);
		g.fillRect(0,0,w,h);
		g.setColor(0,0,0);
		g.setFont(defFont);
		int cw = (w - 30) / ww;
		int lines = (tmpstr.length() * ww) / w;
		int top = (h / 2) - (lines * 20 / 2);

		for(int i = 0; i <= lines; i++)
		{
			int max = (i+1) * cw;
			if(tmpstr.length() < max)
				max = tmpstr.length();
			g.drawString(tmpstr.substring(i*cw,max),15,top+i*20,0);
		}
		return;
	}

	private void checkForDefaults()
	{
		currentAction = "checkForDefaults";

		String defhash = "";
		String defalias = "";

		try
		{
			defhash = new String(getAppProperty("hash"));
		} catch (NullPointerException err) {}

		try
		{
			defalias = new String(getAppProperty("alias"));
		} catch (NullPointerException err) {}

		if(defhash.length() != 16 | defalias.length() <= 0)
		{
			newSecret();
		} else {
			lowinput = new Canvas()
			{
				public void paint(Graphics g)
				{
					int w = getWidth();
					int h = getHeight();
					showString(h, w, g, "eXgf[^[hȂu͂vAȂȂuvj[IĂB");
				}
			};

			lowinput.addCommand(checkForDefaultsNoCommand);
			lowinput.addCommand(checkForDefaultsYesCommand);
			lowinput.addCommand(aboutMenuCommand);
			lowinput.addCommand(exitMenuCommand);
			lowinput.setCommandListener(this);
			Display.getDisplay(this).setCurrent(lowinput);
		}
	}

	private void LoadDefaults()
	{
		String defhash = "";
		String defalias = "";

		try
		{
			defhash = new String(getAppProperty("hash"));
		} catch (NullPointerException err) {}

		try
		{
			defalias = new String(getAppProperty("alias"));
		} catch (NullPointerException err) {}

		try
		{
			timez = 12 + Integer.parseInt(new String(getAppProperty("timez")));
		} catch (NullPointerException err) {}

		alias = defalias;
		secret = defhash;
		cnow=Calendar.getInstance();
		String day=""+cnow.get(Calendar.DAY_OF_MONTH);
		String month=""+(cnow.get(Calendar.MONTH)+1);
		String hour=""+cnow.get(Calendar.HOUR);
		String minute=""+cnow.get(Calendar.MINUTE);
		String year=""+cnow.get(Calendar.YEAR);
		if (day.length()<2) day="0"+day;
		if (month.length()<2) month="0"+month;
		if (hour.length()<2) hour="0"+hour;
		if (minute.length()<2) minute="0"+minute;
		if (year.length()<2) year="0"+year;
		initdate=year+month+day+hour+minute;
		try
		{
			if(alias.length() > 16)
				alias = alias.substring(0,16);
			rs.setRecord(1,(""+timez).getBytes(),0,(""+timez).length());
			tmpbuf = encodeString(secret);
			rs.addRecord(tmpbuf.getBytes(),0,tmpbuf.length());
			rs.addRecord(initdate.getBytes(),0,initdate.length());
			rs.addRecord(alias.getBytes(),0,alias.length());
			System.out.println("New hash generated, stored in slot1");
			System.out.println("Alias: "+alias);
		}							

        	catch(RecordStoreException rse) {System.out.println("RS Error! Write");}
		currentRecord = 0;
		totalRecords = 1;
		donewPassCode();
	}

	private void doTimeZone()
	{
       		lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
               			now=new Date();
				epoch=""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);

               			int w=getWidth();
       				int h=getHeight();
       				g.setColor(255,255,255);
       				g.fillRect(0,0,w,h);
       				g.setColor(0,0,0);
				g.setFont(defFont);
       				g.drawString("^C][F",1,1,0);
       				if (timez > 12) g.drawString("UTC"+(12-timez),1,20,0);
       				else g.drawString("UTC+"+(12-timez),1,40,0);
       				g.drawString("G|bNԁF"+epoch,1,60,0);
				if(usenetwork == "Y" & serverepoch > 0 & serverts > 0)
				{
					long tsdiff = serverepoch + (now.getTime() / 60000) - serverts;
        				g.drawString("SeciossOTP Time: "+tsdiff,1,80,0);
				}
               		}

               		protected void keyPressed (int keyCode)
               		{
				keyCode = getGameAction(keyCode);
               			if (keyCode == KEY_NUM1 | keyCode == KEY_NUM4 | keyCode == KEY_NUM7 |
						keyCode == KEY_STAR | keyCode == LEFT | keyCode == DOWN)
				{
               				timez++;
				}

               			if (keyCode == KEY_NUM3 | keyCode == KEY_NUM6 | keyCode == KEY_NUM9 |
						keyCode == KEY_POUND | keyCode == RIGHT | keyCode == UP)
				{
               				timez--;
				}

               			if(timez < -1)
					timez=-1;

               			if(timez > 25)
					timez=25;

               			repaint();
               		}
               	};

               	lowinput.addCommand(cancelCommand);
		lowinput.addCommand(tzsaveCommand);
               	lowinput.setCommandListener(this);
               	Display.getDisplay(this).setCurrent(lowinput);
	}

	private void doTZsave()
	{
               	try
       		{
			rs.setRecord(1,(""+timez).getBytes(),0,(""+timez).length());
       		}
       		catch (RecordStoreException rse) {System.out.println("RS Error! Write");}

		if(usenetwork == "Y" & serverepoch > 0 & serverts > 0)
		{
			now = new Date();
			epoch = ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
			long tmpepoch = Long.parseLong(epoch);
			long tsdiff = serverepoch + (now.getTime() / 60000) - serverts;

			if(tmpepoch - 6 >= tsdiff | tmpepoch + 6 <= tsdiff)
				System.out.println("Clock skew in phone detected!");
		}

		doCurrentAction();
	}

	private void doAboutCommand()
	{
               	lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
               			int w=getWidth();
       				int h=getHeight();
       				g.setColor(255,255,255);
       				g.fillRect(0,0,w,h);
       				g.setColor(0,0,0);
       				g.drawString(new String(getAppProperty("MIDlet-Name"))+" is based on",3,3,0);
				g.drawString("MobileOTP v 1.0.6",3,20,0);
              			g.drawString("(c) 2003, 2004",3,40,0);
               			g.drawString("M. Straub",3,60,0);
               			g.drawString(UserAgent,3,80,0);
               			g.drawString("(c) 2009",3,100,0);
               			g.drawString("SECIOSS CORP",3,120,0);
				try
				{
					int tmpused = rs.getSize() / (rs.getSize() + rs.getSizeAvailable()) * 100;
					g.drawString("DB : "+tmpused+"% used ("+rs.getSize()+"/"+(rs.getSize() + rs.getSizeAvailable())+")",3,140,0);
					g.drawString(rs.getNumRecords()+" records stored",3,160,0);
				}
	                	catch(RecordStoreException rse) {}
               		}
               	};
               	lowinput.addCommand(backCommand);
               	lowinput.setCommandListener(this);
               	Display.getDisplay(this).setCurrent(lowinput);
	}

	private void checkTS()
	{
		/*
		if(serverts == 0 | serverepoch == 0)
		{
			String tmpnetwork = "Y";
			try
			{
				tmpnetwork = new String(getAppProperty("UseNetwork"));
			} catch (NullPointerException e) {}

			if(tmpnetwork.startsWith("N") | tmpnetwork.startsWith("n"))
				usenetwork = "N";
			else
				usenetwork = "Y";

			if(usenetwork == "Y")
			{
				HTTP newconn = new HTTP();
				String sURL = new String(getAppProperty("TimeStampURI"));
				String message = newconn.getTimeStamp(sURL, UserAgent);
				if(!message.equals(""))
				{
					now = new Date();
       					epoch = ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
					serverts = now.getTime() / 60000;
					serverepoch = Long.parseLong(message);

					long tmpepoch = Long.parseLong(epoch);

					System.out.println("Current timestamp: "+epoch);
					System.out.println("Server timestamp: "+serverepoch);
					System.out.println((tmpepoch - 6)+" <= "+serverepoch+" <= "+(tmpepoch + 6));

					if(tmpepoch - 6 >= serverepoch | tmpepoch + 6 <= serverepoch)
					{
						System.out.println("Clock skew in phone detected! Attempting to correct!");
						for(int i = -1; i <= 25; i++)
						{
							tmpepoch = (((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
							if(tmpepoch - 6 >= serverepoch | tmpepoch + 6 <= serverepoch)
							{
								timez = i;
								int tr = -9;
								try
								{
									tr = rs.getNumRecords();
								}
						               	catch(RecordStoreException rse) { System.out.println("RS Error! Failed to update time zone"); }

								try
								{
						       			rs.setRecord(1,(""+timez).getBytes(),0,(""+timez).length());
								} catch(RecordStoreException rse) {
									System.out.println("RS Error! Failed to update time zone");
								}
							}
						}
					}
				} else {
					usenetwork = "N";
				}
			}
		}
		*/

		try
		{
			if(rs.getNumRecords() <= 0)
			{
				rs.addRecord("12".getBytes(),0,"12".length());
			}
		}
		catch(RecordStoreException rse) { System.out.println("RS Error! Failed to update time zone"); }

		return;
	}

	private char[] hexToChar(String hex)
	{
		char[] kDigits = "0123456789abcdef".toCharArray();
		int length = hex.length() / 2;
		char[] raw = new char[length];

		for (int i = 0; i < length; i++)
		{
			int high = Character.digit(hex.charAt(i * 2), 16);
			int low = Character.digit(hex.charAt(i * 2 + 1), 16);
			int value = (high << 4) | low;
			raw[i] = (char)value;
		}
		return raw;
	}

	private void doDBWipe()
	{
		totalRecords = 0;
		currentRecord = -1;
		PIN = seed = alias = secret = initdate = "";
		try
		{
			meta.closeRecordStore();
			RecordStore.deleteRecordStore("SeciossOTP.META");
		}
		catch(RecordStoreException rse) {System.out.println("RS Error! Destroy RS Meta");}

		try
		{
			rs.closeRecordStore();
			RecordStore.deleteRecordStore("SeciossOTP.DB");
		}
		catch(RecordStoreException rse) {System.out.println("RS Error! Destroy RS DB");}

		destroyApp(false);
	}

	private String encodeString(String Encode)
	{
		String tmpStr = "";

//		System.out.println("Before: "+Encode);

		try
		{
			tmpStr = new String(secretdecode.encrypt(Encode));
		} catch(Exception e) {
//			System.out.println("Failed to encode string: "+Encode);
//			System.out.println("Error: "+e);
		}

//		System.out.println("After: "+tmpStr);

		return tmpStr;
	}

	private String decodeString(byte[] Encoded)
	{
		String tmpStr = "";

//		System.out.println("Before: "+new String(Encoded));

		try
		{
			tmpStr = new String(secretdecode.decrypt(new String(Encoded)));
		} catch(Exception e) {
//			System.out.println("Failed to decode string: "+new String(Encoded));
//			System.out.println("Error: "+e);
		}

		if(tmpStr.length() <= 0)
		{
			tmpStr = new String(Encoded);
			tmpStr = new MD5(tmpStr).asHex();
		}

		if(tmpStr.indexOf((char)0) > 0)
			tmpStr = tmpStr.substring(0, tmpStr.indexOf((char)0));

//		System.out.println("After: "+tmpStr);

		return tmpStr;
	}

	private String checkKey(char key, String tmpStr)
	{
		if((key < '0' | key > '9'))
		{
			tmpStr += key;
			return(tmpStr);
		}

		now = new Date();
		thispress = now.getTime();
		if(lastkey == key && lastpress + 2000 >= thispress && tmpStr.length() > 0)
		{
			char tmp = tmpStr.charAt(tmpStr.length()-1);
			if(key == '1')
			{
				if(tmp == '1')
					tmp = '-';
				else if(tmp == '-')
					tmp = '.';
				else if(tmp == '.')
					tmp = '@';
				else if(tmp == '@')
					tmp = '/';
				else if(tmp == '/')
					tmp = ':';
				else if(tmp == ':')
					tmp = '_';
				else if(tmp == '_')
					tmp = '=';
				else if(tmp == '=')
					tmp = '&';
				else if(tmp == '&')
					tmp = '[';
				else if(tmp == '[')
					tmp = ']';
				else if(tmp == ']')
					tmp = '!';
				else if(tmp == '!')
					tmp = '-';
				else if(tmp == '-')
					tmp = '?';
				else if(tmp == '?')
					tmp = '%';
				else if(tmp == '%')
					tmp = '*';
				else if(tmp == '*')
					tmp = '#';
				else if(tmp == '#')
					tmp = '1';
			} else if(key == '2') {
				if(tmp == '2')
					tmp = 'a';
				else if(tmp == 'a')
					tmp = 'b';
				else if(tmp == 'b')
					tmp = 'c';
				else if(tmp == 'c')
					tmp = 'A';
				else if(tmp == 'A')
					tmp = 'B';
				else if(tmp == 'B')
					tmp = 'C';
				else if(tmp == 'C')
					tmp = '2';
			} else if(key == '3') {
				if(tmp == '3')
					tmp = 'd';
				else if(tmp == 'd')
					tmp = 'e';
				else if(tmp == 'e')
					tmp = 'f';
				else if(tmp == 'f')
					tmp = 'D';
				else if(tmp == 'D')
					tmp = 'E';
				else if(tmp == 'E')
					tmp = 'F';
				else if(tmp == 'F')
					tmp = '3';
			} else if(key == '4') {
				if(tmp == '4')
					tmp = 'g';
				else if(tmp == 'g')
					tmp = 'h';
				else if(tmp == 'h')
					tmp = 'i';
				else if(tmp == 'i')
					tmp = 'G';
				else if(tmp == 'G')
					tmp = 'H';
				else if(tmp == 'H')
					tmp = 'I';
				else if(tmp == 'I')
					tmp = '4';
			} else if(key == '5') {
				if(tmp == '5')
					tmp = 'j';
				else if(tmp == 'j')
					tmp = 'k';
				else if(tmp == 'k')
					tmp = 'l';
				else if(tmp == 'l')
					tmp = 'J';
				else if(tmp == 'J')
					tmp = 'K';
				else if(tmp == 'K')
					tmp = 'L';
				else if(tmp == 'L')
					tmp = '5';
			} else if(key == '6') {
				if(tmp == '6')
					tmp = 'm';
				else if(tmp == 'm')
					tmp = 'n';
				else if(tmp == 'n')
					tmp = 'o';
				else if(tmp == 'o')
					tmp = 'M';
				else if(tmp == 'M')
					tmp = 'N';
				else if(tmp == 'N')
					tmp = 'O';
				else if(tmp == 'O')
					tmp = '6';
			} else if(key == '7') {
				if(tmp == '7')
					tmp = 'p';
				else if(tmp == 'p')
					tmp = 'q';
				else if(tmp == 'q')
					tmp = 'r';
				else if(tmp == 'r')
					tmp = 's';
				else if(tmp == 's')
					tmp = 'P';
				else if(tmp == 'P')
					tmp = 'Q';
				else if(tmp == 'Q')
					tmp = 'R';
				else if(tmp == 'R')
					tmp = 'S';
				else if(tmp == 'S')
					tmp = '7';
			} else if(key == '8') {
				if(tmp == '8')
					tmp = 't';
				else if(tmp == 't')
					tmp = 'u';
				else if(tmp == 'u')
					tmp = 'v';
				else if(tmp == 'v')
					tmp = 'T';
				else if(tmp == 'T')
					tmp = 'U';
				else if(tmp == 'U')
					tmp = 'V';
				else if(tmp == 'V')
					tmp = '8';
			} else if(key == '9') {
				if(tmp == '9')
					tmp = 'w';
				else if(tmp == 'w')
					tmp = 'x';
				else if(tmp == 'x')
					tmp = 'y';
				else if(tmp == 'y')
					tmp = 'z';
				else if(tmp == 'z')
					tmp = 'W';
				else if(tmp == 'W')
					tmp = 'X';
				else if(tmp == 'X')
					tmp = 'Y';
				else if(tmp == 'Y')
					tmp = 'Z';
				else if(tmp == 'Z')
					tmp = '9';
			} else if(key == '0') {
				if(tmp == '0')
					tmp = ' ';
				else if(tmp == ' ')
					tmp = '+';
				else if(tmp == '+')
					tmp = '0';
			}
			tmpStr = tmpStr.substring(0, tmpStr.length() - 1) + tmp;
		} else {
			tmpStr = tmpStr + key;
		}
		lastpress = now.getTime();
		lastkey = key;
		return(tmpStr);
	}
}
