/*
 * Copyright(c) SECIOSS CORPORATION 2009
 */

package SeciossOTP;

import java.io.*;

import javax.microedition.io.*;




public class RecordStore
{
	private static final int POS_META = 0;
	private static final int SIZE_META = 10;
	private static final int POS_RECORD = SIZE_META;

	public RecordStore()
	{
	}
	
	public void addRecord(String record)
	{
		int pos = getSize();
		if(pos<POS_RECORD) pos = POS_RECORD;
		DataOutputStream dos = null;
		System.out.println(record);
		try
		{
			dos = Connector.openDataOutputStream("scratchpad:///0;pos="+pos);
			dos.writeUTF(record);
			dos.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public void addMeta(byte[] salt)
	{
		DataOutputStream dos = null;
		String tmpstr = new String(salt);
		try
		{
			dos = Connector.openDataOutputStream("scratchpad:///0;pos="+POS_META);
			dos.writeUTF(tmpstr);
			dos.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public void setRecord(int recordId, String record)
	{
		int size = record.getBytes().length;
		int pos = getPosByRecordId(recordId);
		int size_diff = size - getRecordSizeByPos(pos);
		if(size_diff!=0){
			displaceRecord(pos,size_diff);
		}
		DataOutputStream dos = null;
		try
		{
			dos = Connector.openDataOutputStream("scratchpad:///0;pos="+pos);
			dos.writeUTF(record);
			dos.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public int getNumRecords()
	{
		InputStream is = null;
		int num = 0;
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos="+POS_RECORD);
			while(true){
				int size_data = 0;
				size_data += is.read()*256;
				size_data += is.read();
				if(size_data==0) break;
				is.skip(size_data);
				num++;
			}
			is.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return num;
	}
	
	public String getRecord(int recordId)
	{
		DataInputStream dis = null;
		String record = null;
		try
		{
			dis = Connector.openDataInputStream("scratchpad:///0;pos="+POS_RECORD);
			for(int i=0;i<recordId;i++){
				record = dis.readUTF();
			}
			dis.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return record;
	}

	public byte[] getMeta()
	{
		DataInputStream dis = null;
		byte[] salt = null;
		try
		{
			dis = Connector.openDataInputStream("scratchpad:///0;pos="+POS_META);
			salt = dis.readUTF().getBytes();
			dis.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return salt;
	}
	
	// get size available for record
	public int getSizeAvailable()
	{
		int size_all = getSizeAll();
		int size_record = getSize();
		return size_all - size_record;
	}
	
	// get size of all records
	// ͐Vrecordposɓ
	public int getSize()
	{
		InputStream is = null;
		int size = 0;
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos=0");
			boolean flag = false;
			while(true){
				int tmp = is.read();
				if(tmp==0){
					if(flag){
						size--;
						break;
					}else flag = true;
				}else if(flag){
					flag = false;
				}
				if(tmp==-1){
					break;
				}
				size++;
			}
			is.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return size;
	}
	
	// get size of scratch pad
	public int getSizeAll()
	{
		InputStream is = null;
		int size = 0;
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos=0");
			size = is.available();
			is.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return size;
	}
	
	public void deleteAllRecord()
	{
		int size_all = getSizeAll();
		OutputStream os = null;
		try
		{
			os = Connector.openOutputStream("scratchpad:///0;pos="+POS_RECORD);
			for(int i=0;i<size_all-POS_RECORD;i++){
				os.write(0);
			}
			os.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public void deleteMeta()
	{
		OutputStream os = null;
		try
		{
			os = Connector.openOutputStream("scratchpad:///0;pos="+POS_META);
			for(int i=0;i<SIZE_META;i++){
				os.write(0);
			}
			os.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public boolean hasMeta()
	{
		InputStream is = null;
		byte[] tmp = new byte[2];
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos="+POS_META);
			is.read(tmp);
			is.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		if(tmp[0]==0 && tmp[1]==0){
			return false;
		}
		
		return true;
	}
	
	public int getPosByRecordId(int recordId)
	{
		InputStream is = null;
		int pos = POS_RECORD;
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos="+POS_RECORD);
			while(recordId>1){
				int size_data = 0;
				size_data += is.read()*256;
				size_data += is.read();
				if(size_data==0) break;
				is.skip(size_data);
				pos += size_data+2;
				recordId--;
			}
			is.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return pos;
	}
	
	public int getRecordSizeByPos(int pos)
	{
		InputStream is = null;
		int size_record = 0;
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos="+pos);
			size_record += is.read()*256;
			size_record += is.read();
			is.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return size_record;
	}
	
	// posȍ~̃R[h炷
	// lengthցAO
	public boolean displaceRecord(int pos, int length)
	{
		if(length > 0 && getSizeAvailable()<length) return false;
		else if(pos+length<0) return false;
		int size_displace = getSize() - pos;
		byte[] tmp = new byte[size_displace];
		InputStream is = null;
		OutputStream os = null;
		try
		{
			is = Connector.openInputStream("scratchpad:///0;pos="+pos);
			is.read(tmp);
			is.close();
			if(length>0){
				os = Connector.openOutputStream("scratchpad:///0;pos="+pos);
				for(int i=0;i<length;i++){
					os.write(0);
				}
				os.close();
			}
			pos += length;
			os = Connector.openOutputStream("scratchpad:///0;pos="+pos);
			os.write(tmp);
			for(int i=0;i<-length;i++){
				os.write(0);
			}
			os.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return true;
	}
	
}