#include <stdio.h>
//#include <unistd.h>
//#include <sys/ioctl.h>
//#include <termios.h>
#include <fcntl.h>
#include <syslog.h>
#include <sys/types.h>
#include <string.h>

#include "debug_print.h"
#include "spi.h"
#include "ad_ring.h"
#include "conf.h"

/*
	Little Endian
	3byte -> signed long(4byte)
*/
static long b3_to_long32(unsigned char *ptr)
{
	char	buf[4];
	
	buf[0] = *ptr++;
	buf[1] = *ptr++;
	buf[2] = *ptr;
	if (*ptr & 0x80) {
		buf[3] = 0xFF;
	} else {
		buf[3] = 0;
	}
	return *((long*)buf);
}
static int decode(char *buf, AdData *ad)
{
	UbloxNavTimeUtc	*gps;
	u_int8_t	*ptr;
	int	ch;
	int	i;
	
	ptr = (u_int8_t*)buf;
	gps = &(ad->gps);

	if (*ptr++ != SPI_HEAD_CHAR) return -1;
	// Response Code
	ad->rescode = *ptr++;
	// Response Data
	memcpy(ad->resdata, ptr, SPI_RESDATA_LEN);
	ptr += SPI_RESDATA_LEN;
	// GPS
	gps->tow = *((int32_t*)ptr); ptr += 4;
	gps->tacc = *((int32_t*)ptr); ptr += 4;
	gps->nano = *((int32_t*)ptr); ptr += 4;
	gps->year = *((int16_t*)ptr); ptr += 2;
	gps->month = *((u_int8_t*)ptr); ptr++;
	gps->day = *((u_int8_t*)ptr); ptr++;
	gps->hour = *((u_int8_t*)ptr); ptr++;
	gps->min = *((u_int8_t*)ptr); ptr++;
	gps->sec = *((u_int8_t*)ptr); ptr++;
	gps->valid = *((u_int8_t*)ptr); ptr++;
	// 1sec平均
	for(ch = 0; ch < AD_CHNUM; ch++) {
		ad->data1sec[ch] = *((int32_t*)ptr);
		ptr += 4;
	}
	// 50Hz data
	for(ch = 0; ch < AD_CHNUM; ch++) {
		for(i = 0; i < AD_SAMPLE; i++) {
			ad->data[ch][i] = b3_to_long32(ptr);
			ptr += 3;
		}
	}
	// Checksum
	ad->checksum = *((u_int16_t*)ptr);
	
	// gps->struct tm
	ad->t.tm_year = gps->year - 1900;
	ad->t.tm_mon = gps->month - 1;	// struct tmの月は(0〜11)なので注意
	ad->t.tm_mday = gps->day;
	ad->t.tm_hour = gps->hour;
	ad->t.tm_min = gps->min;
	ad->t.tm_sec = gps->sec;
	
	if (gps->year == 0) return -1;

	return 0;
}
/*
	int freq
		平均化後の周波数 Hz
*/
static void do_avg(int freq, AdData *ad)
{
	int	ch, i, j;
	long	add;
	int	avg_freq;
	int	avg_num;
	
	avg_freq = conf_freq_get();
	avg_num = AD_SAMPLE/avg_freq;
	for(ch = 0; ch < AD_CHNUM; ch++) {
		for(i = 0; i < avg_freq; i++) {
			add = 0;
			for(j = 0; j < avg_num; j++) {
				add += ad->data[ch][i*avg_num + j];
			}
			ad->avg[ch][i] = add / avg_num;
		}
	}
}
static unsigned int sum_calc(char *buf)
{
	int	i;
	u_int8_t	suma = 0;
	u_int8_t	sumb = 0;
	u_int16_t	uint_sum;

	for(i = SPI_OFS_RESCODE; i < SPI_OFS_SUM; i++) {
		suma += (u_int8_t)buf[i];
		sumb += suma;
	}
	uint_sum = ((sumb << 8) & 0xFF00U) | suma;
	return uint_sum;
}

void* thread_rcv(void* pParam)
{

	fd_set	fds;
	char	buf[SPI_DATA_LEN+256];
	int	i;
	int	fd_spi;
	AdData	ad, *ad_ptr;
	unsigned int	sum;
#if 0
char	cmd[SPI_CMD_LEN];
char	c;
c=0;
#endif
	// spiドライバのリングバッファクリア
	spi_buf_clear();
	// spi送信コマンド長セット
	spi_tx_len_set(SPI_CMD_LEN);

	while(1) {
		fd_spi = spi_get_fd();
		// select の準備
		FD_ZERO(&fds);
		// FDセット
		FD_SET(fd_spi, &fds);
		// 受信を待つ　タイムアウト無し
		i = select(fd_spi + 1, &fds, NULL, NULL, NULL);    // 読みselect
		if(i <= 0) syslog(LOG_ERR, "%s: select returned with signal or error. ret=%d\n", __FUNCTION__, i);
		if(FD_ISSET(fd_spi, &fds)) {
#if 0
// SPI送信データセット
if (c++ % 5 == 0) {
	memset(cmd, 0, SPI_CMD_LEN);
	for(i = 0; i < AD_CHNUM; i++)
		cmd[i] = SPI_CMD_GAIN_128;
	spi_cmd_send(SPI_CMDCODE_GAIN, cmd, AD_CHNUM);
}
#endif
			// 受信した
			i = spi_dnum_get();
PDEBUG("thread_rcv(): wakeup dnum=%d rcv_len=%d\n", i, spi_rcvd_len_get());
			while(i-- > 0) {
				memset(&ad, 0, sizeof(ad));
				// データ取得
				spi_rx_get(buf);
				// デコード
				if (decode(buf, &ad)) continue;
				// chekcsum check
				sum = sum_calc(buf);
				if (sum != ad.checksum) {
					PDEBUG("thread_rcv(): SUM ERR! CALC=%04X RCV=%04X\r\n", sum, ad.checksum);
				}
				// 平均
				ad.freq = conf_freq_get();
				do_avg(AD_SAMPLE, &ad);
#if 1
int	ch;
PDEBUG("%04d/%02d/%02d %02d:%02d:%02d.%09ld,%6lums,%6luns,%02X,%d",
	ad.gps.year, ad.gps.month, ad.gps.day, ad.gps.hour, ad.gps.min, ad.gps.sec, ad.gps.nano,
	ad.gps.tow, ad.gps.tacc, ad.gps.valid, ad.rescode);
for(ch = 0; ch < AD_CHNUM; ch++) {
	PDEBUG(",%+7ld", ad.data1sec[ch]);
}
PDEBUG("\r\n");
#endif
#if 0
for(ch = 0; ch < AD_CHNUM; ch++) {
	PDEBUG(",%+7ld", ad.data[ch][0]);
}
PDEBUG("\r\n");
for(ch = 0; ch < AD_CHNUM; ch++) {
	PDEBUG(",%+7ld", ad.data[ch][49]);
}
PDEBUG("\r\n");
#endif
				// ADリングバッファに書き込み
				ad_ptr = ad_ring_get(ad_ring_write_get());
				*ad_ptr = ad;
				// 最新データ位置
				ad_ring_latest_set(ad_ring_write_get());
				// 書き込み位置+1
				ad_ring_write_plus();

			} // while((i = sub_dnum_get()) > 0) {
		} // if(FD_ISSET(fd_sub, &fds)) {
	} // 	while(1) {
	return NULL;
}

//
/**** CUnit test
*/
#ifdef CUNIT
#include <CUnit/CUnit.h>

static void test_b3_to_long32(void)
{
	long	l;
	char	buf[SPI_DATA_LEN+256];
	AdData	ad;
	int	i;

	buf[0] = 0x56;
	buf[1] = 0x34;
	buf[2] = 0x12;
	l = b3_to_long32(buf);
	CU_ASSERT(l == 0x00123456);

	buf[0] = 0x56;
	buf[1] = 0x34;
	buf[2] = 0x82;
	l = b3_to_long32(buf);
	CU_ASSERT(l == (long)0xFF823456);

	buf[0] = 0xFF;
	buf[1] = 0xFF;
	buf[2] = 0xFF;
	l = b3_to_long32(buf);
	CU_ASSERT(l == -1);

	buf[0] = '$';
	i = SPI_OFS_DATA;
	buf[i++] = 0x56;
	buf[i++] = 0x34;
	buf[i++] = 0x12;
	decode(buf, &ad);
	CU_ASSERT(ad.data[0][0] == 0x123456);

	buf[0] = '$';
	i = SPI_OFS_DATA + AD_CHNUM * AD_SAMPLE * 3;
	i -= 3;
	buf[i++] = 0x56;
	buf[i++] = 0x34;
	buf[i++] = 0x12;
	decode(buf, &ad);
	CU_ASSERT(ad.data[AD_CHNUM-1][AD_SAMPLE-1] == 0x123456);
}

void thread_rcv_test(CU_pSuite test_suite)
{

	CU_add_test(test_suite, "test_b3_to_long32", test_b3_to_long32);

}

#endif
