#include "ring.h"

/*
	Ring Buffer用基本機能
	write位置
	read位置
*/
unsigned char	r_write;
unsigned char   r_read1;
unsigned char   r_read2;
unsigned char	r_num;

/*
*/
void ring_init(void)
{
    r_write = 0;
    r_read1 = 0;
    r_read2 = 0;
    r_num = RING_NUM;
}
/*
    読み出し位置
*/
void ring_read1_set(unsigned char i)
{
    r_read1 = i;
}
void ring_read1_plus(void)
{
    r_read1++;
    if (r_read1 >= r_num) r_read1 = 0;
}
void ring_read2_set(unsigned char i)
{
    r_read2 = i;
}
void ring_read2_plus(void)
{
    r_read2++;
    if (r_read2 >= r_num) r_read2 = 0;
}

// 読み込んでいないデータ数
unsigned char ring_num1_get()
{
    signed char	i;

    i = (signed char)r_write - (signed char)r_read1;
    if (i < 0) i += r_num;
    return (unsigned char)i;
}

unsigned char ring_num2_get()
{
    signed char	i;

    i = (signed char)r_write - (signed char)r_read2;
    if (i < 0) i += r_num;
    return (unsigned char)i;
}
/*
	パケットバッファフル？
	1=Full
	0=not Full
*/
unsigned char ring_is_full1(void)
{
    if (ring_num1_get() >= r_num - 1) return 1;
    return 0;
}
unsigned char ring_is_full2(void)
{
    if (ring_num2_get() >= r_num - 1) return 1;
    return 0;
}
