#include <p24FJ64GA004.h>
#include "myuart.h"

// UART1 ublox GPS受信用リングバッファ
static unsigned char   ubx_w, ubx_r;
static unsigned char    ubx_buf[256];

// UART2
#define UART2_BUFF_SIZE 16
static unsigned char   uart2_w, uart2_r;
static unsigned char   uart2_buf[UART2_BUFF_SIZE];

void __attribute__((interrupt, no_auto_psv)) _U1RXInterrupt(void)
{
    // 割り込みフラグクリア
    uart1_rx_intf_clear();
    while(uart1_rx_is_rdy()) {
        ubx_buf[ubx_w++] = uart1_getc();
    }
    if (U1STAbits.OERR == 1) U1STAbits.OERR = 0;
}
void __attribute__((interrupt, no_auto_psv)) _U2RXInterrupt(void)
{
    // 割り込みフラグクリア
    uart2_rx_intf_clear();
    while(uart2_rx_is_rdy()) {
        uart2_buf[uart2_w++] = uart2_getc();
        if (uart2_w >= UART2_BUFF_SIZE) uart2_w = 0;
    }
    if (U2STAbits.OERR == 1) U2STAbits.OERR = 0;
}
// polling send
void uart1_puts(char *s)
{
    while(*s != 0) {
        while(uart1_tx_is_full());
        U1TXREG = *s++;
    }
}
void uart2_puts(char *s)
{
    while(*s != 0) {
        while(uart2_tx_is_full());
        U2TXREG = *s++;
    }
}
void uart1_myputc(char c)
{
    while(uart1_tx_is_full());
    U1TXREG = c;
}
void uart2_myputc(char c)
{
    while(uart2_tx_is_full());
    U2TXREG = c;
}
/*
 * 受信バッファにデータあるか？
 * return 0=なし 1=あり
 */
int uart1_rcvbuf_is_data(void)
{
    if (ubx_r == ubx_w) return 0;
    return 1;
}
int uart2_rcvbuf_is_data(void)
{
    if (uart2_r == uart2_w) return 0;
    return 1;
}
/*
 * 受信バッファから1byte get
 * return データ -1=データ無し
 */
int uart1_rcvbuf_getc(void)
{
    if (ubx_r == ubx_w) return -1;
    return ubx_buf[ubx_r++];
}
int uart2_rcvbuf_getc(void)
{
    int out;
    if (uart2_r == uart2_w) return -1;
    out = uart2_buf[uart2_r++];
    if (uart2_r >= UART2_BUFF_SIZE) uart2_r = 0;
    return out;
}

void uart1_rcvbuf_clear(void)
{
    ubx_r = ubx_w;
}

void uart2_rcvbuf_clear(void)
{
    uart2_r = uart2_w;
}
void uart1_init(unsigned int mode, unsigned int sts, unsigned int baud)
{
    U1MODE = mode;
    U1STA = sts;
    U1BRG = baud;
    ubx_w = 0;
    ubx_r = 0;
}
void uart2_init(unsigned int mode, unsigned int sts, unsigned int baud)
{
    U2MODE = mode;
    U2STA = sts;
    U2BRG = baud;
    uart2_w = 0;
    uart2_r = 0;
}
