<?php

/**
 * 三国志システムエラー(クライアントにエラーを返す)
 * (本当はException継承して独自エラーを作成するのだが･･･)
 * 例外のcatchのgetCode以外で仕様しないこと
 *
 * @var string 三国志システムが独自に使用するエラーコード
 */
define('SYSTEM_ERROR', 99);

/**
 * 不明なエラーコード
 *
 * @var string システムが生成した例外以外のエラーコード
 */
define('UNKNOWN_ERROR', 99999);

/**
 * 不明なエラーコード
 *
 * @var string セッションID不一致のエラーコード
 */
define('SESSION_ERROR', 999);

/**
 * コマンド成功値
 *
 * @var integer コマンド失敗時の値
 */
define('CMD_ERR', 1);

/**
 * コマンド成功値
 *
 * @var integer コマンド成功時の値
 */
define('CMD_OK', 0);


/**
 * 電文のセパレータ文字
 *
 * @var string セパレータの文字
 */
define('SP', ',');

/**
 * 電文のラインフィード
 *
 * @var string セパレータの文字
 */
define('RLF', '>>');

/**
 * UserIDの桁数
 *
 * @var integer UserIDの桁数
 */
define('USERID_CNT', 10);

/**
 * コマンドの桁数
 *
 * @var integer コマンドの桁数
 */
define('CMD_CNT', 6);

/**
 * UserIDの型(先頭文字)
 *
 * @var integer UserIDの型(先頭文字)
 */
define('USERID_PREFIX', 'U');

/**
 * UserNameの桁数
 *
 * @var integer UserNameの桁数
 *
 */
define('USERNAME_CNT', 40);

/**
 * UserTypeの区分
 *
 * @var string UserIDの区分文字
 */
define('USER_KBN', 'u');

/**
 * UserTypeの区分
 *
 * @var string 総大将の区分文字
 */
define('SOUDAISYO_KBN', 's');

/**
 * 受付時間終了フラグ
 *
 * @var integer 受付時間が終了した時のフラグ値
 */
define('OVERTIME', 1);

/**
 * 攻撃側判定フラグ
 *
 * @var integer 攻撃側判定フラグ
 */
define('OFF_TYPE', 1);

/**
 * 守備側判定フラグ
 *
 * @var integer 守備側判定フラグ
 */
define('DEF_TYPE', 2);

/**
 * 攻撃側初期位置配列
 *
 * @var integer 攻撃側初期配備位置
 */
define('OFF_INIT', serialize(array(3356,3357,3358,3359,3360,3416,3417,3418,3419,3420,3476,3477,3478,3479,3480,3536,3537,3538,3539,3540,3596,3597,3598,3599,3600)));

/**
 * 守備側初期位置配列
 *
 * @var integer 守備側初期配備位置
 */
define('DEF_INIT', serialize(array(1,2,3,4,5,61,62,63,64,65,121,122,123,124,125,181,182,183,184,185,241,242,243,244,245,3301,3302,3303,3304,3305,3361,3362,3363,3364,3365,3421,3422,3423,3424,3425,3481,3482,3483,3484,3485,3541,3542,3543,3544,3545)));

/**
 * 攻撃減算地
 *
 * @var integer 守備側判定フラグ
 */
define('DEC_POWER', 10);

/**
 * 生成するコマンドクラス
 *
 * @var array コマンドクラス配列
 */
define('COMMAND_CLASS', serialize(array('U'=>'userAction.php', 'C'=>'countryAction.php', 'A'=>'aiAction.php', 'R'=>'roomAction.php', 'M'=>'mapAction.php', 'B'=>'battleAction.php')));
