/**
 * Saccubus
 * Copyright (C) 2012 psi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef METAINFO_H_
#define METAINFO_H_

#include "../classdefs.h"
#include "../util/ClassAccessor.h"
#include "ReplaceTable.h"
#include <string>
#include <libxml2/libxml/tree.h>

namespace saccubus {
namespace meta {

class MetaInfo{
	DEF_ATTR_ACCESSOR(public, private, std::string, title);
public:
	MetaInfo(logging::Logger& log, xmlNode* node);
	MetaInfo(logging::Logger& log, xmlDoc* doc);
	MetaInfo(logging::Logger& log, const std::string& filename);
	virtual ~MetaInfo();
private:
	void read(logging::Logger& log, xmlNode* node);
};

}}
#endif /* METAINFO_H_ */
