#ifndef ERROROUTPUT_H
#define ERROROUTPUT_H

#include <QTextEdit>

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

class ErrorSyntaxHighlighter;

class ErrorOutput : public QTextEdit
{
	Q_OBJECT

public:
	ErrorOutput(QWidget *parent = 0);
	~ErrorOutput();

public:
	bool	clearFlag() const { return m_clearFlag; }

public:
	void	appendText(const QString &);
	void	setCurrentFileName(const QString &fileName)
	{ m_currentFileName = fileName; }
	void	setClearFlag(bool b = true) { m_clearFlag = b; }
	void	jumpToNextErrorLine();

protected:
	bool	getErrorLineAndPath(const QTextBlock &, int &, QString &);

protected:
	void	mousePressEvent ( QMouseEvent * e );
	void	mouseDoubleClickEvent ( QMouseEvent * e );

protected slots:
	void	contentsChange(int, int, int);

signals:
	void	jumpToLine(int, QString);	//	sԍAt@CpX

private:
	bool		m_clearFlag;
	//int			m_currentLineNum;
	QString		m_currentFileName;

	ErrorSyntaxHighlighter	*m_errorSyntaxHighliter;
};

#endif // ERROROUTPUT_H
