#pragma once
/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QString>
#include <QList>
#include <QVector>

class EditView;

struct StringItem
{
public:
	StringItem(uchar type = 0, char closeQuote = '\0', char openQuote = '\0', uchar nestLevel = 0)
		: m_type(type)
		, m_closeQuote(closeQuote)
		, m_openQuote(openQuote)
		, m_nestLevel(nestLevel)
	{}

public:
	uchar	m_type;			//	[SDB]Q_STRING | EXPAND_EXP | HERE_DOCUMENT
	union {
		char	m_closeQuote;	//	I
		uchar	m_strType;		//	[SDB]Q_STRING for HERE_DOCUMENT
		//bool	m_expEnabled;	//	#{exp} L for HERE_DOCUMENT
	};
	union {
		char	m_openQuote;	//	lXgꍇ̊JnF ( { [ < ̂ꂩ
								//	lXgs̏ꍇ '\0'
		bool	m_indent;		//	for HERE_DOCUMENT
	};
	uchar	m_nestLevel;	//	lXgx
};

class ViewTokenizer
{
public:
	enum {
		UNDEF = 0,		//	l
		COMMENT,
		IDENT,			//	ppŎn܂锼pp
		NUMBER,			//	pŎn܂锼pp
		SQ_STRING,		//	VONH[g
		DQ_STRING,		//	_uNH[g
		BQ_STRING,		//	obNNH[g
		REGEXP,			//	K\e
		PERCENT_SYMBOL,	//	%s(...)
		SYMBOL,			//	̑V{
		END_OF_BUFFER,
						//	ȍ~ X^bNACeł̂ݎgp
		EXPAND_EXP,		//	#{exp} ̒WJ
		HERE_DOCUMENT,				//	<<IDENT
		//HERE_DOCUMENT_INDENT,		//	<<-IDENT
	};

public:
	ViewTokenizer(const QString &, EditView *);
	~ViewTokenizer(void);

public:
	uchar	tokenType() const { return m_tokenType; }
	QString	tokenText() const { return m_tokenText; }
	QString	prevTokenText() const { return m_prevText; }
	int		tokenOffset() const { return m_tokenOffset; }
	int		tokenLength() const { return m_tokenText.length(); }
	int		ix() const { return m_ix; }
	QChar	nextChar() const { return m_ix < m_buffer.size() ? m_buffer[m_ix] : QChar(); }
	char	quote() const { return m_quoteStack.isEmpty() ? '\0' : m_quoteStack.last().m_closeQuote; }
	bool	foundExp() const { return m_foundExp; }
	bool	inBrace() const;	// { return m_inBrace; }		//	#{ Ŕꍇ
	bool	atEndOfBuffer() const { return m_ix >= m_buffer.length(); }
	bool	mlString() const { return m_mlString; }
	int		quoteLength() const { return m_quoteLength; }
	uchar	nestLevel() const { return m_quoteStack.isEmpty() ? 0 : m_quoteStack.last().m_nestLevel; }
	int		tokenCloseQuoteLength() const { return m_tokenCloseQuoteLength; }
	const QVector<StringItem>	&quoteStack() const { return m_quoteStack; }

public:
	uchar	nextToken();
	uchar	nextString(char quote = '\0', int quoteLength = 0, uchar type = DQ_STRING, char openQuote = '\0');
	void	skipChar();		//	1i߂
	void	setQuoteStack(const QVector<StringItem> &quoteStack) { m_quoteStack = quoteStack; }
	void	pushBackToQuoteStack(const StringItem &si) { m_quoteStack.push_back(si); }
	void	popNestLevelAndQuote();
	void	setTokenText(const QString &text) { m_tokenText = text; }
	//void	setPrevTokenText(const QString &text) { m_prevText = text; }

protected:
	uchar	regexp(char quote, int quoteLength = 0, char openQuote = '\0');
	uchar	percentSymbol(char quote, int quoteLength);

private:
	EditView	*m_view;	//	for Debug
	const QString		m_buffer;
	int		m_ix;			//	݃ItZbg	
	bool	m_foundExp;		//	#{ 𔭌ꍇ
	//bool	m_inBrace;		//	#{exp} ̒
	bool	m_mlString;		//	񂪎̍sɑꍇ
	//char	m_openQuote;	//	Jn quote 
	//char	m_quote;		//	I[ quote 
	//char	m_closeChar;	//	I蕶
	uchar	m_tokenType;	//	g[N^Cv
	//uchar	m_nestLevel;	//	%( ) ރlXgx, 256 ȏɂȂꍇ͖̓ۏƂ
	int		m_tokenOffset;	//	g[NJnItZbg
	int		m_quoteLength;	//	JnNH[gނ̒
	int		m_tokenCloseQuoteLength;	//	g[N̏I Quote 
	QString	m_tokenText;	//	݃g[N
	QString	m_prevText;		//	ЂƂÕg[N
	QString	m_prev2Text;	//	ӂÕg[N
	QVector<StringItem>	m_quoteStack;
};

