/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include "Settings.h"

#include <QtCore>

typedef const char cchar;


Settings::Settings(void)
{
}


Settings::~Settings(void)
{
}
void Settings::setColor(int ix, const QColor &col)
{
	if( ix >= 0 && ix < N_COLOR )
		m_colors[ix] = col;
}

//	undone: colorKeys, defaultColor ͍\̂ɂ悢
struct KeyColor
{
	cchar	*m_key;
	cchar	*m_color;
} keyColorTable[] = {
	{"col_text",         "black"},
	{"col_background",   "white"},
	{"col_selText",      "white"},
	{"col_selBackground","darkblue"},
	//{"col_hereDocument", "violet"},
	{"col_keyword",      "blue"},
	{"col_userKeyword",  "blue"},
	{"col_method",       "blue"},
	{"col_instanceVar",  "blue"},
	{"col_classVar",     "blue"},
	{"col_globalVar",    "blue"},
	{"col_pseudoVar",    "blue"},
	{"col_symbol",       "blue"},
	{"col_constant",     "brown"},
	{"col_decimal",      "darkblue"},
	{"col_sqString",     "violet"},
	{"col_dqString",     "violet"},
	{"col_bqString",     "violet"},
	{"col_quote",        "lightpink"},
	{"col_escapedChar",  "lightpink"},
	{"col_regexp",       "violet"},
	{"col_comment",      "darkgreen"},
	{"col_lineNumber",   "black"},
	{"col_leftMargin",   "antiquewhite"},
	{"col_errorMark",    "red"},
};

//	J[͑債ł͂Ȃ̂ŁA`T邨
static int keyIndex(cchar *key)
{
	int ix = Settings::N_COLOR;
	while( --ix >= 0 ) {
		if( !strcmp(keyColorTable[ix].m_key, key) )
			break;
	}
	return ix;
}

bool Settings::saveColor(const QString &path) const
{
	QFile file(path);
	if( !file.open(QFile::WriteOnly) ) return false;
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QByteArray ba;
	for(int i = 0; i < N_COLOR; ++i) {
		ba += keyColorTable[i].m_key;
		ba += " = ";
		ba += codec->fromUnicode(m_colors[i].name());
		ba += "\n";
	}
	file.write(ba);
	return true;
}
bool Settings::loadColor(const QString &path)
{
	QFile file(path);
	if( !file.open(QFile::ReadOnly) ) return false;
	QByteArray ba = file.readAll();;
	QList<QByteArray> lst = ba.split('\n');
	//QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	foreach(const QByteArray &e, lst) {
		int ix = e.indexOf(" = ");
		if( ix < 0 ) continue;
		int ci = keyIndex(e.left(ix).data());
		if( ci >= 0 )
			m_colors[ci] = QColor(e.mid(ix + 3).data());
	}
	return true;
}
void Settings::writeSettings()
{
	QSettings settings;
	settings.setValue("tabWidth", m_tabWidth);
	settings.setValue("lineNumber", m_lineNumber ? 1 : 0);
	settings.setValue("softTab", m_softTab ? 1 : 0);
	//settings.setValue("errorEncoding", m_errorEncoding);
	settings.setValue("regexp", m_regexp ? 1 : 0);
	settings.setValue("ignoreCase", m_ignoreCase ? 1 : 0);
	settings.setValue("wordSearch", m_wordSearch ? 1 : 0);
	settings.setValue("fontFamily", m_fontFamily);
	settings.setValue("fontSize", m_fontSize);
	settings.setValue("findLoop", m_findLoop);
	settings.setValue("userKeywordFileName", m_userKeywordFileName);
	//settings.setValue("fileSystemRootPath", m_fileSystemRootPath);
	for(int i = 0; i < N_COLOR; ++i) {
		settings.setValue(keyColorTable[i].m_key, m_colors[i].name());
		//settings.setValue(colorKeys[i], m_colors[i].name());
	}
}
void Settings::readSettings()
{
	QSettings settings;
	m_tabWidth = settings.value("tabWidth", "2").toInt();
	m_lineNumber = settings.value("lineNumber", "0").toInt() != 0;
	m_softTab = settings.value("softTab", "0").toInt() != 0;
	//m_errorEncoding = settings.value("errorEncoding", "UTF-8").toString();
	m_regexp = settings.value("regexp", "0").toInt() != 0;
	m_ignoreCase = settings.value("ignoreCase", "1").toInt() != 0;
	m_wordSearch = settings.value("wordSearch", "0").toInt() != 0;
	m_fontFamily = settings.value("fontFamily", "Courier New").toString();
	m_fontSize = settings.value("fontSize", "12").toInt();
	m_findLoop = (uchar)settings.value("findLoop", "0").toInt();	//	0 for [vȂ
	m_userKeywordFileName = settings.value("userKeywordFileName", "keyword.txt").toString();
	//m_fileSystemRootPath = settings.value("fileSystemRootPath", "/").toString();
	setupUserKeywordHash();
	for(int i = 0; i < N_COLOR; ++i)
		m_colors[i] = QColor(settings.value(keyColorTable[i].m_key,
											keyColorTable[i].m_color).toString());
	m_findStringList = settings.value("findStrings").toStringList();
	m_replaceStringList = settings.value("replaceStrings").toStringList();
}
QString Settings::lastFindString() const
{
	if( m_findStringList.isEmpty() )
		return QString();
	else
		return m_findStringList[0];
}
//	ǉWXgۑ
void Settings::addFindString(const QString &text)
{
	int ix = m_findStringList.indexOf(text);
	if( ix >= 0 )
		m_findStringList.removeAt(ix);
	m_findStringList.push_front(text);
	while( m_findStringList.size() > N_FIND_STRINGS )
		m_findStringList.removeLast();
	QSettings settings;
	settings.setValue("findStrings", m_findStringList);
	settings.setValue("regexp", m_regexp ? 1 : 0);			//	K\IvVłɕۑ
	settings.setValue("ignoreCase", m_ignoreCase ? 1 : 0);
	settings.setValue("wordSearch", m_wordSearch ? 1 : 0);
}
void Settings::addReplaceString(const QString &text)
{
	int ix = m_replaceStringList.indexOf(text);
	if( ix >= 0 )
		m_replaceStringList.removeAt(ix);
	m_replaceStringList.push_front(text);
	while( m_replaceStringList.size() > N_FIND_STRINGS )
		m_replaceStringList.removeLast();
	QSettings settings;
	settings.setValue("replaceStrings", m_replaceStringList);
}
void Settings::setupUserKeywordHash()
{
	m_userKeywordHash.clear();
	if( m_userKeywordFileName.isEmpty() ) return;
	QString kwPath = m_userKeywordFileName;
	if( !QDir::isAbsolutePath(kwPath) ) {
		kwPath = QCoreApplication::applicationDirPath() + "/" + kwPath;
	}
	QFile file(kwPath);
	if( !file.open(QFile::ReadOnly) ) return;
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");	//	L[[ht@C̕R[h UTF8 Ɖ
	while( !file.atEnd() ) {
		QByteArray ba = file.readLine();
		if( ba.isEmpty() || (!isalpha(ba[0]) && ba[0] != '_') )
			continue;
		QString keyword = codec->toUnicode(ba).trimmed();
        //int len = keyword.length();
		m_userKeywordHash.insert(keyword, true);
	}
}
bool Settings::isUserKeyword(const QString &text) const
{
	return m_userKeywordHash.find(text) != m_userKeywordHash.end();
}
