#pragma once

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QString>
#include <QStringList>
#include <QColor>
#include <QHash>

#define		MIN_FONT_SIZE		4
#define		MAX_FONT_SIZE		100
#define		N_FIND_STRINGS		20

struct Settings
{
public:
	enum {
		TEXT,
		BACKGROUND,
		SEL_TEXT,
		SEL_BACKGROUND,
		//HERE_DOCUMENT,	//	<<[-]ʎq ` ʎq
		KEYWORD,
		USER_KEYWORD,
		METHOD,
		INSTANCE_VAR,	//	@hoge
		CLASS_VAR,		//	@@hoge
		GLOBAL_VAR,		//	$hoge
		PSEUDO_VAR,		//	self, nill, true, false, __FILE__ Ȃ
		SYMBOL,			//	:hoge
		CONSTANT,
		DECIMAL,
		SQ_STRING,
		DQ_STRING,
		BQ_STRING,
		QUOTE,			//	" ' %Q( ) Ȃǂ̃NH[g
		ESC_CHAR,		//	\n Ȃǂ̃GXP[vꂽ
		REGEXP,
		COMMENT,
		LINE_NUMBER,
		LEFT_MARGIN,
		ERROR_MARK,

		N_COLOR,		//	F
	};
	enum {
		FIND_NO_LOOP = 0,
		FIND_CONFIRM_LOOP,
		FIND_LOOP,
	};
public:
	Settings(void);
	~Settings(void);

public:
	QColor	color(int ix) const { return m_colors[ix]; }
	QString lastFindString() const;
	const QStringList	&findStringList() const { return m_findStringList; }
	const QStringList	&replaceStringList() const { return m_replaceStringList; }
	bool	isUserKeyword(const QString &) const;
	bool	saveColor(const QString &) const;

public:
	void	setColor(int ix, const QColor &col);
	void	addFindString(const QString &);		//	ǉWXgۑ
	void	addReplaceString(const QString &);		//	ǉWXgۑ
	void	setupUserKeywordHash();				//	[UL[[hnbVXV
	bool	loadColor(const QString &);

public:
    void	readSettings();
    void	writeSettings();

protected:

public:
    bool		m_lineNumber;	//	sԍ\
    bool		m_softTab;
    bool		m_regexp;		//	K\
    bool		m_ignoreCase;	//	p啶ꎋ
    bool		m_wordSearch;	//	Pꌟi񐳋K\̎̂ݗLj
    uchar		m_findLoop;
    //QString		m_errorEncoding;	//	G[o͂̕GR[fBO
    int			m_tabWidth;
	QString		m_fontFamily;
	int			m_fontSize;
	QString		m_userKeywordFileName;
	//QString		m_fileSystemRootPath;	//	t@CVXe[gpX
	QColor		m_colors[N_COLOR];
	QStringList	m_findStringList;
	QStringList	m_replaceStringList;
	QHash<QString, bool>	m_userKeywordHash;
};

