/*
 * zipModel.scala
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package mongodb

import com.mongodb._
import com.osinka.mongodb._
import com.osinka.mongodb.Preamble._
import com.osinka.mongodb.shape._

class Zip(val jis:String, val zip_old:String, val zip:String,
          val addr1_kana:String, val addr2_kana:String, val addr3_kana:String,
          val addr1:String, val addr2:String, val addr3:String,
          val c1:Int, val c2:Int, val c3:Int, val c4:Int, val c5:Int, val c6:Int) {

    override def toString  = List(jis, zip_old, zip,
                                  addr1_kana, addr2_kana, addr3_kana,
                                  addr1, addr2, addr3,
                                  c1, c2, c3, c4, c5, c6).mkString(", ")
}

object Zip extends ObjectShape[Zip]  {

    lazy val jis = Field.scalar("jis", _.jis)
    lazy val zip_old = Field.scalar("zip_old", _.zip_old)
    lazy val zip = Field.scalar("zip", _.zip)
    lazy val addr1_kana = Field.scalar("addr1_kana", _.addr1_kana)
    lazy val addr2_kana = Field.scalar("addr2_kana", _.addr2_kana)
    lazy val addr3_kana = Field.scalar("addr3_kana", _.addr3_kana)
    lazy val addr1 = Field.scalar("addr1", _.addr1)
    lazy val addr2 = Field.scalar("addr2", _.addr2)
    lazy val addr3 = Field.scalar("addr3", _.addr3)
    lazy val c1 = Field.scalar("c1", _.c1)
    lazy val c2 = Field.scalar("c2", _.c2)
    lazy val c3 = Field.scalar("c3", _.c3)
    lazy val c4 = Field.scalar("c4", _.c4)
    lazy val c5 = Field.scalar("c5", _.c5)
    lazy val c6 = Field.scalar("c6", _.c6)

    override def * = List(jis, zip_old, zip,
                          addr1_kana, addr2_kana, addr3_kana,
                          addr1, addr2, addr3,
                          c1, c2, c3, c4, c5, c6)

    override def factory(dbo: DBObject) =
    for {jis(jis) <- Some(dbo)
         zip_old(zip_old) <- Some(dbo)
         zip(zip) <- Some(dbo)
         addr1_kana(addr1_kana) <- Some(dbo)
         addr2_kana(addr2_kana) <- Some(dbo)
         addr3_kana(addr3_kana) <- Some(dbo)
         addr1(addr1) <- Some(dbo)
         addr2(addr2) <- Some(dbo)
         addr3(addr3) <- Some(dbo)
         c1(c1) <- Some(dbo)
         c2(c2) <- Some(dbo)
         c3(c3) <- Some(dbo)
         c4(c4) <- Some(dbo)
         c5(c5) <- Some(dbo)
         c6(c6) <- Some(dbo)
    }
    yield new Zip(jis, zip_old , zip,
                  addr1_kana, addr2_kana, addr3_kana,
                  addr1, addr2, addr3,
                  c1, c2, c3, c4, c5, c6)
}
