
// 郵便番号データは
// http://www.post.japanpost.jp/zipcode/download.html
// から download して、
// $ nkf -Sw -Lu として、utf-8, 半角カナ -> 全角カナ 変換して使う。
//
// http://localhost:28017/test/zipcodes/?limit=-5 とすれば、最初の5 件を確認できる。
//

package mongodb

import scala.io.Source
import com.mongodb._
import com.osinka.mongodb._
import com.osinka.mongodb.Preamble._
import com.osinka.mongodb.shape._

object importZip2 {

    val FILE_PATH = "./data/zipcode/1.csv"
    val DB_PORT = 27017
    val DB_NAME = "test"
    val COLLECTION_NAME = "zipcodes"

    // "foo" なら foo を返す
    def strip(line:String) = {
        if (line.length < 2) line
        else if ((line.charAt(0) == '\"') && (line.charAt(line.length - 1) == '\"')) line.substring(1, line.length -1)
        else line
    }

    def main(args: Array[String]) {

        val stat=System.nanoTime()
        action()
        val end = System.nanoTime
        println("time(s):" + 1.0 * (end - stat) /(1000 * 1000 * 1000) )
    }

    def action():Unit = {

        val mongo = new Mongo("localhost", DB_PORT).getDB(DB_NAME)
        val dbColl = mongo.getCollection(COLLECTION_NAME)

        dbColl.drop
        val zipcodes = dbColl.of(Zip)

        var count = 0
        var record = Array[String]()

        Source.fromFile(FILE_PATH).getLines.foreach { line =>
            val a = line.trim.split(",")

            // 複数行分割されている場合に対応
            if (a.size == 15) {
                record = a
            } else {
                println(line)
                println(a.size)
                record ++= a
            }
            if (record.size >= 15) {
                val zip = new Zip(
                    strip(record(0)),
                      strip(record(1)),
                      strip(record(2)),
                      strip(record(3)),
                      strip(record(4)),
                      strip(record(5)),
                      strip(record(6)),
                      strip(record(7)),
                      strip(record(8)),
                      Integer.parseInt(record(9)),
                      Integer.parseInt(record(10)),
                      Integer.parseInt(record(11)),
                      Integer.parseInt(record(12)),
                      Integer.parseInt(record(13)),
                      Integer.parseInt(record(14)),
                )

                //println(zip.toString)
                zipcodes += zip
                record = Array[String]()
                count += 1
                if (count % 10000 == 0) println("done ... " + count )
            }
        }
        println("count=" + count)
    }
    // done ... 10000
    //
    // done ... 110000
    // done ... 120000
    // count=122866
    // time(s):40.942348
}

