/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredDatanodeException;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.FileDataServlet;
import org.apache.hadoop.hdfs.server.namenode.FsckServlet;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.ListPathsServlet;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ConfiguredPolicy;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class NameNode
implements ClientProtocol,
DatanodeProtocol,
NamenodeProtocol,
FSConstants,
RefreshAuthorizationPolicyProtocol {
    public static final int DEFAULT_PORT = 8020;
    public static final Log LOG;
    public static final Log stateChangeLog;
    public FSNamesystem namesystem;
    private Server server;
    private InetSocketAddress serverAddress = null;
    private HttpServer httpServer;
    private InetSocketAddress httpAddress = null;
    private Thread emptier;
    private boolean stopRequested = false;
    private boolean serviceAuthEnabled = false;
    static NameNodeMetrics myMetrics;

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 41L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 19L;
        }
        if (protocol.equals(NamenodeProtocol.class.getName())) {
            return 2L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, false);
    }

    public FSNamesystem getNamesystem() {
        return this.namesystem;
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return myMetrics;
    }

    public static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr(address, 8020);
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        return NameNode.getAddress(FileSystem.getDefaultUri(conf).getAuthority());
    }

    public static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    private void initialize(Configuration conf) throws IOException {
        InetSocketAddress socAddr = NameNode.getAddress(conf);
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            PolicyProvider policyProvider = ReflectionUtils.newInstance(conf.getClass("hadoop.security.authorization.policyprovider", HDFSPolicyProvider.class, PolicyProvider.class), conf);
            SecurityUtil.setPolicy(new ConfiguredPolicy(conf, policyProvider));
        }
        this.server = RPC.getServer(this, socAddr.getHostName(), socAddr.getPort(), handlerCount, false, conf);
        this.serverAddress = this.server.getListenerAddress();
        FileSystem.setDefaultUri(conf, NameNode.getUri(this.serverAddress));
        LOG.info((Object)("Namenode up at: " + this.serverAddress));
        myMetrics = new NameNodeMetrics(conf, this);
        this.namesystem = new FSNamesystem(this, conf);
        this.startHttpServer(conf);
        this.server.start();
        this.startTrashEmptier(conf);
    }

    private void startTrashEmptier(Configuration conf) throws IOException {
        this.emptier = new Thread(new Trash(conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void startHttpServer(Configuration conf) throws IOException {
        int infoPort;
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.info.bindAddress", "dfs.info.port", "dfs.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String infoHost = infoSocAddr.getHostName();
        this.httpServer = new HttpServer("hdfs", infoHost, infoPort, (infoPort = infoSocAddr.getPort()) == 0, conf);
        if (conf.getBoolean("dfs.https.enable", false)) {
            boolean needClientAuth = conf.getBoolean("dfs.https.need.client.auth", false);
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(conf.get("dfs.https.address", infoHost + ":" + 0));
            Configuration sslConf = new Configuration(false);
            sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
            this.httpServer.addSslListener(secInfoSocAddr, sslConf, needClientAuth);
            InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr(conf.get("dfs.datanode.https.address", infoHost + ":" + 50475));
            this.httpServer.setAttribute("datanode.https.port", datanodeSslPort.getPort());
        }
        this.httpServer.setAttribute("name.node", this);
        this.httpServer.setAttribute("name.node.address", this.getNameNodeAddress());
        this.httpServer.setAttribute("name.system.image", this.getFSImage());
        this.httpServer.setAttribute("name.conf", conf);
        this.httpServer.addInternalServlet("fsck", "/fsck", FsckServlet.class);
        this.httpServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class);
        this.httpServer.addInternalServlet("listPaths", "/listPaths/*", ListPathsServlet.class);
        this.httpServer.addInternalServlet("data", "/data/*", FileDataServlet.class);
        this.httpServer.addInternalServlet("checksum", "/fileChecksum/*", FileChecksumServlets.RedirectServlet.class);
        this.httpServer.start();
        infoPort = this.httpServer.getPort();
        this.httpAddress = new InetSocketAddress(infoHost, infoPort);
        conf.set("dfs.http.address", infoHost + ":" + infoPort);
        LOG.info((Object)("Web-server up at: " + infoHost + ":" + infoPort));
    }

    public NameNode(Configuration conf) throws IOException {
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.stopRequested) {
            return;
        }
        this.stopRequested = true;
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException(e));
        }
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.emptier != null) {
            this.emptier.interrupt();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (myMetrics != null) {
            myMetrics.shutdown();
        }
        if (this.namesystem != null) {
            this.namesystem.shutdown();
        }
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        return this.namesystem.getBlocks(datanode, size);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        NameNode.myMetrics.numGetBlockLocations.inc();
        return this.namesystem.getBlockLocations(NameNode.getClientMachine(), src, offset, length);
    }

    private static String getClientMachine() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public void create(String src, FsPermission masked, String clientName, boolean overwrite, short replication, long blockSize) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.startFile(src, new PermissionStatus(UserGroupInformation.getCurrentUGI().getUserName(), null, masked), clientName, clientMachine, overwrite, replication, blockSize);
        NameNode.myMetrics.numFilesCreated.inc();
        NameNode.myMetrics.numCreateFileOps.inc();
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine));
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        NameNode.myMetrics.numFilesAppended.inc();
        return info;
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " for " + clientName));
        LocatedBlock locatedBlock = this.namesystem.getAdditionalBlock(src, clientName);
        if (locatedBlock != null) {
            NameNode.myMetrics.numAddBlockOps.inc();
        }
        return locatedBlock;
    }

    @Override
    public void abandonBlock(Block b, String src, String holder) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src));
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " for " + clientName));
        FSNamesystem.CompleteFileStatus returnCode = this.namesystem.completeFile(src, clientName);
        if (returnCode == FSNamesystem.CompleteFileStatus.STILL_WAITING) {
            return false;
        }
        if (returnCode == FSNamesystem.CompleteFileStatus.COMPLETE_SUCCESS) {
            return true;
        }
        throw new IOException("Could not complete write to file " + src + " by " + clientName);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        stateChangeLog.info((Object)"*DIR* NameNode.reportBadBlocks");
        for (int i = 0; i < blocks.length; ++i) {
            Block blk = blocks[i].getBlock();
            DatanodeInfo[] nodes = blocks[i].getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                DatanodeInfo dn = nodes[j];
                this.namesystem.markBlockAsCorrupt(blk, dn);
            }
        }
    }

    @Override
    public long nextGenerationStamp(Block block) throws IOException {
        return this.namesystem.nextGenerationStampForBlock(block);
    }

    @Override
    public void commitBlockSynchronization(Block block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    @Override
    public boolean rename(String src, String dst) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            NameNode.myMetrics.numFilesRenamed.inc();
        }
        return ret;
    }

    @Override
    @Deprecated
    public boolean delete(String src) throws IOException {
        return this.delete(src, true);
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive));
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            NameNode.myMetrics.numDeleteFileOps.inc();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(UserGroupInformation.getCurrentUGI().getUserName(), null, masked));
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    @Override
    public FileStatus[] getListing(String src) throws IOException {
        FileStatus[] files = this.namesystem.getListing(src);
        if (files != null) {
            NameNode.myMetrics.numGetListingOps.inc();
        }
        return files;
    }

    @Override
    public FileStatus getFileInfo(String src) throws IOException {
        NameNode.myMetrics.numFileInfoOps.inc();
        return this.namesystem.getFileInfo(src);
    }

    @Override
    public long[] getStats() throws IOException {
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(FSConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    @Override
    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namesystem.setSafeMode(action);
    }

    public boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    @Override
    public void saveNamespace() throws IOException {
        this.namesystem.saveNamespace();
    }

    @Override
    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes(new Configuration());
    }

    @Override
    public long getEditLogSize() throws IOException {
        return this.namesystem.getEditLogSize();
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        return this.namesystem.rollEditLog();
    }

    @Override
    public void rollFsImage() throws IOException {
        this.namesystem.rollFSImage();
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        this.namesystem.finalizeUpgrade();
    }

    @Override
    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.namesystem.distributedUpgradeProgress(action);
    }

    @Override
    public void metaSave(String filename) throws IOException {
        this.namesystem.metaSave(filename);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.namesystem.setQuota(path, namespaceQuota, diskspaceQuota);
    }

    @Override
    public void fsync(String src, String clientName) throws IOException {
        this.namesystem.fsync(src, clientName);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public DatanodeRegistration register(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public DatanodeCommand[] sendHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xmitsInProgress, int xceiverCount) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, capacity, dfsUsed, remaining, xceiverCount, xmitsInProgress);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, long[] blocks) throws IOException {
        this.verifyRequest(nodeReg);
        BlockListAsLongs blist = new BlockListAsLongs(blocks);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg.getName() + " " + blist.getNumberOfBlocks() + " blocks"));
        this.namesystem.processReport(nodeReg, blist);
        if (this.getFSImage().isUpgradeFinalized()) {
            return DatanodeCommand.FINALIZE;
        }
        return null;
    }

    @Override
    public void blockReceived(DatanodeRegistration nodeReg, Block[] blocks, String[] delHints) throws IOException {
        this.verifyRequest(nodeReg);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceived: from " + nodeReg.getName() + " " + blocks.length + " blocks."));
        for (int i = 0; i < blocks.length; ++i) {
            this.namesystem.blockReceived(nodeReg, blocks[i], delHints[i]);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName = nodeReg == null ? "unknown DataNode" : nodeReg.getName();
        LOG.info((Object)("Error report from " + dnName + ": " + msg));
        if (errorCode == 0) {
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            this.namesystem.removeDatanode(nodeReg);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public UpgradeCommand processUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.namesystem.processDistributedUpgradeCommand(comm);
    }

    public void verifyRequest(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            throw new UnregisteredDatanodeException(nodeReg);
        }
    }

    public void verifyVersion(int version) throws IOException {
        if (version != -18) {
            throw new IncorrectVersionException(version, "data node");
        }
    }

    public File getFsImageName() throws IOException {
        return this.getFSImage().getFsImageName();
    }

    public FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    public File[] getFsImageNameCheckpoint() throws IOException {
        return this.getFSImage().getFsImageNameCheckpoint();
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.serverAddress;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    NetworkTopology getNetworkTopology() {
        return this.namesystem.clusterMap;
    }

    private static boolean format(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<File> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        Collection<File> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        for (File curDir : dirsToFormat) {
            if (!curDir.exists() || !isConfirmationNeeded) continue;
            System.err.print("Re-format filesystem in " + curDir + " ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Format aborted in " + curDir);
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat, editDirsToFormat), conf);
        nsys.dir.fsImage.format();
        return false;
    }

    private static boolean finalize(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<File> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        Collection<File> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat, editDirsToFormat), conf);
        System.err.print("\"finalize\" will remove the previous state of the files system.\nRecent upgrade will become permanent.\nRollback option will not be available anymore.\n");
        if (isConfirmationNeeded) {
            System.err.print("Finalize filesystem state ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Finalize aborted.");
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        nsys.dir.fsImage.finalizeUpgrade();
        return false;
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        SecurityUtil.getPolicy().refresh();
    }

    private static void printUsage() {
        System.err.println("Usage: java NameNode [" + HdfsConstants.StartupOption.FORMAT.getName() + "] | [" + HdfsConstants.StartupOption.UPGRADE.getName() + "] | [" + HdfsConstants.StartupOption.ROLLBACK.getName() + "] | [" + HdfsConstants.StartupOption.FINALIZE.getName() + "] | [" + HdfsConstants.StartupOption.IMPORT.getName() + "]");
    }

    private static HdfsConstants.StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        HdfsConstants.StartupOption startOpt = HdfsConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (HdfsConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.FORMAT;
                continue;
            }
            if (HdfsConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.REGULAR;
                continue;
            }
            if (HdfsConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.UPGRADE;
                continue;
            }
            if (HdfsConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (HdfsConstants.StartupOption.FINALIZE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.FINALIZE;
                continue;
            }
            if (HdfsConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.IMPORT;
                continue;
            }
            return null;
        }
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, HdfsConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.toString());
    }

    static HdfsConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", HdfsConstants.StartupOption.REGULAR.toString()));
    }

    public static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        HdfsConstants.StartupOption startOpt;
        if (conf == null) {
            conf = new Configuration();
        }
        if ((startOpt = NameNode.parseArguments(argv)) == null) {
            NameNode.printUsage();
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        switch (startOpt) {
            case FORMAT: {
                boolean aborted = NameNode.format(conf, true);
                System.exit(aborted ? 1 : 0);
            }
            case FINALIZE: {
                boolean aborted = NameNode.finalize(conf, true);
                System.exit(aborted ? 1 : 0);
            }
        }
        NameNode namenode = new NameNode(conf);
        return namenode;
    }

    public static void main(String[] argv) throws Exception {
        try {
            StringUtils.startupShutdownMessage(NameNode.class, argv, LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        LOG = LogFactory.getLog((String)NameNode.class.getName());
        stateChangeLog = LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange");
    }
}

