#-*- coding: utf-8; -*-

# 2009-09-01 katoy
#  EDINET 企業コードの zip ファイルを yaml 形式に変換する。
#
# ruby 1.8.7 (2009-06-12 patchlevel 174) [i686-darwin9]
# zipruby (0.3.2)
# fastercsv (1.5.0)
# ya2yaml (0.26)
#
# 変更履歴:
#

require 'rubygems'
require 'pp'
require 'zipruby'        # gem install
require 'open-uri'
# require 'openssl'
require "kconv"
require 'fastercsv'      # gem install
require 'yaml'
require 'ya2yaml'        # gem install
require 'pathname'
require 'benchmark'

$KCODE = 'utf8'
# URL = 'https://info.edinet-fsa.go.jp/download/EDINET_CODE_OLDandNEW.zip'

# watir などをつかって 自動download するべき。
ZIP_FILE = 'EDINET_CODE_20090831.zip'

#module OpenSSL
#  module SSL
#    remove_const :VERIFY_PEER
#  end
#end
#OpenSSL::SSL::VERIFY_PEER = OpenSSL::SSL::VERIFY_NONE

def read_edinetcode
  list = {}
  open(ZIP_FILE) do | zipFile |
    Zip::Archive.open_buffer(zipFile.read) do | ar |
      ar.fopen(ar.get_name(0)) do | file |
        FasterCSV.parse(file.read.toutf8) do |row|
          if (row[2] != '件数')
            list[row[1]] = {:code => row[0], :address => row[2]}
          end
        end
      end
    end
  end
  list
end

def usage
  puts "usage: ruby #{__FILE__} [n]"
end

puts Benchmark.measure {
  list = read_edinetcode

  puts "Data count = #{list.size}"
  
  # データ保存
  puts "save to edinet.yml"
  open("edinet.yml", "w") do |w|
    # YAML::dump(list, w)
    w.puts(list.ya2yaml)
  end

  # データ読み込みの確認
  File.open( 'edinet.yml' ) do |io|
    YAML.load_documents(io){|data|
      puts "Data count = #{data.size}"
    }
  end

}

#--- End of File ---
