
# 企業のグラフを閲覧する為の html ファイルを生成する。

require 'rubygems'
require 'erb'
require 'open-uri'
require 'kconv'
require 'ya2yaml'
require 'pp'
require 'benchmark'

$KCODE = 'utf8'

class Table

  @@TEMPLATE_PAGE = ERB.new <<EOS, nil, '-'

<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><%= title %></title>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
        <link rel="stylesheet" href="style.css" type="text/css" />

        <!-- This includes the ImageFlow CSS and JavaScript -->
        <link rel="stylesheet" href="imageflow.packed.css" type="text/css" />
        <script type="text/javascript" src="imageflow.packed.js"></script>

    </head>
    <body>
        <h1><%= title %></h1>

        <!-- This is all the XHTML ImageFlow needs -->
        <div id="myImageFlow" class="imageflow">

<% ids.each do |info| -%>
  <img src='images/big/<%= info[0] %>.png' longdesc='images/big/<%= info[0] %>.png' alt='<%= info[1] %>'/>
<% end -%>

        </div>
    </body>
<html>
EOS

  @@TEMPLATE_INDEX = ERB.new <<EOS, nil, '-'

<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><%= title %></title>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    </head>
    <body>
        <h1><%= title %></h1>

<table border="0">
<% pages.each_with_index do |page, indx| -%>
<%   if indx % 5 == 0 -%>
  <tr>
<%   end -%>
  <td>
      <a href='<%= page[0] %>'><%= page[1] %></a>
  </td>
<%   if indx % 5 == 4 -%>
  </tr>
<%   end -%>
<% end -%>

        </table>
    </body>
<html>
EOS

  # id 別の top ページをつくる
  def get_index_by_range(title)
    pages = []
    1.upto(9).each do |id|
      pages << ["index-#{id}000.html", "#{(id * 1000).to_s}番台" ]
    end
    @@TEMPLATE_INDEX.result binding
  end

  # id 別のページをつくる
  def get_page_by_range(title, min, max, cid_list)
    ids = []
    min.upto(max).each do |id|
      # data/*.yaml が存在しているものだけを対象にする
      ids << [id, "#{id}:#{cid_list[id]}"] if File.exists?("data/#{id}.yaml")
    end
    @@TEMPLATE_PAGE.result binding
  end

  # 業種別の top ページをつくる
  def get_index_by_category(title, list)
    pages = []
    list.each do |k, v|
      pages << ["index-t#{v[:cid]}.html", "#{v[:cid]}: #{k}"]
    end
    pages.sort!{|x, y| x[0] <=> y[0]}
    @@TEMPLATE_INDEX.result binding
  end

  # 業種別のページをつくる
  def get_page_by_category(title, vals)
    ids = vals.to_a.sort  {|x, y| x[0] <=> y[0]}
    ids.map!{|v| [ v[0], "#{v[0]}:#{v[1]}"] }
    @@TEMPLATE_PAGE.result binding
  end

end

# 企業一覧データを読み込む。
def load_categorylist
  obj = nil
  File.open( "cprofile/categorylist.yaml" ) { |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

# 企業一覧データから [id => name] の hash を作る
def make_cid_list(list)
  cid_list = {}
  list.each do |k,v|
    v[:list].each do |data|
      cid_list[data[0].to_i] = data[1]
    end
  end
  cid_list
end

# id 別のページ群をつくる
def make_by_id(list, cid_list)
  (1..9).each do |i|
    data = Table.new.get_page_by_range("#{i*1000}番台", i * 1000, i * 1000 + 999, cid_list)

    File.open("html/index-#{i}000.html", 'w') { |file|
      file.write(data)
    }
  end

  data = Table.new.get_index_by_range("id 別")
  File.open("html/index-by-id.html", 'w') { |file|
    file.write(data)
  }
end

# 業種別のページ群をつくる
def make_by_category(list, cid_list)
  list.each do |key, val|
    data = Table.new.get_page_by_category(key, val[:list])

    File.open("html/index-t#{val[:cid]}.html", 'w') { |file|
      file.write(data)
    }
  end

  data = Table.new.get_index_by_category("業種別", list)
  File.open("html/index-by-category.html", 'w') { |file|
    file.write(data)
  }
end

puts Benchmark.measure {
  list = load_categorylist
  cid_list = make_cid_list(list)

  make_by_id(list, cid_list)
  make_by_category(list, cid_list)
}
