// See
// - http://homepage3.nifty.com/j_town/javascript/jscripttype.html
//   JavaScriptタイピング

var hira2roma = new MYAPP.katoy.typing.hira2roma();

MYAPP.namespace('MYAPP.katoy.typeing.typing');

var status = -1, // -1: out of lesson, other: lesson_No.
mondai_hira = [],
mondai_kanji = [];

function init() {

    var mondailist = '' +
    '1:キャッシング|きゃっしんぐ 近未来|きんみらい キャンドル|きゃんどる,' +
    '2:フュージョン|ふゅーじょん 撤退|てったい 逆転|ぎゃくてん,' +
    '3:キャット|きゃっと ほっかぶり|ほっかぶり キットカット|きっとかっと,',
    count = 0,
    ns = mondailist.replace(/^\s+|\s+$/g, '').split(',');

    for (var i = 0, len = ns.length; i < len; i++) {
        var s = ns[i].replace(/^\s+|\s+$/g, '');
        if (s.length > 0) {
            var ss = s.split(':');
            var id = ss[0].replace(/^\s+|\s+$/g, '');
            var ws = ss[1].replace(/^\s+|\s+$/g, '').split(' ');
            for (var j = 0, len2 = ws.length; j < len2; j++) {
                var w = ws[j].split('|');

                mondai_kanji[count] = w[0].replace(/^\s+|\s+$/g, '');
                mondai_hira[count] = w[1].replace(/^\s+|\s+$/g, '');
                count += 1;
            }
        }
    }
}

function break_lesson() {
    $('#sirei').html('ENTERキーを押す または [開始]をクリックすると再スタートします。');
    $('#lesson').html('');
    $('#input').html('');
    $('#hira').html('');
    $('#kana').html('');

    $('#break').html('開始');
    $('#skip').addClass('disable');
    $('#clear').addClass('disable');
}

function go_ahead_problem() {

    function get_question() {
        var quest = [];
        if (mondai_hira.length > 0) {
            var rand = Math.floor(Math.random() * mondai_hira.length);
            quest[0] = mondai_hira[rand];
            quest[1] = mondai_kanji[rand];
        }
        return quest;
    }

    var q = get_question();
    if (q.length > 0) {
        $('#sirei').html('[' + q[1] + '] を入力してください。');
        $('#lesson').html(hira2roma.to_roma(q[0]));
        $('#input').html('');
        $('#hira').html('');
        $('#kana').html('');

        $('#break').html('終了');
        $('#skip').removeClass('disable');
        $('#clear').addClass('disable');
        return true;
    } else {
        break_lesson();
        return false;
    }
}

function start_lesson() {
    init();
    go_ahead_problem();
}

function action_ok(pos, mondai) {
    $('#clear').removeClass('disable');

    var str = $('#input').html() + mondai.charAt(pos);
    $('#input').html(str);
    $('#hira').html(hira2roma.to_hira(str));
    $('#kana').html(hira2roma.to_kana(str));

    if (pos >= mondai.length - 1) {

        // 終了した問題は削除する
        var len = mondai_hira.length - 1;

        for (var i = len; i >= 0; i--) {
            if (hira2roma.to_roma(mondai_hira[i]) == mondai) {
                mondai_hira.splice(i, 1);
                mondai_kanji.splice(i, 1);
            }
        }
        go_ahead_problem();
    }
    return mondai_hira.length > 0;
}

function action_error(pos, mondai) {
    return true;
}

function check_keydown(e) {

    if (status == -1) {
        if (e.which == 13) {
            start_lesson();
            status = 0;
        }
    } else {
        var mondai = $('#lesson').html();
        var pos = $('#input').html().length;
        var can_lesson = true;
        if (String.fromCharCode(e.which) == mondai.charAt(pos)) {
            can_lesson = action_ok(pos, mondai);
        } else if ((e.which == 109 || e.which == 189) &&
            mondai.charAt(pos) == '-') {
            //伸ばし棒を正解にする為の処理 (Firefox: 109, safari :189)
            can_lesson = action_ok(pos, mondai);
        } else {
            action_error(pos, mondai);
        }
        if (!can_lesson) {
            status = -1;
        }
    }
}

$(function() {
    document.onkeydown = check_keydown;

    $('#clear').click(function() {
        // 入力行を空にする。
        if (status != -1) {
            $('#input').html('');
            $('#hira').html('');
            $('#kana').html('');
            $('#clear').addClass('disable');
        }
    });

    $('#skip').click(function() {
        // 次の問題へ。
        if (status != -1) {
            go_ahead_problem();
        }
    });

    $('#break').click(function() {
        if (status != -1) {
            // レッスンを終了
            break_lesson();
            status = -1;
        } else {
            // レッスンを開始
            start_lesson();
            status = 0;
        }
    });
});
